/*
 * Decompiled with CFR 0.152.
 */
package org.byted.security.zti.jwt.shaded.com.bytedance.metrics.simple;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.byted.security.zti.jwt.shaded.com.bytedance.metrics.MetricUtils;
import org.byted.security.zti.jwt.shaded.com.bytedance.metrics.NamedThreadFactory;
import org.byted.security.zti.jwt.shaded.com.bytedance.metrics.simple.SimpleByteTSDMetrics;
import org.byted.security.zti.jwt.shaded.com.bytedance.metrics.simple.sender.Command;
import org.byted.security.zti.jwt.shaded.com.bytedance.metrics.simple.sender.MetricType;
import org.byted.security.zti.jwt.shaded.com.bytedance.metrics.simple.sender.Sender;
import org.byted.security.zti.jwt.shaded.org.slf4j.Logger;
import org.byted.security.zti.jwt.shaded.org.slf4j.LoggerFactory;

class SimpleByteTSDMetricsImpl
extends SimpleByteTSDMetrics {
    private static final Logger LOG = LoggerFactory.getLogger(SimpleByteTSDMetricsImpl.class);
    private final String prefix;
    private final Sender sender;
    private final int maxPendingSize;
    private final BlockingQueue<Command> buffer;
    private final boolean blockOnBufferFull;
    private final AtomicLong dropped = new AtomicLong();
    private static final long DROPPED_REPORT_INTERVAL_MS = TimeUnit.MINUTES.toMillis(5L);
    private static final long DROPPED_MINIMAL_REPORT = 100L;
    private volatile long droppedNextReport = System.currentTimeMillis() + DROPPED_REPORT_INTERVAL_MS;
    private Map<String, String> globalTags;

    SimpleByteTSDMetricsImpl(Sender sender, int maxPendingSize, String prefix, boolean blockOnBufferFull, int emitIntervalMs, Map<String, String> globalTags) {
        if (prefix == null || prefix.isEmpty()) {
            throw new IllegalArgumentException("empty prefix is invalid");
        }
        this.prefix = prefix;
        this.sender = sender;
        this.maxPendingSize = maxPendingSize;
        this.buffer = new ArrayBlockingQueue<Command>(maxPendingSize);
        this.blockOnBufferFull = blockOnBufferFull;
        this.globalTags = globalTags;
        Executors.newSingleThreadExecutor(new NamedThreadFactory("metrics4j-simplebytetsd-flush", true)).submit(new Flusher(emitIntervalMs));
    }

    @Override
    public void emitStore(String metric, double value, String tags) {
        this.emit(MetricType.STORE, metric, value, tags, -1L);
    }

    @Override
    public void emitTsStore(String metric, double value, String tags, long timestamp) {
        this.emit(MetricType.STORE, metric, value, tags, timestamp);
    }

    @Override
    public void emitTimer(String metric, double value, String tags) {
        this.emit(MetricType.TIMER, metric, value, tags, -1L);
    }

    @Override
    public void emitCounter(String metric, double value, String tags) {
        this.emit(MetricType.COUNTER, metric, value, tags, -1L);
    }

    @Override
    public void emitRateCounter(String metric, double value, String tags) {
        this.emit(MetricType.RATE_COUNTER, metric, value, tags, -1L);
    }

    @Override
    public void emitMeter(String metric, double value, String tags) {
        this.emit(MetricType.METER, metric, value, tags, -1L);
    }

    private void emit(MetricType type, String metric, double value, String tags, long timestamp) {
        if (metric == null || metric.isEmpty()) {
            LOG.error("metric is required");
            return;
        }
        if (!SimpleByteTSDMetrics.validateTagsV2(tags)) {
            return;
        }
        if (tags != null && !tags.isEmpty()) {
            tags = tags.replace(',', '|').substring(1, tags.length() - 1);
        }
        for (Map.Entry<String, String> entry : this.globalTags.entrySet()) {
            tags = MetricUtils.stringEmpty(tags) ? entry.getKey() + "=" + entry.getValue() : tags + "|" + entry.getKey() + "=" + entry.getValue();
        }
        if ((double)timestamp > 1.0E11) {
            timestamp /= 1000L;
        }
        if (timestamp > 0L) {
            timestamp = timestamp / 30L * 30L;
        }
        if (!this.buffer.offer(new Command(type, this.prefix + metric, value, tags, timestamp))) {
            if (this.blockOnBufferFull) {
                try {
                    this.buffer.put(new Command(type, this.prefix + metric, value, tags, timestamp));
                }
                catch (InterruptedException e) {
                    LOG.error("send metrics interrupted", e);
                }
            } else if (this.dropped.incrementAndGet() > 100L && System.currentTimeMillis() > this.droppedNextReport) {
                LOG.warn("{} data points are dropped in SimpleByteTSDMetrics last 5m", (Object)this.dropped.getAndSet(0L));
                this.droppedNextReport = System.currentTimeMillis() + DROPPED_REPORT_INTERVAL_MS;
            }
        }
    }

    class Flusher
    implements Runnable {
        private final List<Command> commands;
        private final int emitIntervalMs;

        public Flusher(int pollIntervalSec) {
            this.commands = new ArrayList<Command>(SimpleByteTSDMetricsImpl.this.maxPendingSize);
            this.emitIntervalMs = pollIntervalSec;
        }

        @Override
        public void run() {
            long nextFlush = System.currentTimeMillis() + (long)this.emitIntervalMs;
            while (!Thread.interrupted()) {
                try {
                    Command cmd = (Command)SimpleByteTSDMetricsImpl.this.buffer.poll(this.emitIntervalMs, TimeUnit.MILLISECONDS);
                    if (cmd != null) {
                        this.commands.add(cmd);
                        SimpleByteTSDMetricsImpl.this.buffer.drainTo(this.commands, SimpleByteTSDMetricsImpl.this.maxPendingSize - this.commands.size());
                    }
                    if (System.currentTimeMillis() <= nextFlush && this.commands.size() != SimpleByteTSDMetricsImpl.this.maxPendingSize) continue;
                    this.flush();
                    nextFlush = System.currentTimeMillis() + (long)this.emitIntervalMs;
                }
                catch (InterruptedException e) {
                    LOG.warn("send metrics interrupted", e);
                }
                catch (IOException e) {
                    LOG.warn("send metrics failed", e);
                }
            }
        }

        public void flush() throws IOException {
            SimpleByteTSDMetricsImpl.this.sender.send(this.commands.toArray(new Command[0]));
            this.commands.clear();
        }
    }
}

