/*
 * Decompiled with CFR 0.152.
 */
package org.byted.security.zti.jwt.shaded.com.bytedance.metrics.udpclient;

import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.byted.security.zti.jwt.shaded.com.bytedance.metrics.udpclient.MetricsClient;
import org.byted.security.zti.jwt.shaded.org.slf4j.Logger;
import org.byted.security.zti.jwt.shaded.org.slf4j.LoggerFactory;

public abstract class BaseUnixClient
extends MetricsClient
implements Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseUnixClient.class);
    private static final String METRIC_SERVER2_SIDECAR_KEY = "METRICSERVER2_SIDECAR";
    private static final String METRIC_SERVER2_SIDECAR_VALUE = "1";
    protected static final int MAX_ATTEMPT_NUMBER = 3;
    protected static final int socketTimeout = 100;
    protected final Object lock = new Object();
    protected final AtomicReference<ChannelStatus> channelStatus = new AtomicReference<ChannelStatus>(ChannelStatus.Uninitialized);
    protected final ScheduledExecutorService reconnectService = Executors.newSingleThreadScheduledExecutor();

    public BaseUnixClient(String prefix) {
        super(prefix);
        this.reconnectService.scheduleAtFixedRate(new ChannelReconnectTask(this), 5000L, 5000L, TimeUnit.MILLISECONDS);
    }

    protected abstract boolean isConnected();

    protected abstract void reConnect() throws IOException;

    @Override
    public abstract void close() throws IOException;

    public static String loadUnixSockPath(String nodeSockPath, String sidecarSockPath) {
        String sidecarFlag = System.getenv(METRIC_SERVER2_SIDECAR_KEY);
        if (sidecarFlag != null && sidecarFlag.equals(METRIC_SERVER2_SIDECAR_VALUE)) {
            return sidecarSockPath;
        }
        return nodeSockPath;
    }

    protected boolean waitForConnected(long interval) {
        if (this.isConnected()) {
            return true;
        }
        this.sleep(interval);
        return this.isConnected();
    }

    protected void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException exception) {
            LOGGER.error("thread sleep failed:", exception);
        }
    }

    static class ShutdownHook
    extends Thread {
        private final BaseUnixClient client;

        ShutdownHook(BaseUnixClient client) {
            this.client = client;
        }

        @Override
        public void run() {
            try {
                LOGGER.info("close unix client");
                this.client.close();
            }
            catch (IOException e) {
                LOGGER.warn("close unix client failed", e);
            }
        }
    }

    protected static enum ChannelStatus {
        Uninitialized,
        Connected,
        Disconnected,
        Closed;

    }

    protected static class ChannelReconnectTask
    implements Runnable {
        private final BaseUnixClient client;

        protected ChannelReconnectTask(BaseUnixClient client) {
            this.client = client;
        }

        @Override
        public void run() {
            try {
                this.client.reConnect();
            }
            catch (IOException e) {
                LOGGER.warn("reConnect unix socket client failed");
            }
        }
    }
}

