/*
 * Decompiled with CFR 0.152.
 */
package org.byted.security.zti.jwt.shaded.com.bytedance.metrics.udpclient;

import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.nio.charset.StandardCharsets;
import org.byted.security.zti.jwt.shaded.com.bytedance.apm.shade.jnr.constants.platform.Sock;
import org.byted.security.zti.jwt.shaded.com.bytedance.metrics.udpclient.DryRunMetricsClient;
import org.byted.security.zti.jwt.shaded.com.bytedance.metrics.udpclient.InetMetricsClient;
import org.byted.security.zti.jwt.shaded.com.bytedance.metrics.udpclient.UnixMetricsClient;
import org.byted.security.zti.jwt.shaded.com.bytedance.metrics.udpclient.UnixSeqPacketClient;
import org.byted.security.zti.jwt.shaded.org.slf4j.Logger;
import org.byted.security.zti.jwt.shaded.org.slf4j.LoggerFactory;

public abstract class MetricsClient {
    public static final String ENV_USE_SOCK = "METRICS_USE_SOCK";
    public static final String ENV_FALLBACK_TO_UDP = "METRICS_FALLBACK_TO_UDP";
    public static final boolean ENABLE_SOCK_FROM_ENV = "true".equalsIgnoreCase(System.getenv("METRICS_USE_SOCK"));
    public static final boolean ENABLE_FALLBACK_TO_UDP_FROM_ENV = "true".equalsIgnoreCase(System.getenv("METRICS_FALLBACK_TO_UDP"));
    private static final Logger LOG = LoggerFactory.getLogger(MetricsClient.class);
    private static final byte[] EMPTY_BYTES = new byte[0];
    String prefix;

    public MetricsClient(String prefix) {
        this.prefix = prefix;
    }

    public String getFullName(String name) {
        return name.startsWith(":") ? name.substring(1) : this.prefix + name;
    }

    public void emitCounter(String name, double value) throws IOException {
        this.emit("counter", this.getFullName(name), String.valueOf(value), "");
    }

    public void emitCounterWithTag(String name, double value, String tags) throws IOException {
        this.emit("counter", this.getFullName(name), String.valueOf(value), tags);
    }

    public void emitTimer(String name, double value) throws IOException {
        this.emit("timer", this.getFullName(name), String.valueOf(value), "");
    }

    public void emitTimerWithTag(String name, double value, String tags) throws IOException {
        this.emit("timer", this.getFullName(name), String.valueOf(value), tags);
    }

    public void emitStore(String name, double value) throws IOException {
        this.emit("store", this.getFullName(name), String.valueOf(value), "");
    }

    public void emitStoreWithTag(String name, double value, String tags) throws IOException {
        this.emit("store", this.getFullName(name), String.valueOf(value), tags);
    }

    public void emitStoreWithTimestamp(String name, double value, long timestamp) throws IOException {
        this.emitWithTimestamp("ts_store", this.getFullName(name), String.valueOf(value), "", timestamp);
    }

    public void emitStoreWithTsAndTag(String name, double value, String tags, long timestamp) throws IOException {
        this.emitWithTimestamp("ts_store", this.getFullName(name), String.valueOf(value), tags, timestamp);
    }

    public void emit(String type, String fullName, String value, String tags) throws IOException {
        this.emitWithTimestamp(type, fullName, value, tags, -1L);
    }

    protected void emitWithTimestamp(String type, String fullName, String value, String tags, long timestamp) throws IOException {
        byte[] typeBytes = type.getBytes(StandardCharsets.UTF_8);
        byte[] fullNameBytes = fullName.getBytes(StandardCharsets.UTF_8);
        byte[] valueBytes = value.getBytes(StandardCharsets.UTF_8);
        byte[] tagsBytes = tags.getBytes(StandardCharsets.UTF_8);
        byte[] timestampBytes = timestamp < 0L ? EMPTY_BYTES : String.valueOf(timestamp).getBytes(StandardCharsets.UTF_8);
        int estimateSize = 31 + typeBytes.length + fullNameBytes.length + valueBytes.length + tagsBytes.length + timestampBytes.length;
        ByteBuffer out = ByteBuffer.allocate(estimateSize);
        MetricsClient.writeMsgpackArrayHead(out, 6);
        MetricsClient.writeMsgpackString(out, "emit");
        MetricsClient.writeMsgpackStringBytes(out, typeBytes);
        MetricsClient.writeMsgpackStringBytes(out, fullNameBytes);
        MetricsClient.writeMsgpackStringBytes(out, valueBytes);
        MetricsClient.writeMsgpackStringBytes(out, tagsBytes);
        MetricsClient.writeMsgpackStringBytes(out, timestampBytes);
        out.flip();
        this.emit(out);
    }

    public static void writeMsgpackArrayHead(DataOutputStream out, int size) throws IOException {
        if (size < 16) {
            out.writeByte(144 + size);
        } else if (size < 65536) {
            out.writeByte(220);
            out.writeShort(size);
        } else {
            out.writeByte(221);
            out.writeInt(size);
        }
    }

    public static void writeMsgpackString(DataOutputStream out, String s2) throws IOException {
        byte[] bytes = s2.getBytes(StandardCharsets.UTF_8);
        MetricsClient.writeMsgpackStringBytes(out, bytes);
    }

    public static void writeMsgpackStringBytes(DataOutputStream out, byte[] bytes) throws IOException {
        int length = bytes.length;
        if (length < 32) {
            out.writeByte(160 + length);
        } else if (length < 256) {
            out.writeByte(217);
            out.writeByte(length);
        } else if (length < 65536) {
            out.writeByte(218);
            out.writeShort(length);
        } else {
            out.writeByte(219);
            out.writeInt(length);
        }
        out.write(bytes);
    }

    public static void writeMsgpackArrayHead(ByteBuffer out, int size) {
        if (size < 16) {
            out.put((byte)(0x90 | size));
        } else if (size < 65536) {
            out.put((byte)-36);
            out.putShort((short)size);
        } else {
            out.put((byte)-35);
            out.putInt(size);
        }
    }

    public static void writeMsgpackString(ByteBuffer out, String s2) {
        byte[] bytes = s2.getBytes(StandardCharsets.UTF_8);
        MetricsClient.writeMsgpackStringBytes(out, bytes);
    }

    public static void writeMsgpackStringBytes(ByteBuffer out, byte[] bytes) {
        int length = bytes.length;
        if (length < 32) {
            out.put((byte)(0xA0 | length));
        } else if (length < 256) {
            out.put((byte)-39);
            out.put((byte)length);
        } else if (length < 65536) {
            out.put((byte)-38);
            out.putShort((short)length);
        } else {
            out.put((byte)-37);
            out.putInt(length);
        }
        out.put(bytes);
    }

    public void emit(byte[] buf) throws IOException {
        this.emit(buf, 0, buf.length);
    }

    public void emit(byte[] buf, int offset, int length) throws IOException {
        this.emit(ByteBuffer.wrap(buf, offset, length));
    }

    public abstract void emit(ByteBuffer var1) throws IOException;

    public static MetricsClient get(String prefix, boolean useDomainSock) {
        return MetricsClient.get(prefix, useDomainSock, Sock.SOCK_DGRAM);
    }

    public static MetricsClient get(String prefix, boolean useDomainSock, Sock sock) {
        boolean inetAvailable;
        if (!prefix.isEmpty() && !prefix.endsWith(".")) {
            prefix = prefix + ".";
        }
        if (useDomainSock) {
            LOG.info("metrics sdk use unix domain socket to emit metrics");
            try {
                switch (sock) {
                    case SOCK_SEQPACKET: {
                        return new UnixSeqPacketClient(prefix);
                    }
                }
                return new UnixMetricsClient(prefix);
            }
            catch (IOException e) {
                LOG.error("initialize unix client failed, use DryRunMetricsClient");
                return new DryRunMetricsClient();
            }
        }
        String myHostIp = System.getenv("MY_HOST_IP");
        String myHostIpv6 = System.getenv("MY_HOST_IPV6");
        String host = myHostIp != null && !myHostIp.isEmpty() ? myHostIp : (myHostIpv6 != null && !myHostIpv6.isEmpty() ? myHostIpv6 : "localhost");
        InetSocketAddress inetSocketAddress = new InetSocketAddress(host, 9123);
        DatagramChannel inetChannel = null;
        try {
            inetChannel = DatagramChannel.open();
        }
        catch (IOException e) {
            LOG.warn("create datagram socket failed", e);
        }
        boolean bl = inetAvailable = inetChannel != null;
        if (inetAvailable) {
            if (useDomainSock) {
                LOG.warn("unix domain socket is not available");
                if (!ENABLE_FALLBACK_TO_UDP_FROM_ENV) {
                    LOG.error("metrics will be discarded");
                    return new DryRunMetricsClient();
                }
            }
            LOG.info("metrics sdk use localhost inet socket to emit metrics");
            return new InetMetricsClient(prefix, inetChannel, inetSocketAddress);
        }
        LOG.error("neither unix domain socket nor localhost inet socket is available, metrics will be discarded");
        return new DryRunMetricsClient();
    }
}

