/*
 * Decompiled with CFR 0.152.
 */
package org.byted.security.zti.jwt.shaded.com.bytedance.metrics.udpclient;

import java.io.File;
import java.io.IOException;
import java.net.SocketOption;
import java.nio.ByteBuffer;
import org.byted.security.zti.jwt.shaded.com.bytedance.apm.shade.jnr.unixsocket.UnixSeqPacketChannel;
import org.byted.security.zti.jwt.shaded.com.bytedance.apm.shade.jnr.unixsocket.UnixSocketAddress;
import org.byted.security.zti.jwt.shaded.com.bytedance.apm.shade.jnr.unixsocket.UnixSocketChannel;
import org.byted.security.zti.jwt.shaded.com.bytedance.apm.shade.jnr.unixsocket.UnixSocketOptions;
import org.byted.security.zti.jwt.shaded.com.bytedance.metrics.udpclient.BaseUnixClient;
import org.byted.security.zti.jwt.shaded.org.slf4j.Logger;
import org.byted.security.zti.jwt.shaded.org.slf4j.LoggerFactory;

public class UnixSeqPacketClient
extends BaseUnixClient {
    private static final Logger LOG = LoggerFactory.getLogger(UnixSeqPacketClient.class);
    private static final String NODE_SOCK_PATH = "/opt/tmp/sock/metric_sdk1_seqpacket.sock";
    private static final String SIDECAR_SOCK_PATH = "/sidecar/sock/metric_sdk1_seqpacket.sock";
    private final UnixSocketAddress address = new UnixSocketAddress(new File(UnixSeqPacketClient.loadUnixSockPath("/opt/tmp/sock/metric_sdk1_seqpacket.sock", "/sidecar/sock/metric_sdk1_seqpacket.sock")));
    private UnixSocketChannel channel = UnixSeqPacketChannel.create();

    public UnixSeqPacketClient(String prefix) throws IOException {
        super(prefix);
        this.channel.setOption((SocketOption)UnixSocketOptions.SO_SNDTIMEO, (Object)100);
        this.connect();
        Runtime.getRuntime().addShutdownHook(new BaseUnixClient.ShutdownHook(this));
    }

    @Override
    public void emit(ByteBuffer buffer) {
        for (int i = 0; i < 3; ++i) {
            try {
                if (!this.waitForConnected(100L)) continue;
                this.channel.write(buffer);
                break;
            }
            catch (IOException exception) {
                LOG.warn("write data to unix domain socket exception, buffer length:{}, attemptNumber:{}", buffer.limit(), i, exception);
                if ("Message too long".equals(exception.getMessage())) break;
                this.channelStatus.set(BaseUnixClient.ChannelStatus.Disconnected);
            }
        }
    }

    @Override
    public boolean isConnected() {
        return ((BaseUnixClient.ChannelStatus)((Object)this.channelStatus.get())).equals((Object)BaseUnixClient.ChannelStatus.Connected) && this.channel.isConnected();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connect() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            try {
                this.channel.connect(this.address);
                this.channelStatus.set(BaseUnixClient.ChannelStatus.Connected);
            }
            catch (IOException exception) {
                LOG.warn("connect to agent failed:", exception);
                this.disconnectAndThrowException(BaseUnixClient.ChannelStatus.Uninitialized, exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reConnect() throws IOException {
        if (this.isConnected()) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.isConnected()) {
                return;
            }
            this.channel.close();
            this.channel = UnixSeqPacketChannel.create();
            this.channel.setOption((SocketOption)UnixSocketOptions.SO_SNDTIMEO, (Object)100);
            this.channel.connect(this.address);
            this.channelStatus.set(BaseUnixClient.ChannelStatus.Connected);
        }
    }

    private void disconnectAndThrowException(BaseUnixClient.ChannelStatus status, IOException exception) throws IOException {
        this.channelStatus.compareAndSet(status, BaseUnixClient.ChannelStatus.Disconnected);
        throw exception;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (!((BaseUnixClient.ChannelStatus)((Object)this.channelStatus.get())).equals((Object)BaseUnixClient.ChannelStatus.Closed)) {
            Object object = this.lock;
            synchronized (object) {
                if (!((BaseUnixClient.ChannelStatus)((Object)this.channelStatus.get())).equals((Object)BaseUnixClient.ChannelStatus.Closed)) {
                    if (this.channel != null) {
                        this.channel.close();
                    }
                    this.channelStatus.set(BaseUnixClient.ChannelStatus.Closed);
                }
            }
        }
    }
}

