/*
 * Decompiled with CFR 0.152.
 */
package org.byted.security.zti.jwt.shaded.com.google.common.collect;

import java.io.Serializable;
import org.byted.security.zti.jwt.shaded.com.google.common.annotations.GwtCompatible;
import org.byted.security.zti.jwt.shaded.com.google.common.base.Function;
import org.byted.security.zti.jwt.shaded.com.google.common.base.Objects;
import org.byted.security.zti.jwt.shaded.com.google.common.base.Preconditions;
import org.byted.security.zti.jwt.shaded.com.google.common.collect.ElementTypesAreNonnullByDefault;
import org.byted.security.zti.jwt.shaded.com.google.common.collect.Ordering;
import org.byted.security.zti.jwt.shaded.com.google.common.collect.ParametricNullness;
import org.byted.security.zti.jwt.shaded.javax.annotation.CheckForNull;

@ElementTypesAreNonnullByDefault
@GwtCompatible(serializable=true)
final class ByFunctionOrdering<F, T>
extends Ordering<F>
implements Serializable {
    final Function<F, ? extends T> function;
    final Ordering<T> ordering;
    private static final long serialVersionUID = 0L;

    ByFunctionOrdering(Function<F, ? extends T> function2, Ordering<T> ordering) {
        this.function = Preconditions.checkNotNull(function2);
        this.ordering = Preconditions.checkNotNull(ordering);
    }

    @Override
    public int compare(@ParametricNullness F left, @ParametricNullness F right) {
        return this.ordering.compare(this.function.apply(left), this.function.apply(right));
    }

    @Override
    public boolean equals(@CheckForNull Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof ByFunctionOrdering) {
            ByFunctionOrdering that = (ByFunctionOrdering)object;
            return this.function.equals(that.function) && this.ordering.equals(that.ordering);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode(this.function, this.ordering);
    }

    public String toString() {
        return this.ordering + ".onResultOf(" + this.function + ")";
    }
}

