/*
 * Decompiled with CFR 0.152.
 */
package org.byted.security.zti.jwt.shaded.io.grpc.internal;

import java.util.concurrent.Executor;
import org.byted.security.zti.jwt.shaded.com.google.common.annotations.VisibleForTesting;
import org.byted.security.zti.jwt.shaded.com.google.common.base.Preconditions;
import org.byted.security.zti.jwt.shaded.com.google.common.util.concurrent.ListenableFuture;
import org.byted.security.zti.jwt.shaded.com.google.common.util.concurrent.SettableFuture;
import org.byted.security.zti.jwt.shaded.io.grpc.CallOptions;
import org.byted.security.zti.jwt.shaded.io.grpc.ClientStreamTracer;
import org.byted.security.zti.jwt.shaded.io.grpc.InternalChannelz;
import org.byted.security.zti.jwt.shaded.io.grpc.InternalLogId;
import org.byted.security.zti.jwt.shaded.io.grpc.Metadata;
import org.byted.security.zti.jwt.shaded.io.grpc.MethodDescriptor;
import org.byted.security.zti.jwt.shaded.io.grpc.Status;
import org.byted.security.zti.jwt.shaded.io.grpc.internal.ClientStream;
import org.byted.security.zti.jwt.shaded.io.grpc.internal.ClientStreamListener;
import org.byted.security.zti.jwt.shaded.io.grpc.internal.ClientTransport;
import org.byted.security.zti.jwt.shaded.io.grpc.internal.FailingClientStream;

class FailingClientTransport
implements ClientTransport {
    @VisibleForTesting
    final Status error;
    private final ClientStreamListener.RpcProgress rpcProgress;

    FailingClientTransport(Status error, ClientStreamListener.RpcProgress rpcProgress) {
        Preconditions.checkArgument(!error.isOk(), "error must not be OK");
        this.error = error;
        this.rpcProgress = rpcProgress;
    }

    @Override
    public ClientStream newStream(MethodDescriptor<?, ?> method, Metadata headers, CallOptions callOptions, ClientStreamTracer[] tracers) {
        return new FailingClientStream(this.error, this.rpcProgress, tracers);
    }

    @Override
    public void ping(final ClientTransport.PingCallback callback, Executor executor) {
        executor.execute(new Runnable(){

            @Override
            public void run() {
                callback.onFailure(FailingClientTransport.this.error.asException());
            }
        });
    }

    @Override
    public ListenableFuture<InternalChannelz.SocketStats> getStats() {
        SettableFuture<InternalChannelz.SocketStats> ret = SettableFuture.create();
        ret.set(null);
        return ret;
    }

    @Override
    public InternalLogId getLogId() {
        throw new UnsupportedOperationException("Not a real transport");
    }
}

