/*
 * Decompiled with CFR 0.152.
 */
package org.byted.security.zti.jwt.shaded.io.grpc.internal;

import org.byted.security.zti.jwt.shaded.com.google.common.base.Preconditions;
import org.byted.security.zti.jwt.shaded.io.grpc.CallCredentials;
import org.byted.security.zti.jwt.shaded.io.grpc.CallOptions;
import org.byted.security.zti.jwt.shaded.io.grpc.ClientStreamTracer;
import org.byted.security.zti.jwt.shaded.io.grpc.Context;
import org.byted.security.zti.jwt.shaded.io.grpc.Metadata;
import org.byted.security.zti.jwt.shaded.io.grpc.MethodDescriptor;
import org.byted.security.zti.jwt.shaded.io.grpc.Status;
import org.byted.security.zti.jwt.shaded.io.grpc.internal.ClientStream;
import org.byted.security.zti.jwt.shaded.io.grpc.internal.ClientTransport;
import org.byted.security.zti.jwt.shaded.io.grpc.internal.DelayedStream;
import org.byted.security.zti.jwt.shaded.io.grpc.internal.FailingClientStream;
import org.byted.security.zti.jwt.shaded.io.grpc.internal.GrpcUtil;
import org.byted.security.zti.jwt.shaded.javax.annotation.Nullable;
import org.byted.security.zti.jwt.shaded.javax.annotation.concurrent.GuardedBy;

final class MetadataApplierImpl
extends CallCredentials.MetadataApplier {
    private final ClientTransport transport;
    private final MethodDescriptor<?, ?> method;
    private final Metadata origHeaders;
    private final CallOptions callOptions;
    private final Context ctx;
    private final MetadataApplierListener listener;
    private final ClientStreamTracer[] tracers;
    private final Object lock = new Object();
    @Nullable
    @GuardedBy(value="lock")
    private ClientStream returnedStream;
    boolean finalized;
    DelayedStream delayedStream;

    MetadataApplierImpl(ClientTransport transport, MethodDescriptor<?, ?> method, Metadata origHeaders, CallOptions callOptions, MetadataApplierListener listener, ClientStreamTracer[] tracers) {
        this.transport = transport;
        this.method = method;
        this.origHeaders = origHeaders;
        this.callOptions = callOptions;
        this.ctx = Context.current();
        this.listener = listener;
        this.tracers = tracers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void apply(Metadata headers) {
        ClientStream realStream;
        Preconditions.checkState(!this.finalized, "apply() or fail() already called");
        Preconditions.checkNotNull(headers, "headers");
        this.origHeaders.merge(headers);
        Context origCtx = this.ctx.attach();
        try {
            realStream = this.transport.newStream(this.method, this.origHeaders, this.callOptions, this.tracers);
        }
        finally {
            this.ctx.detach(origCtx);
        }
        this.finalizeWith(realStream);
    }

    @Override
    public void fail(Status status) {
        Preconditions.checkArgument(!status.isOk(), "Cannot fail with OK status");
        Preconditions.checkState(!this.finalized, "apply() or fail() already called");
        this.finalizeWith(new FailingClientStream(GrpcUtil.replaceInappropriateControlPlaneStatus(status), this.tracers));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finalizeWith(ClientStream stream) {
        Preconditions.checkState(!this.finalized, "already finalized");
        this.finalized = true;
        boolean directStream = false;
        Object object = this.lock;
        synchronized (object) {
            if (this.returnedStream == null) {
                this.returnedStream = stream;
                directStream = true;
            }
        }
        if (directStream) {
            this.listener.onComplete();
            return;
        }
        Preconditions.checkState(this.delayedStream != null, "delayedStream is null");
        Runnable slow = this.delayedStream.setStream(stream);
        if (slow != null) {
            slow.run();
        }
        this.listener.onComplete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ClientStream returnStream() {
        Object object = this.lock;
        synchronized (object) {
            if (this.returnedStream == null) {
                this.delayedStream = new DelayedStream();
                this.returnedStream = this.delayedStream;
                return this.returnedStream;
            }
            return this.returnedStream;
        }
    }

    public static interface MetadataApplierListener {
        public void onComplete();
    }
}

