/*
 * Decompiled with CFR 0.152.
 */
package org.byted.security.zti.jwt.shaded.io.grpc.internal;

import java.util.Map;
import org.byted.security.zti.jwt.shaded.com.google.common.base.Strings;
import org.byted.security.zti.jwt.shaded.io.grpc.LoadBalancer;
import org.byted.security.zti.jwt.shaded.io.grpc.LoadBalancerProvider;
import org.byted.security.zti.jwt.shaded.io.grpc.NameResolver;
import org.byted.security.zti.jwt.shaded.io.grpc.Status;
import org.byted.security.zti.jwt.shaded.io.grpc.internal.JsonUtil;
import org.byted.security.zti.jwt.shaded.io.grpc.internal.PickFirstLeafLoadBalancer;
import org.byted.security.zti.jwt.shaded.io.grpc.internal.PickFirstLoadBalancer;

public final class PickFirstLoadBalancerProvider
extends LoadBalancerProvider {
    private static final String SHUFFLE_ADDRESS_LIST_KEY = "shuffleAddressList";
    static boolean enableNewPickFirst = !Strings.isNullOrEmpty(System.getenv("GRPC_EXPERIMENTAL_ENABLE_NEW_PICK_FIRST")) && Boolean.parseBoolean(System.getenv("GRPC_EXPERIMENTAL_ENABLE_NEW_PICK_FIRST"));

    @Override
    public boolean isAvailable() {
        return true;
    }

    @Override
    public int getPriority() {
        return 5;
    }

    @Override
    public String getPolicyName() {
        return "pick_first";
    }

    @Override
    public LoadBalancer newLoadBalancer(LoadBalancer.Helper helper) {
        if (enableNewPickFirst) {
            return new PickFirstLeafLoadBalancer(helper);
        }
        return new PickFirstLoadBalancer(helper);
    }

    @Override
    public NameResolver.ConfigOrError parseLoadBalancingPolicyConfig(Map<String, ?> rawLoadBalancingPolicyConfig) {
        try {
            return NameResolver.ConfigOrError.fromConfig(new PickFirstLoadBalancer.PickFirstLoadBalancerConfig(JsonUtil.getBoolean(rawLoadBalancingPolicyConfig, SHUFFLE_ADDRESS_LIST_KEY)));
        }
        catch (RuntimeException e) {
            return NameResolver.ConfigOrError.fromError(Status.UNAVAILABLE.withCause(e).withDescription("Failed parsing configuration for " + this.getPolicyName()));
        }
    }
}

