/*
 * Decompiled with CFR 0.152.
 */
package org.byted.security.zti.jwt.shaded.io.grpc.netty.shaded.io.netty.channel;

import org.byted.security.zti.jwt.shaded.io.grpc.netty.shaded.io.netty.buffer.ByteBuf;
import org.byted.security.zti.jwt.shaded.io.grpc.netty.shaded.io.netty.buffer.ByteBufHolder;
import org.byted.security.zti.jwt.shaded.io.grpc.netty.shaded.io.netty.channel.FileRegion;
import org.byted.security.zti.jwt.shaded.io.grpc.netty.shaded.io.netty.channel.MessageSizeEstimator;
import org.byted.security.zti.jwt.shaded.io.grpc.netty.shaded.io.netty.util.internal.ObjectUtil;

public final class DefaultMessageSizeEstimator
implements MessageSizeEstimator {
    public static final MessageSizeEstimator DEFAULT = new DefaultMessageSizeEstimator(8);
    private final MessageSizeEstimator.Handle handle;

    public DefaultMessageSizeEstimator(int unknownSize) {
        ObjectUtil.checkPositiveOrZero(unknownSize, "unknownSize");
        this.handle = new HandleImpl(unknownSize);
    }

    @Override
    public MessageSizeEstimator.Handle newHandle() {
        return this.handle;
    }

    private static final class HandleImpl
    implements MessageSizeEstimator.Handle {
        private final int unknownSize;

        private HandleImpl(int unknownSize) {
            this.unknownSize = unknownSize;
        }

        @Override
        public int size(Object msg) {
            if (msg instanceof ByteBuf) {
                return ((ByteBuf)msg).readableBytes();
            }
            if (msg instanceof ByteBufHolder) {
                return ((ByteBufHolder)msg).content().readableBytes();
            }
            if (msg instanceof FileRegion) {
                return 0;
            }
            return this.unknownSize;
        }
    }
}

