/*
 * Decompiled with CFR 0.152.
 */
package org.byted.security.zti.jwt.shaded.io.grpc.netty.shaded.io.netty.handler.codec.socksx.v5;

import java.util.List;
import org.byted.security.zti.jwt.shaded.io.grpc.netty.shaded.io.netty.buffer.ByteBuf;
import org.byted.security.zti.jwt.shaded.io.grpc.netty.shaded.io.netty.channel.ChannelHandlerContext;
import org.byted.security.zti.jwt.shaded.io.grpc.netty.shaded.io.netty.handler.codec.DecoderException;
import org.byted.security.zti.jwt.shaded.io.grpc.netty.shaded.io.netty.handler.codec.DecoderResult;
import org.byted.security.zti.jwt.shaded.io.grpc.netty.shaded.io.netty.handler.codec.ReplayingDecoder;
import org.byted.security.zti.jwt.shaded.io.grpc.netty.shaded.io.netty.handler.codec.socksx.SocksVersion;
import org.byted.security.zti.jwt.shaded.io.grpc.netty.shaded.io.netty.handler.codec.socksx.v5.DefaultSocks5InitialRequest;
import org.byted.security.zti.jwt.shaded.io.grpc.netty.shaded.io.netty.handler.codec.socksx.v5.Socks5AuthMethod;

public class Socks5InitialRequestDecoder
extends ReplayingDecoder<State> {
    public Socks5InitialRequestDecoder() {
        super(State.INIT);
    }

    @Override
    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        try {
            switch ((State)((Object)this.state())) {
                case INIT: {
                    byte version = in.readByte();
                    if (version != SocksVersion.SOCKS5.byteValue()) {
                        throw new DecoderException("unsupported version: " + version + " (expected: " + SocksVersion.SOCKS5.byteValue() + ')');
                    }
                    int authMethodCnt = in.readUnsignedByte();
                    Socks5AuthMethod[] authMethods = new Socks5AuthMethod[authMethodCnt];
                    for (int i = 0; i < authMethodCnt; ++i) {
                        authMethods[i] = Socks5AuthMethod.valueOf(in.readByte());
                    }
                    out.add(new DefaultSocks5InitialRequest(authMethods));
                    this.checkpoint(State.SUCCESS);
                }
                case SUCCESS: {
                    int readableBytes = this.actualReadableBytes();
                    if (readableBytes <= 0) break;
                    out.add(in.readRetainedSlice(readableBytes));
                    break;
                }
                case FAILURE: {
                    in.skipBytes(this.actualReadableBytes());
                }
            }
        }
        catch (Exception e) {
            this.fail(out, e);
        }
    }

    private void fail(List<Object> out, Exception cause) {
        if (!(cause instanceof DecoderException)) {
            cause = new DecoderException(cause);
        }
        this.checkpoint(State.FAILURE);
        DefaultSocks5InitialRequest m4 = new DefaultSocks5InitialRequest(Socks5AuthMethod.NO_AUTH);
        m4.setDecoderResult(DecoderResult.failure(cause));
        out.add(m4);
    }

    public static enum State {
        INIT,
        SUCCESS,
        FAILURE;

    }
}

