/*
 * Decompiled with CFR 0.152.
 */
package org.byted.security.zti.jwt.shaded.io.grpc.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.byted.security.zti.jwt.shaded.io.grpc.BindableService;
import org.byted.security.zti.jwt.shaded.io.grpc.ExperimentalApi;
import org.byted.security.zti.jwt.shaded.io.grpc.HandlerRegistry;
import org.byted.security.zti.jwt.shaded.io.grpc.MethodDescriptor;
import org.byted.security.zti.jwt.shaded.io.grpc.ServerMethodDefinition;
import org.byted.security.zti.jwt.shaded.io.grpc.ServerServiceDefinition;
import org.byted.security.zti.jwt.shaded.javax.annotation.Nullable;
import org.byted.security.zti.jwt.shaded.javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class MutableHandlerRegistry
extends HandlerRegistry {
    private final ConcurrentMap<String, ServerServiceDefinition> services = new ConcurrentHashMap<String, ServerServiceDefinition>();

    @Nullable
    public ServerServiceDefinition addService(ServerServiceDefinition service) {
        return this.services.put(service.getServiceDescriptor().getName(), service);
    }

    @Nullable
    public ServerServiceDefinition addService(BindableService bindableService) {
        return this.addService(bindableService.bindService());
    }

    public boolean removeService(ServerServiceDefinition service) {
        return this.services.remove(service.getServiceDescriptor().getName(), service);
    }

    @Override
    @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/2222")
    public List<ServerServiceDefinition> getServices() {
        return Collections.unmodifiableList(new ArrayList(this.services.values()));
    }

    @Override
    @Nullable
    public ServerMethodDefinition<?, ?> lookupMethod(String methodName, @Nullable String authority) {
        String serviceName = MethodDescriptor.extractFullServiceName(methodName);
        if (serviceName == null) {
            return null;
        }
        ServerServiceDefinition service = (ServerServiceDefinition)this.services.get(serviceName);
        if (service == null) {
            return null;
        }
        return service.getMethod(methodName);
    }
}

