/*
 * Decompiled with CFR 0.152.
 */
package org.byted.security.zti.jwt.shaded.io.spiffe.spiffeid;

import org.byted.security.zti.jwt.shaded.io.spiffe.exception.InvalidSpiffeIdException;
import org.byted.security.zti.jwt.shaded.io.spiffe.spiffeid.SpiffeId;
import org.byted.security.zti.jwt.shaded.org.apache.commons.lang3.StringUtils;
import shaded.bytehouse.lombok.Generated;
import shaded.bytehouse.lombok.NonNull;

public final class TrustDomain {
    private final String name;

    TrustDomain(String trustDomain) {
        this.name = trustDomain;
    }

    public static TrustDomain parse(@NonNull String idOrName) {
        if (idOrName == null) {
            throw new NullPointerException("idOrName is marked non-null but is null");
        }
        if (StringUtils.isBlank(idOrName)) {
            throw new IllegalArgumentException("Trust domain is missing");
        }
        if (idOrName.contains(":/")) {
            SpiffeId spiffeId = SpiffeId.parse(idOrName);
            return spiffeId.getTrustDomain();
        }
        TrustDomain.validateTrustDomainName(idOrName);
        return new TrustDomain(idOrName);
    }

    public SpiffeId newSpiffeId(String ... segments) {
        return SpiffeId.fromSegments(this, segments);
    }

    public String toString() {
        return this.name;
    }

    public String toIdString() {
        return "spiffe://" + this.name;
    }

    static void validateTrustDomainName(String name) {
        for (char c : name.toCharArray()) {
            if (TrustDomain.isValidTrustDomainChar(c)) continue;
            throw new InvalidSpiffeIdException("Trust domain characters are limited to lowercase letters, numbers, dots, dashes, and underscores");
        }
    }

    static boolean isValidTrustDomainChar(char c) {
        if (c >= 'a' && c <= 'z') {
            return true;
        }
        if (c >= '0' && c <= '9') {
            return true;
        }
        return c == '-' || c == '.' || c == '_';
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TrustDomain)) {
            return false;
        }
        TrustDomain other = (TrustDomain)o;
        String this$name = this.getName();
        String other$name = other.getName();
        return !(this$name == null ? other$name != null : !this$name.equals(other$name));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        return result;
    }
}

