/*
 * Decompiled with CFR 0.152.
 */
package org.byted.security.zti.jwt.shaded.io.spiffe.svid.x509svid;

import java.security.cert.CertPathValidatorException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import java.util.logging.Logger;
import org.byted.security.zti.jwt.shaded.io.spiffe.bundle.BundleSource;
import org.byted.security.zti.jwt.shaded.io.spiffe.bundle.x509bundle.X509Bundle;
import org.byted.security.zti.jwt.shaded.io.spiffe.exception.BundleNotFoundException;
import org.byted.security.zti.jwt.shaded.io.spiffe.internal.CertificateUtils;
import org.byted.security.zti.jwt.shaded.io.spiffe.spiffeid.SpiffeId;
import org.byted.security.zti.jwt.shaded.io.spiffe.spiffeid.TrustDomain;
import shaded.bytehouse.lombok.Generated;
import shaded.bytehouse.lombok.NonNull;

public final class X509SvidValidator {
    @Generated
    private static final Logger log = Logger.getLogger(X509SvidValidator.class.getName());

    private X509SvidValidator() {
    }

    public static void verifyChain(@NonNull List<X509Certificate> chain, @NonNull BundleSource<X509Bundle> x509BundleSource) throws CertificateException, BundleNotFoundException {
        if (chain == null) {
            throw new NullPointerException("chain is marked non-null but is null");
        }
        if (x509BundleSource == null) {
            throw new NullPointerException("x509BundleSource is marked non-null but is null");
        }
        TrustDomain trustDomain = CertificateUtils.getTrustDomain(chain);
        X509Bundle x509Bundle = x509BundleSource.getBundleForTrustDomain(trustDomain);
        try {
            CertificateUtils.validate(chain, x509Bundle.getX509Authorities());
        }
        catch (CertPathValidatorException e) {
            throw new CertificateException("Cert chain cannot be verified", e);
        }
    }

    public static void verifySpiffeId(@NonNull X509Certificate x509Certificate, @NonNull Supplier<Set<SpiffeId>> acceptedSpiffeIdsSupplier) throws CertificateException {
        if (x509Certificate == null) {
            throw new NullPointerException("x509Certificate is marked non-null but is null");
        }
        if (acceptedSpiffeIdsSupplier == null) {
            throw new NullPointerException("acceptedSpiffeIdsSupplier is marked non-null but is null");
        }
        Set<SpiffeId> spiffeIdSet = acceptedSpiffeIdsSupplier.get();
        if (spiffeIdSet.isEmpty()) {
            String error = "The supplier of accepted SPIFFE IDs supplied an empty set";
            log.warning(error);
            throw new CertificateException(error);
        }
        SpiffeId spiffeId = CertificateUtils.getSpiffeId(x509Certificate);
        if (!spiffeIdSet.contains(spiffeId)) {
            String error = String.format("SPIFFE ID %s in X.509 certificate is not accepted", spiffeId);
            log.warning(String.format("Client SPIFFE ID validation failed: %s", error));
            throw new CertificateException(String.format(error, spiffeId));
        }
    }
}

