/*
 * Decompiled with CFR 0.152.
 */
package org.byted.security.zti.jwt.shaded.io.spiffe.workloadapi;

import java.time.Duration;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.byted.security.zti.jwt.shaded.io.spiffe.bundle.x509bundle.X509Bundle;
import org.byted.security.zti.jwt.shaded.io.spiffe.bundle.x509bundle.X509BundleSet;
import org.byted.security.zti.jwt.shaded.io.spiffe.exception.BundleNotFoundException;
import org.byted.security.zti.jwt.shaded.io.spiffe.exception.SocketEndpointAddressException;
import org.byted.security.zti.jwt.shaded.io.spiffe.exception.WatcherException;
import org.byted.security.zti.jwt.shaded.io.spiffe.exception.X509SourceException;
import org.byted.security.zti.jwt.shaded.io.spiffe.spiffeid.TrustDomain;
import org.byted.security.zti.jwt.shaded.io.spiffe.svid.x509svid.X509Svid;
import org.byted.security.zti.jwt.shaded.io.spiffe.workloadapi.DefaultWorkloadApiClient;
import org.byted.security.zti.jwt.shaded.io.spiffe.workloadapi.Watcher;
import org.byted.security.zti.jwt.shaded.io.spiffe.workloadapi.WorkloadApiClient;
import org.byted.security.zti.jwt.shaded.io.spiffe.workloadapi.X509Context;
import org.byted.security.zti.jwt.shaded.io.spiffe.workloadapi.X509Source;
import org.byted.security.zti.jwt.shaded.io.spiffe.workloadapi.internal.ThreadUtils;
import shaded.bytehouse.lombok.Generated;
import shaded.bytehouse.lombok.NonNull;

public final class DefaultX509Source
implements X509Source {
    @Generated
    private static final Logger log = Logger.getLogger(DefaultX509Source.class.getName());
    private static final String TIMEOUT_SYSTEM_PROPERTY = "spiffe.newX509Source.timeout";
    private static final Duration DEFAULT_TIMEOUT = Duration.parse(System.getProperty("spiffe.newX509Source.timeout", "PT0S"));
    private X509Svid svid;
    private X509BundleSet bundles;
    private final Function<List<X509Svid>, X509Svid> picker;
    private final WorkloadApiClient workloadApiClient;
    private final BiConsumer<X509Context, ? super Throwable> x509ContextChangeListener;
    private volatile boolean closed;

    private DefaultX509Source(Function<List<X509Svid>, X509Svid> svidPicker, BiConsumer<X509Context, ? super Throwable> x509ContextChangeListener, WorkloadApiClient workloadApiClient) {
        this.picker = svidPicker;
        this.workloadApiClient = workloadApiClient;
        this.x509ContextChangeListener = x509ContextChangeListener;
    }

    public static DefaultX509Source newSource() throws SocketEndpointAddressException, X509SourceException {
        X509SourceOptions x509SourceOptions = X509SourceOptions.builder().initTimeout(DEFAULT_TIMEOUT).build();
        return DefaultX509Source.newSource(x509SourceOptions);
    }

    public static DefaultX509Source newSource(@NonNull X509SourceOptions options) throws SocketEndpointAddressException, X509SourceException {
        if (options == null) {
            throw new NullPointerException("options is marked non-null but is null");
        }
        if (options.workloadApiClient == null) {
            options.workloadApiClient = DefaultX509Source.createClient(options);
        }
        if (options.initTimeout == null) {
            options.initTimeout = DefaultX509Source.DEFAULT_TIMEOUT;
        }
        if (options.x509ContextChangeListener == null) {
            options.x509ContextChangeListener = (context, e) -> {};
        }
        DefaultX509Source x509Source = new DefaultX509Source(options.svidPicker, options.x509ContextChangeListener, options.workloadApiClient);
        try {
            x509Source.init(options.initTimeout);
        }
        catch (Exception e2) {
            x509Source.close();
            throw new X509SourceException("Error creating X.509 source", e2);
        }
        return x509Source;
    }

    @Override
    public X509Svid getX509Svid() {
        if (this.isClosed()) {
            throw new IllegalStateException("X.509 SVID source is closed");
        }
        return this.svid;
    }

    @Override
    public X509Bundle getBundleForTrustDomain(@NonNull TrustDomain trustDomain) throws BundleNotFoundException {
        if (trustDomain == null) {
            throw new NullPointerException("trustDomain is marked non-null but is null");
        }
        if (this.isClosed()) {
            throw new IllegalStateException("X.509 bundle source is closed");
        }
        return this.bundles.getBundleForTrustDomain(trustDomain);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        block6: {
            if (this.closed) break block6;
            DefaultX509Source defaultX509Source = this;
            synchronized (defaultX509Source) {
                if (!this.closed) {
                    this.workloadApiClient.close();
                    this.closed = true;
                }
            }
        }
    }

    private static WorkloadApiClient createClient(X509SourceOptions options) throws SocketEndpointAddressException {
        DefaultWorkloadApiClient.ClientOptions clientOptions = DefaultWorkloadApiClient.ClientOptions.builder().spiffeSocketPath(options.spiffeSocketPath).build();
        return DefaultWorkloadApiClient.newClient(clientOptions);
    }

    private void init(Duration timeout) throws TimeoutException {
        boolean success;
        CountDownLatch done = new CountDownLatch(1);
        this.setX509ContextWatcher(done);
        if (timeout.isZero()) {
            ThreadUtils.await(done);
            success = true;
        } else {
            success = ThreadUtils.await(done, timeout.getSeconds(), TimeUnit.SECONDS);
        }
        if (!success) {
            throw new TimeoutException("Timeout waiting for X.509 Context update");
        }
    }

    private void setX509ContextWatcher(final CountDownLatch done) {
        this.workloadApiClient.watchX509Context(new Watcher<X509Context>(){

            @Override
            public void onUpdate(X509Context update) {
                try {
                    String spiffeIds = update.getX509Svids().stream().map(s2 -> s2.getSpiffeId().toString()).collect(Collectors.joining(", "));
                    log.log(Level.INFO, String.format("Received X509Context update: %s", spiffeIds));
                    DefaultX509Source.this.setX509Context(update);
                    DefaultX509Source.this.x509ContextChangeListener.accept(update, null);
                }
                finally {
                    done.countDown();
                }
            }

            @Override
            public void onError(Throwable error) {
                try {
                    log.log(Level.SEVERE, "Error in X509Context watcher", error);
                    DefaultX509Source.this.x509ContextChangeListener.accept(null, error);
                }
                finally {
                    done.countDown();
                    throw new WatcherException("Error in X509Context watcher", error);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setX509Context(X509Context update) {
        X509Svid svidUpdate = this.picker == null ? update.getDefaultSvid() : this.picker.apply(update.getX509Svids());
        DefaultX509Source defaultX509Source = this;
        synchronized (defaultX509Source) {
            this.svid = svidUpdate;
            this.bundles = update.getX509BundleSet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isClosed() {
        DefaultX509Source defaultX509Source = this;
        synchronized (defaultX509Source) {
            return this.closed;
        }
    }

    public static class X509SourceOptions {
        private String spiffeSocketPath;
        private Duration initTimeout;
        private Function<List<X509Svid>, X509Svid> svidPicker;
        private WorkloadApiClient workloadApiClient;
        private BiConsumer<X509Context, ? super Throwable> x509ContextChangeListener;

        public X509SourceOptions(String spiffeSocketPath, Duration initTimeout, Function<List<X509Svid>, X509Svid> svidPicker, WorkloadApiClient workloadApiClient, BiConsumer<X509Context, ? super Throwable> x509ContextChangeListener) {
            this.spiffeSocketPath = spiffeSocketPath;
            this.initTimeout = initTimeout;
            this.svidPicker = svidPicker;
            this.workloadApiClient = workloadApiClient;
            this.x509ContextChangeListener = x509ContextChangeListener;
        }

        @Generated
        public static X509SourceOptionsBuilder builder() {
            return new X509SourceOptionsBuilder();
        }

        @Generated
        public String getSpiffeSocketPath() {
            return this.spiffeSocketPath;
        }

        @Generated
        public Duration getInitTimeout() {
            return this.initTimeout;
        }

        @Generated
        public Function<List<X509Svid>, X509Svid> getSvidPicker() {
            return this.svidPicker;
        }

        @Generated
        public WorkloadApiClient getWorkloadApiClient() {
            return this.workloadApiClient;
        }

        @Generated
        public BiConsumer<X509Context, ? super Throwable> getX509ContextChangeListener() {
            return this.x509ContextChangeListener;
        }

        @Generated
        public void setSpiffeSocketPath(String spiffeSocketPath) {
            this.spiffeSocketPath = spiffeSocketPath;
        }

        @Generated
        public void setInitTimeout(Duration initTimeout) {
            this.initTimeout = initTimeout;
        }

        @Generated
        public void setSvidPicker(Function<List<X509Svid>, X509Svid> svidPicker) {
            this.svidPicker = svidPicker;
        }

        @Generated
        public void setWorkloadApiClient(WorkloadApiClient workloadApiClient) {
            this.workloadApiClient = workloadApiClient;
        }

        @Generated
        public void setX509ContextChangeListener(BiConsumer<X509Context, ? super Throwable> x509ContextChangeListener) {
            this.x509ContextChangeListener = x509ContextChangeListener;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof X509SourceOptions)) {
                return false;
            }
            X509SourceOptions other = (X509SourceOptions)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$spiffeSocketPath = this.getSpiffeSocketPath();
            String other$spiffeSocketPath = other.getSpiffeSocketPath();
            if (this$spiffeSocketPath == null ? other$spiffeSocketPath != null : !this$spiffeSocketPath.equals(other$spiffeSocketPath)) {
                return false;
            }
            Duration this$initTimeout = this.getInitTimeout();
            Duration other$initTimeout = other.getInitTimeout();
            if (this$initTimeout == null ? other$initTimeout != null : !((Object)this$initTimeout).equals(other$initTimeout)) {
                return false;
            }
            Function<List<X509Svid>, X509Svid> this$svidPicker = this.getSvidPicker();
            Function<List<X509Svid>, X509Svid> other$svidPicker = other.getSvidPicker();
            if (this$svidPicker == null ? other$svidPicker != null : !this$svidPicker.equals(other$svidPicker)) {
                return false;
            }
            WorkloadApiClient this$workloadApiClient = this.getWorkloadApiClient();
            WorkloadApiClient other$workloadApiClient = other.getWorkloadApiClient();
            if (this$workloadApiClient == null ? other$workloadApiClient != null : !this$workloadApiClient.equals(other$workloadApiClient)) {
                return false;
            }
            BiConsumer<X509Context, ? super Throwable> this$x509ContextChangeListener = this.getX509ContextChangeListener();
            BiConsumer<X509Context, ? super Throwable> other$x509ContextChangeListener = other.getX509ContextChangeListener();
            return !(this$x509ContextChangeListener == null ? other$x509ContextChangeListener != null : !this$x509ContextChangeListener.equals(other$x509ContextChangeListener));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof X509SourceOptions;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $spiffeSocketPath = this.getSpiffeSocketPath();
            result = result * 59 + ($spiffeSocketPath == null ? 43 : $spiffeSocketPath.hashCode());
            Duration $initTimeout = this.getInitTimeout();
            result = result * 59 + ($initTimeout == null ? 43 : ((Object)$initTimeout).hashCode());
            Function<List<X509Svid>, X509Svid> $svidPicker = this.getSvidPicker();
            result = result * 59 + ($svidPicker == null ? 43 : $svidPicker.hashCode());
            WorkloadApiClient $workloadApiClient = this.getWorkloadApiClient();
            result = result * 59 + ($workloadApiClient == null ? 43 : $workloadApiClient.hashCode());
            BiConsumer<X509Context, ? super Throwable> $x509ContextChangeListener = this.getX509ContextChangeListener();
            result = result * 59 + ($x509ContextChangeListener == null ? 43 : $x509ContextChangeListener.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "DefaultX509Source.X509SourceOptions(spiffeSocketPath=" + this.getSpiffeSocketPath() + ", initTimeout=" + this.getInitTimeout() + ", svidPicker=" + this.getSvidPicker() + ", workloadApiClient=" + this.getWorkloadApiClient() + ", x509ContextChangeListener=" + this.getX509ContextChangeListener() + ")";
        }

        @Generated
        public static class X509SourceOptionsBuilder {
            @Generated
            private String spiffeSocketPath;
            @Generated
            private Duration initTimeout;
            @Generated
            private Function<List<X509Svid>, X509Svid> svidPicker;
            @Generated
            private WorkloadApiClient workloadApiClient;
            @Generated
            private BiConsumer<X509Context, ? super Throwable> x509ContextChangeListener;

            @Generated
            X509SourceOptionsBuilder() {
            }

            @Generated
            public X509SourceOptionsBuilder spiffeSocketPath(String spiffeSocketPath) {
                this.spiffeSocketPath = spiffeSocketPath;
                return this;
            }

            @Generated
            public X509SourceOptionsBuilder initTimeout(Duration initTimeout) {
                this.initTimeout = initTimeout;
                return this;
            }

            @Generated
            public X509SourceOptionsBuilder svidPicker(Function<List<X509Svid>, X509Svid> svidPicker) {
                this.svidPicker = svidPicker;
                return this;
            }

            @Generated
            public X509SourceOptionsBuilder workloadApiClient(WorkloadApiClient workloadApiClient) {
                this.workloadApiClient = workloadApiClient;
                return this;
            }

            @Generated
            public X509SourceOptionsBuilder x509ContextChangeListener(BiConsumer<X509Context, ? super Throwable> x509ContextChangeListener) {
                this.x509ContextChangeListener = x509ContextChangeListener;
                return this;
            }

            @Generated
            public X509SourceOptions build() {
                return new X509SourceOptions(this.spiffeSocketPath, this.initTimeout, this.svidPicker, this.workloadApiClient, this.x509ContextChangeListener);
            }

            @Generated
            public String toString() {
                return "DefaultX509Source.X509SourceOptions.X509SourceOptionsBuilder(spiffeSocketPath=" + this.spiffeSocketPath + ", initTimeout=" + this.initTimeout + ", svidPicker=" + this.svidPicker + ", workloadApiClient=" + this.workloadApiClient + ", x509ContextChangeListener=" + this.x509ContextChangeListener + ")";
            }
        }
    }
}

