/*
 * Decompiled with CFR 0.152.
 */
package org.byted.security.zti.jwt.shaded.io.spiffe.workloadapi.internal;

import java.net.URI;
import java.util.concurrent.ExecutorService;
import org.byted.security.zti.jwt.shaded.io.grpc.ManagedChannel;
import org.byted.security.zti.jwt.shaded.io.grpc.netty.shaded.io.grpc.netty.NegotiationType;
import org.byted.security.zti.jwt.shaded.io.grpc.netty.shaded.io.grpc.netty.NettyChannelBuilder;
import org.byted.security.zti.jwt.shaded.io.grpc.netty.shaded.io.netty.channel.ChannelOption;
import org.byted.security.zti.jwt.shaded.io.grpc.netty.shaded.io.netty.channel.EventLoopGroup;
import org.byted.security.zti.jwt.shaded.io.grpc.netty.shaded.io.netty.channel.epoll.EpollDomainSocketChannel;
import org.byted.security.zti.jwt.shaded.io.grpc.netty.shaded.io.netty.channel.epoll.EpollEventLoopGroup;
import org.byted.security.zti.jwt.shaded.io.grpc.netty.shaded.io.netty.channel.unix.DomainSocketAddress;
import org.byted.security.zti.jwt.shaded.io.spiffe.workloadapi.internal.ManagedChannelWrapper;
import org.byted.security.zti.jwt.shaded.org.apache.commons.lang3.SystemUtils;
import shaded.bytehouse.lombok.NonNull;

public final class GrpcManagedChannelFactory {
    private static final String UNIX_SCHEME = "unix";
    private static final String TCP_SCHEME = "tcp";

    private GrpcManagedChannelFactory() {
    }

    public static ManagedChannelWrapper newChannel(@NonNull URI address, ExecutorService executorService) {
        ManagedChannelWrapper result;
        String scheme;
        if (address == null) {
            throw new NullPointerException("address is marked non-null but is null");
        }
        switch (scheme = address.getScheme()) {
            case "unix": {
                result = GrpcManagedChannelFactory.createNativeSocketChannel(address, executorService);
                break;
            }
            case "tcp": {
                result = GrpcManagedChannelFactory.createTcpChannel(address);
                break;
            }
            default: {
                throw new IllegalArgumentException("Address Scheme not supported: ");
            }
        }
        return result;
    }

    private static ManagedChannelWrapper createNativeSocketChannel(@NonNull URI address, ExecutorService executorService) {
        if (address == null) {
            throw new NullPointerException("address is marked non-null but is null");
        }
        NettyChannelBuilder channelBuilder = NettyChannelBuilder.forAddress(new DomainSocketAddress(address.getPath()));
        EventLoopGroup eventLoopGroup = GrpcManagedChannelFactory.configureNativeSocketChannel(channelBuilder, executorService);
        ManagedChannel managedChannel = channelBuilder.usePlaintext().build();
        return new ManagedChannelWrapper(managedChannel, eventLoopGroup);
    }

    private static ManagedChannelWrapper createTcpChannel(@NonNull URI address) {
        if (address == null) {
            throw new NullPointerException("address is marked non-null but is null");
        }
        ManagedChannel managedChannel = NettyChannelBuilder.forAddress(address.getHost(), address.getPort()).negotiationType(NegotiationType.PLAINTEXT).build();
        return new ManagedChannelWrapper(managedChannel);
    }

    private static EventLoopGroup configureNativeSocketChannel(@NonNull NettyChannelBuilder channelBuilder, ExecutorService executorService) {
        if (channelBuilder == null) {
            throw new NullPointerException("channelBuilder is marked non-null but is null");
        }
        if (SystemUtils.IS_OS_LINUX) {
            EpollEventLoopGroup epollEventLoopGroup = new EpollEventLoopGroup(0, executorService);
            channelBuilder.eventLoopGroup(epollEventLoopGroup).withOption(ChannelOption.SO_KEEPALIVE, null).channelType(EpollDomainSocketChannel.class);
            return epollEventLoopGroup;
        }
        throw new IllegalStateException("Operating System is not supported.");
    }
}

