/*
 * Decompiled with CFR 0.152.
 */
package org.byted.security.ztijwthelper;

import java.text.ParseException;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import org.byted.security.zti.jwt.shaded.com.nimbusds.jwt.JWTClaimsSet;
import org.byted.security.zti.jwt.shaded.com.nimbusds.jwt.SignedJWT;
import org.byted.security.zti.jwt.shaded.io.spiffe.spiffeid.SpiffeId;
import org.byted.security.zti.jwt.shaded.org.apache.commons.lang3.StringUtils;
import org.byted.security.ztijwthelper.LegacyIdentity;
import org.byted.security.ztijwthelper.ZTIJwtDaemon;
import org.byted.security.ztijwthelper.ZeroTrustIdentity;
import org.byted.security.ztijwthelper.ZtiJwtException;
import org.byted.security.ztijwthelper.ZtiMetrics;

public class ZTIJwtHelper {
    private static ZTIJwtDaemon daemon = ZTIJwtDaemon.getInstance();

    public static String getJwtSVID() throws ZtiJwtException {
        String token = daemon.getToken();
        if (token != null) {
            ZtiMetrics.emitCounter("get_token", new String[0]);
            return token;
        }
        ZtiMetrics.emitCounter("get_token_error", new String[0]);
        throw new ZtiJwtException("the token is empty!");
    }

    public static String getTokenSource() {
        return daemon.getTokenSource();
    }

    @Deprecated
    public static ZeroTrustIdentity decodeJwtSVID(String tokenString) throws ZtiJwtException {
        SignedJWT signedJwt = ZTIJwtHelper.getSignedJWT(tokenString);
        JWTClaimsSet claimsSet = ZTIJwtHelper.getJwtClaimsSet(signedJwt);
        return ZTIJwtHelper.getSpiffeIdOfSubject(claimsSet);
    }

    @Deprecated
    public static LegacyIdentity decodeGDPRorJwtSVID(String tokenString) throws ZtiJwtException {
        try {
            SignedJWT signedJWT = SignedJWT.parse(tokenString);
            JWTClaimsSet claimsSet = ZTIJwtHelper.getJwtClaimsSet(signedJWT);
            if (ZTIJwtHelper.isTokenZti(tokenString)) {
                ZeroTrustIdentity zti = ZTIJwtHelper.getSpiffeIdOfSubject(claimsSet);
                return zti.getLegacyID();
            }
            return ZTIJwtHelper.createLegacyIdentity(claimsSet);
        }
        catch (Exception e) {
            throw new ZtiJwtException(e.getMessage());
        }
    }

    public static boolean isTokenZti(String tokenString) {
        try {
            SignedJWT signedJWT = SignedJWT.parse(tokenString);
            String keyID = signedJWT.getHeader().getKeyID();
            if (!StringUtils.isBlank(keyID)) {
                return true;
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    private static SignedJWT getSignedJWT(String tokenString) throws ZtiJwtException {
        SignedJWT signedJwt;
        try {
            signedJwt = SignedJWT.parse(tokenString);
        }
        catch (ParseException e) {
            throw new ZtiJwtException(String.format("Unable to parse JWT token string with err %s", e.toString()));
        }
        return signedJwt;
    }

    private static JWTClaimsSet getJwtClaimsSet(SignedJWT signedJwt) throws ZtiJwtException {
        JWTClaimsSet claimsSet;
        try {
            claimsSet = signedJwt.getJWTClaimsSet();
        }
        catch (ParseException e) {
            throw new ZtiJwtException(String.format("Unable to get JWT token claims with err %s", e.toString()));
        }
        return claimsSet;
    }

    private static ZeroTrustIdentity getSpiffeIdOfSubject(JWTClaimsSet claimsSet) throws ZtiJwtException {
        String subject = claimsSet.getSubject();
        if (StringUtils.isBlank(subject)) {
            throw new ZtiJwtException("Token missing subject claim");
        }
        try {
            Map<String, Object> legacyMap;
            ZeroTrustIdentity zti = new ZeroTrustIdentity();
            zti.SpiffeID = SpiffeId.parse(subject);
            zti.Expiry = claimsSet.getExpirationTime();
            String dpr = claimsSet.getStringClaim("dpr");
            if (StringUtils.isNotBlank(dpr) && dpr.startsWith("spiffe://")) {
                zti.DelegatedSpiffeID = SpiffeId.parse(dpr);
            }
            if ((legacyMap = claimsSet.getJSONObjectClaim("legid")) != null) {
                LegacyIdentity legID = new LegacyIdentity();
                legID.Version = legacyMap.get("version") != null ? Long.valueOf(Long.parseLong(legacyMap.get("version").toString())) : null;
                legID.Authority = legacyMap.get("authority") != null ? legacyMap.get("authority").toString() : null;
                legID.AuthorityChain = legacyMap.get("authorityChain") != null ? (List)legacyMap.get("authorityChain") : null;
                legID.PrimaryAuthType = legacyMap.get("primaryAuthType") != null ? legacyMap.get("primaryAuthType").toString() : null;
                legID.PSM = legacyMap.get("psm") != null ? legacyMap.get("psm").toString() : null;
                legID.User = legacyMap.get("user") != null ? legacyMap.get("user").toString() : null;
                legID.ExpireTime = legacyMap.get("expireTime") != null ? Long.valueOf(Long.parseLong(legacyMap.get("expireTime").toString())) : null;
                legID.Extension = legacyMap.get("extension") != null ? (Map)legacyMap.get("extension") : null;
                zti.LegacyID = legID;
            }
            zti.validateZTI();
            return zti;
        }
        catch (IllegalArgumentException | ParseException e) {
            throw new ZtiJwtException(String.format("Subject %s cannot be parsed as a SPIFFE ID with err %s", subject, e.toString()));
        }
    }

    private static LegacyIdentity createLegacyIdentity(JWTClaimsSet jwt) {
        LegacyIdentity identity = new LegacyIdentity();
        identity.Version = jwt.getClaim("version") != null ? Long.parseLong(jwt.getClaim("version").toString()) : 0L;
        identity.Authority = jwt.getClaim("authority") != null ? jwt.getClaim("authority").toString() : "";
        identity.AuthorityChain = jwt.getClaim("authorityChain") != null ? (List)jwt.getClaim("authorityChain") : null;
        identity.PrimaryAuthType = jwt.getClaim("primaryAuthType") != null ? jwt.getClaim("primaryAuthType").toString() : "";
        identity.PSM = jwt.getClaim("psm") != null ? jwt.getClaim("psm").toString() : "";
        identity.User = jwt.getClaim("user") != null ? jwt.getClaim("user").toString() : "";
        identity.ExpireTime = jwt.getClaim("expireTime") != null ? Long.parseLong(jwt.getClaim("expireTime").toString()) : 0L;
        identity.Extension = jwt.getClaim("extension") != null ? (Map)jwt.getClaim("extension") : null;
        return identity;
    }

    public static void main(String[] args) {
        Scanner scanner = new Scanner(System.in);
        block0: while (true) {
            System.out.println("Please input a line");
            final String line = scanner.nextLine();
            int i = 0;
            while (true) {
                if (i >= 100) continue block0;
                new Thread(){

                    @Override
                    public void run() {
                        try {
                            String tokenString = ZTIJwtHelper.getJwtSVID();
                            System.out.println(tokenString);
                            boolean isZti = ZTIJwtHelper.isTokenZti(tokenString);
                            if (isZti) {
                                System.out.println("it's a zti token");
                                ZeroTrustIdentity zti = ZTIJwtHelper.decodeJwtSVID(tokenString);
                                System.out.println("User input: " + line + " ID: " + zti.ID);
                            }
                            LegacyIdentity identity1 = ZTIJwtHelper.decodeGDPRorJwtSVID(tokenString);
                            System.out.println("identity: " + identity1.toString());
                        }
                        catch (ZtiJwtException e) {
                            e.printStackTrace();
                        }
                    }
                }.start();
                ++i;
            }
            break;
        }
    }
}

