/*
 * Decompiled with CFR 0.152.
 */
package org.byted.security.ztijwthelper;

import java.util.ArrayList;
import java.util.logging.Logger;
import org.byted.security.zti.jwt.shaded.com.bytedance.metrics.BytedanceMetricsV2;
import org.byted.security.zti.jwt.shaded.com.google.common.collect.Lists;
import org.byted.security.zti.jwt.shaded.org.apache.commons.lang3.StringUtils;

class ZtiMetrics {
    private static final Logger LOG = Logger.getLogger(ZtiMetrics.class.getName());
    private static final String METRICS_DELIMITER = "|";
    private static final String ZTI_METRICS_PREFIX = "security.zti.jwt_helper";
    private static final String VERSION_TAG = "ver=1.0.23";
    private static final String LANGUAGE_TAG = "language=java";
    private static final String TCE_PSM = System.getenv("TCE_PSM");
    private static BytedanceMetricsV2 metricsV2;
    public static final String GET_TOKEN_FAIL = "get_token_error";
    public static final String GET_TOKEN_SUCCEED = "get_token";
    public static final String GET_TOKEN_FROM_STRING = "get_token_from_string";
    public static final String GET_TOKEN_FROM_AGENT_FAIL = "get_token_from_agent_fail";
    public static final String FETCH_TOKEN_FROM_PATH_FAILED = "fetch_token_path_error";
    private static volatile boolean closed;

    private ZtiMetrics() {
    }

    public static void close() {
        if (closed) {
            return;
        }
        metricsV2.close();
        closed = true;
    }

    public static void emitCounter(String metricName, String ... tagKV) {
        ZtiMetrics.emitCounter(metricName, 1L, tagKV);
    }

    public static void emitCounter(String metricName, long metricValue, String ... tagKV) {
        if (closed) {
            return;
        }
        try {
            String tagString = ZtiMetrics.formatArrayTags(tagKV);
            metricsV2.emitCounter(metricName, metricValue, tagString);
        }
        catch (Throwable ex) {
            LOG.warning("emit metrics error" + ex.getMessage());
        }
    }

    private static String formatArrayTags(String[] tags) {
        String fmt = "{%s}";
        String defaultTag = "language=java|ver=1.0.23";
        if (TCE_PSM != null && !TCE_PSM.isEmpty()) {
            defaultTag = defaultTag + "|_psm=" + TCE_PSM;
        }
        if (tags == null || tags.length == 0) {
            return String.format(fmt, defaultTag);
        }
        ArrayList<String> tagList = Lists.newArrayListWithExpectedSize(tags.length / 2);
        for (int i = 0; i <= tags.length - 2; i += 2) {
            tagList.add(tags[i] + "=" + tags[i + 1]);
        }
        return String.format(fmt, defaultTag + METRICS_DELIMITER + StringUtils.join(tagList, METRICS_DELIMITER));
    }

    static {
        closed = false;
        try {
            metricsV2 = BytedanceMetricsV2.newBuilder().setPrefix(ZTI_METRICS_PREFIX).build();
        }
        catch (Throwable ex) {
            LOG.warning("init metrics error" + ex.getMessage());
            closed = true;
        }
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                ZtiMetrics.close();
            }
        }));
    }
}

