/*
 * Decompiled with CFR 0.152.
 */
package shaded.bytehouse.com.fasterxml.jackson.core;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import shaded.bytehouse.com.fasterxml.jackson.core.ErrorReportConfiguration;
import shaded.bytehouse.com.fasterxml.jackson.core.JsonFactory;
import shaded.bytehouse.com.fasterxml.jackson.core.JsonGenerator;
import shaded.bytehouse.com.fasterxml.jackson.core.JsonParser;
import shaded.bytehouse.com.fasterxml.jackson.core.StreamReadConstraints;
import shaded.bytehouse.com.fasterxml.jackson.core.StreamReadFeature;
import shaded.bytehouse.com.fasterxml.jackson.core.StreamWriteConstraints;
import shaded.bytehouse.com.fasterxml.jackson.core.StreamWriteFeature;
import shaded.bytehouse.com.fasterxml.jackson.core.io.InputDecorator;
import shaded.bytehouse.com.fasterxml.jackson.core.io.OutputDecorator;
import shaded.bytehouse.com.fasterxml.jackson.core.json.JsonReadFeature;
import shaded.bytehouse.com.fasterxml.jackson.core.json.JsonWriteFeature;
import shaded.bytehouse.com.fasterxml.jackson.core.util.BufferRecycler;
import shaded.bytehouse.com.fasterxml.jackson.core.util.JsonGeneratorDecorator;
import shaded.bytehouse.com.fasterxml.jackson.core.util.JsonRecyclerPools;
import shaded.bytehouse.com.fasterxml.jackson.core.util.RecyclerPool;

public abstract class TSFBuilder<F extends JsonFactory, B extends TSFBuilder<F, B>> {
    protected static final int DEFAULT_FACTORY_FEATURE_FLAGS = JsonFactory.Feature.collectDefaults();
    protected static final int DEFAULT_PARSER_FEATURE_FLAGS = JsonParser.Feature.collectDefaults();
    protected static final int DEFAULT_GENERATOR_FEATURE_FLAGS = JsonGenerator.Feature.collectDefaults();
    protected int _factoryFeatures;
    protected int _streamReadFeatures;
    protected int _streamWriteFeatures;
    protected RecyclerPool<BufferRecycler> _recyclerPool = JsonRecyclerPools.defaultPool();
    protected InputDecorator _inputDecorator;
    protected OutputDecorator _outputDecorator;
    protected StreamReadConstraints _streamReadConstraints;
    protected StreamWriteConstraints _streamWriteConstraints;
    protected ErrorReportConfiguration _errorReportConfiguration;
    protected List<JsonGeneratorDecorator> _generatorDecorators;

    protected TSFBuilder() {
        this(DEFAULT_FACTORY_FEATURE_FLAGS, DEFAULT_PARSER_FEATURE_FLAGS, DEFAULT_GENERATOR_FEATURE_FLAGS);
    }

    protected TSFBuilder(JsonFactory base) {
        this(base._factoryFeatures, base._parserFeatures, base._generatorFeatures);
        this._inputDecorator = base._inputDecorator;
        this._outputDecorator = base._outputDecorator;
        this._streamReadConstraints = base._streamReadConstraints;
        this._streamWriteConstraints = base._streamWriteConstraints;
        this._errorReportConfiguration = base._errorReportConfiguration;
        this._generatorDecorators = TSFBuilder._copy(base._generatorDecorators);
    }

    protected TSFBuilder(int factoryFeatures, int parserFeatures, int generatorFeatures) {
        this._factoryFeatures = factoryFeatures;
        this._streamReadFeatures = parserFeatures;
        this._streamWriteFeatures = generatorFeatures;
        this._inputDecorator = null;
        this._outputDecorator = null;
        this._streamReadConstraints = StreamReadConstraints.defaults();
        this._streamWriteConstraints = StreamWriteConstraints.defaults();
        this._errorReportConfiguration = ErrorReportConfiguration.defaults();
        this._generatorDecorators = null;
    }

    protected static <T> List<T> _copy(List<T> src) {
        if (src == null) {
            return src;
        }
        return new ArrayList<T>(src);
    }

    public int factoryFeaturesMask() {
        return this._factoryFeatures;
    }

    public int streamReadFeatures() {
        return this._streamReadFeatures;
    }

    public int streamWriteFeatures() {
        return this._streamWriteFeatures;
    }

    public RecyclerPool<BufferRecycler> recyclerPool() {
        return this._recyclerPool;
    }

    public InputDecorator inputDecorator() {
        return this._inputDecorator;
    }

    public OutputDecorator outputDecorator() {
        return this._outputDecorator;
    }

    public B enable(JsonFactory.Feature f) {
        this._factoryFeatures |= f.getMask();
        return this._this();
    }

    public B disable(JsonFactory.Feature f) {
        this._factoryFeatures &= ~f.getMask();
        return this._this();
    }

    public B configure(JsonFactory.Feature f, boolean state) {
        return state ? this.enable(f) : this.disable(f);
    }

    public B enable(StreamReadFeature f) {
        this._streamReadFeatures |= f.mappedFeature().getMask();
        return this._this();
    }

    public B enable(StreamReadFeature first2, StreamReadFeature ... other) {
        this._streamReadFeatures |= first2.mappedFeature().getMask();
        for (StreamReadFeature f : other) {
            this._streamReadFeatures |= f.mappedFeature().getMask();
        }
        return this._this();
    }

    public B disable(StreamReadFeature f) {
        this._streamReadFeatures &= ~f.mappedFeature().getMask();
        return this._this();
    }

    public B disable(StreamReadFeature first2, StreamReadFeature ... other) {
        this._streamReadFeatures &= ~first2.mappedFeature().getMask();
        for (StreamReadFeature f : other) {
            this._streamReadFeatures &= ~f.mappedFeature().getMask();
        }
        return this._this();
    }

    public B configure(StreamReadFeature f, boolean state) {
        return state ? this.enable(f) : this.disable(f);
    }

    public B enable(StreamWriteFeature f) {
        this._streamWriteFeatures |= f.mappedFeature().getMask();
        return this._this();
    }

    public B enable(StreamWriteFeature first2, StreamWriteFeature ... other) {
        this._streamWriteFeatures |= first2.mappedFeature().getMask();
        for (StreamWriteFeature f : other) {
            this._streamWriteFeatures |= f.mappedFeature().getMask();
        }
        return this._this();
    }

    public B disable(StreamWriteFeature f) {
        this._streamWriteFeatures &= ~f.mappedFeature().getMask();
        return this._this();
    }

    public B disable(StreamWriteFeature first2, StreamWriteFeature ... other) {
        this._streamWriteFeatures &= ~first2.mappedFeature().getMask();
        for (StreamWriteFeature f : other) {
            this._streamWriteFeatures &= ~f.mappedFeature().getMask();
        }
        return this._this();
    }

    public B configure(StreamWriteFeature f, boolean state) {
        return state ? this.enable(f) : this.disable(f);
    }

    public B enable(JsonReadFeature f) {
        return this._failNonJSON(f);
    }

    public B enable(JsonReadFeature first2, JsonReadFeature ... other) {
        return this._failNonJSON(first2);
    }

    public B disable(JsonReadFeature f) {
        return this._failNonJSON(f);
    }

    public B disable(JsonReadFeature first2, JsonReadFeature ... other) {
        return this._failNonJSON(first2);
    }

    public B configure(JsonReadFeature f, boolean state) {
        return this._failNonJSON(f);
    }

    private B _failNonJSON(Object feature) {
        throw new IllegalArgumentException("Feature " + feature.getClass().getName() + "#" + feature.toString() + " not supported for non-JSON backend");
    }

    public B enable(JsonWriteFeature f) {
        return this._failNonJSON(f);
    }

    public B enable(JsonWriteFeature first2, JsonWriteFeature ... other) {
        return this._failNonJSON(first2);
    }

    public B disable(JsonWriteFeature f) {
        return this._failNonJSON(f);
    }

    public B disable(JsonWriteFeature first2, JsonWriteFeature ... other) {
        return this._failNonJSON(first2);
    }

    public B configure(JsonWriteFeature f, boolean state) {
        return this._failNonJSON(f);
    }

    public B recyclerPool(RecyclerPool<BufferRecycler> p) {
        this._recyclerPool = Objects.requireNonNull(p);
        return this._this();
    }

    public B inputDecorator(InputDecorator dec) {
        this._inputDecorator = dec;
        return this._this();
    }

    public B outputDecorator(OutputDecorator dec) {
        this._outputDecorator = dec;
        return this._this();
    }

    public B addDecorator(JsonGeneratorDecorator decorator) {
        if (this._generatorDecorators == null) {
            this._generatorDecorators = new ArrayList<JsonGeneratorDecorator>();
        }
        this._generatorDecorators.add(decorator);
        return this._this();
    }

    public B streamReadConstraints(StreamReadConstraints streamReadConstraints) {
        this._streamReadConstraints = Objects.requireNonNull(streamReadConstraints);
        return this._this();
    }

    public B streamWriteConstraints(StreamWriteConstraints streamWriteConstraints) {
        this._streamWriteConstraints = Objects.requireNonNull(streamWriteConstraints);
        return this._this();
    }

    public B errorReportConfiguration(ErrorReportConfiguration errorReportConfiguration) {
        this._errorReportConfiguration = Objects.requireNonNull(errorReportConfiguration);
        return this._this();
    }

    public abstract F build();

    protected final B _this() {
        return (B)this;
    }

    protected void _legacyEnable(JsonParser.Feature f) {
        if (f != null) {
            this._streamReadFeatures |= f.getMask();
        }
    }

    protected void _legacyDisable(JsonParser.Feature f) {
        if (f != null) {
            this._streamReadFeatures &= ~f.getMask();
        }
    }

    protected void _legacyEnable(JsonGenerator.Feature f) {
        if (f != null) {
            this._streamWriteFeatures |= f.getMask();
        }
    }

    protected void _legacyDisable(JsonGenerator.Feature f) {
        if (f != null) {
            this._streamWriteFeatures &= ~f.getMask();
        }
    }
}

