/*
 * Decompiled with CFR 0.152.
 */
package shaded.bytehouse.com.fasterxml.jackson.core.internal.shaded.fdp.v2_19_2;

import java.math.BigInteger;
import java.util.Map;
import shaded.bytehouse.com.fasterxml.jackson.core.internal.shaded.fdp.v2_19_2.BigSignificand;
import shaded.bytehouse.com.fasterxml.jackson.core.internal.shaded.fdp.v2_19_2.FastDoubleSwar;
import shaded.bytehouse.com.fasterxml.jackson.core.internal.shaded.fdp.v2_19_2.FastIntegerMath;
import shaded.bytehouse.com.fasterxml.jackson.core.internal.shaded.fdp.v2_19_2.FftMultiplier;

class ParseDigitsTaskCharSequence {
    private ParseDigitsTaskCharSequence() {
    }

    static BigInteger parseDigitsIterative(CharSequence str, int from2, int to) {
        assert (str != null) : "str==null";
        int numDigits = to - from2;
        BigSignificand bigSignificand = new BigSignificand(FastIntegerMath.estimateNumBits(numDigits));
        int preroll = from2 + (numDigits & 7);
        int value = FastDoubleSwar.tryToParseUpTo7Digits(str, from2, preroll);
        boolean success = value >= 0;
        bigSignificand.add(value);
        for (from2 = preroll; from2 < to; from2 += 8) {
            int addend = FastDoubleSwar.tryToParseEightDigits(str, from2);
            success &= addend >= 0;
            bigSignificand.fma(100000000, addend);
        }
        if (!success) {
            throw new NumberFormatException("illegal syntax");
        }
        return bigSignificand.toBigInteger();
    }

    static BigInteger parseDigitsRecursive(CharSequence str, int from2, int to, Map<Integer, BigInteger> powersOfTen, int recursionThreshold) {
        assert (str != null) : "str==null";
        assert (powersOfTen != null) : "powersOfTen==null";
        int numDigits = to - from2;
        if (numDigits <= recursionThreshold) {
            return ParseDigitsTaskCharSequence.parseDigitsIterative(str, from2, to);
        }
        int mid = FastIntegerMath.splitFloor16(from2, to);
        BigInteger high = ParseDigitsTaskCharSequence.parseDigitsRecursive(str, from2, mid, powersOfTen, recursionThreshold);
        BigInteger low = ParseDigitsTaskCharSequence.parseDigitsRecursive(str, mid, to, powersOfTen, recursionThreshold);
        high = FftMultiplier.multiply(high, powersOfTen.get(to - mid));
        return low.add(high);
    }
}

