/*
 * Decompiled with CFR 0.152.
 */
package shaded.bytehouse.net.openhft.hashing;

import java.lang.reflect.Field;
import javax.annotation.ParametersAreNonnullByDefault;
import shaded.bytehouse.net.openhft.hashing.LongHashFunction;
import shaded.bytehouse.net.openhft.hashing.LongTupleHashFunction;
import shaded.bytehouse.net.openhft.hashing.StringHash;
import shaded.bytehouse.net.openhft.hashing.UnsafeAccess;

@ParametersAreNonnullByDefault
enum ModernHotSpotStringHash implements StringHash
{
    INSTANCE;

    private static final long valueOffset;

    @Override
    public long longHash(String s2, LongHashFunction hashFunction, int off, int len) {
        char[] value = (char[])UnsafeAccess.UNSAFE.getObject(s2, valueOffset);
        return hashFunction.hashChars(value, off, len);
    }

    @Override
    public void hash(String s2, LongTupleHashFunction hashFunction, int off, int len, long[] result) {
        char[] value = (char[])UnsafeAccess.UNSAFE.getObject(s2, valueOffset);
        hashFunction.hashChars(value, off, len, result);
    }

    static {
        try {
            Field valueField = String.class.getDeclaredField("value");
            valueOffset = UnsafeAccess.UNSAFE.objectFieldOffset(valueField);
        }
        catch (NoSuchFieldException e) {
            throw new AssertionError((Object)e);
        }
    }
}

