/*
 * Decompiled with CFR 0.152.
 */
package shaded.bytehouse.org.apache.commons.lang3.mutable;

import shaded.bytehouse.org.apache.commons.lang3.mutable.Mutable;

public class MutableInt
extends Number
implements Comparable<MutableInt>,
Mutable<Number> {
    private static final long serialVersionUID = 512176391864L;
    private int value;

    public MutableInt() {
    }

    public MutableInt(int value) {
        this.value = value;
    }

    public MutableInt(Number value) {
        this.value = value.intValue();
    }

    public MutableInt(String value) {
        this.value = Integer.parseInt(value);
    }

    public void add(int operand) {
        this.value += operand;
    }

    public void add(Number operand) {
        this.value += operand.intValue();
    }

    public int addAndGet(int operand) {
        this.value += operand;
        return this.value;
    }

    public int addAndGet(Number operand) {
        this.value += operand.intValue();
        return this.value;
    }

    @Override
    public int compareTo(MutableInt other) {
        return Integer.compare(this.value, other.value);
    }

    public void decrement() {
        --this.value;
    }

    public int decrementAndGet() {
        --this.value;
        return this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    public boolean equals(Object obj) {
        if (obj instanceof MutableInt) {
            return this.value == ((MutableInt)obj).intValue();
        }
        return false;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    public int getAndAdd(int operand) {
        int last2 = this.value;
        this.value += operand;
        return last2;
    }

    public int getAndAdd(Number operand) {
        int last2 = this.value;
        this.value += operand.intValue();
        return last2;
    }

    public int getAndDecrement() {
        int last2 = this.value--;
        return last2;
    }

    public int getAndIncrement() {
        int last2 = this.value++;
        return last2;
    }

    @Override
    @Deprecated
    public Integer getValue() {
        return this.value;
    }

    public int hashCode() {
        return this.value;
    }

    public void increment() {
        ++this.value;
    }

    public int incrementAndGet() {
        ++this.value;
        return this.value;
    }

    @Override
    public int intValue() {
        return this.value;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    @Override
    public void setValue(int value) {
        this.value = value;
    }

    @Override
    public void setValue(Number value) {
        this.value = value.intValue();
    }

    public void subtract(int operand) {
        this.value -= operand;
    }

    public void subtract(Number operand) {
        this.value -= operand.intValue();
    }

    public Integer toInteger() {
        return this.intValue();
    }

    public String toString() {
        return String.valueOf(this.value);
    }
}

