/*
 * Decompiled with CFR 0.152.
 */
package com.bytedance.bytehouse.clickhouse;

import com.bytedance.bytehouse.clickhouse.ClickHouseExpr$;
import com.bytedance.bytehouse.clickhouse.ClickHouseSetting;
import com.bytedance.bytehouse.clickhouse.ClickHouseSqlClauseUtils;
import com.bytedance.bytehouse.clickhouse.ClickHouseSqlClauseUtils$CreateTableClauseSettings$;
import com.bytedance.bytehouse.clickhouse.ClickHouseSqlClauseUtils$LimitClauseSetting$;
import com.bytedance.bytehouse.clickhouse.ClickHouseSqlClauseUtils$OffsetClauseSetting$;
import com.bytedance.bytehouse.clickhouse.ClickHouseSqlClauseUtils$WhereClauseSetting$;
import com.bytedance.bytehouse.clickhouse.ClickHouseSqlUtils;
import com.bytedance.bytehouse.clickhouse.ClickHouseSqlUtils$TableEngineTypes$CnchMergeTree$;
import com.bytedance.bytehouse.commons.ChainingOps$;
import com.bytedance.bytehouse.commons.SqlFormatUtils;
import com.bytedance.bytehouse.commons.package$;
import com.bytedance.bytehouse.commons.package$StringOps$;
import com.bytedance.bytehouse.table.SqlUtilsBase;
import com.bytedance.bytehouse.table.TableSchema$;
import com.bytedance.bytehouse.table.TableSchema$BasicTableSchemaOps$;
import java.io.Serializable;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.TraversableOnce$;
import scala.collection.immutable.ListMap;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Try$;
import scala.util.matching.Regex;

public final class ClickHouseSqlUtils$
implements SqlUtilsBase {
    public static ClickHouseSqlUtils$ MODULE$;
    private final String UniqueKeyPattern;
    private final Regex CaptureUniqueKeyPattern;
    private final String ShardingKeyPattern;
    private final Regex CaptureShardingKeyPattern;
    private final Regex CaptureSettingsPattern;
    private final Regex CapturePartialUpdateModePattern;
    private final Regex CaptureCommonTableModePattern;
    private final Regex CaptureBinlogShardNum;

    static {
        new ClickHouseSqlUtils$();
    }

    @Override
    public String sqlShowDatabases() {
        return SqlUtilsBase.sqlShowDatabases$(this);
    }

    @Override
    public String sqlDropTable(String tableName) {
        return SqlUtilsBase.sqlDropTable$(this, tableName);
    }

    @Override
    public String sqlDropTable(String dbName, String tableName) {
        return SqlUtilsBase.sqlDropTable$(this, dbName, tableName);
    }

    @Override
    public String sqlDropTableIfExists(String tableName) {
        return SqlUtilsBase.sqlDropTableIfExists$(this, tableName);
    }

    @Override
    public String sqlDropTableIfExists(String dbName, String tableName) {
        return SqlUtilsBase.sqlDropTableIfExists$(this, dbName, tableName);
    }

    @Override
    public String sqlShowCreateTable(String dbName, String tableName) {
        return SqlUtilsBase.sqlShowCreateTable$(this, dbName, tableName);
    }

    @Override
    public String sqlSelect(String tableName, String fieldExpr, Option<String> filterCondition) {
        return SqlUtilsBase.sqlSelect$((SqlUtilsBase)this, tableName, fieldExpr, filterCondition);
    }

    @Override
    public String sqlSelect(String dbName, String tableName, String fieldExpr, Option<String> filterCondition) {
        return SqlUtilsBase.sqlSelect$((SqlUtilsBase)this, dbName, tableName, fieldExpr, filterCondition);
    }

    @Override
    public String sqlSelect(String tableName, String fieldExpr, Option<String> filterCondition, Option<String> orderBySetting) {
        return SqlUtilsBase.sqlSelect$((SqlUtilsBase)this, tableName, fieldExpr, filterCondition, orderBySetting);
    }

    @Override
    public String sqlSelect(String tableName, String[] fieldNames, Option<String> filterCondition) {
        return SqlUtilsBase.sqlSelect$((SqlUtilsBase)this, tableName, fieldNames, filterCondition);
    }

    @Override
    public String sqlSelect(String tableName, String[] fieldNames, Option<String> filterCondition, Option<String> orderBySetting) {
        return SqlUtilsBase.sqlSelect$((SqlUtilsBase)this, tableName, fieldNames, filterCondition, orderBySetting);
    }

    @Override
    public String sqlSelectAll(String tableName, String[] fieldNames) {
        return SqlUtilsBase.sqlSelectAll$(this, tableName, fieldNames);
    }

    @Override
    public String sqlGetTableRecordCount(String tableName, Option<String> filterCondition) {
        return SqlUtilsBase.sqlGetTableRecordCount$(this, tableName, filterCondition);
    }

    @Override
    public String sqlScanTable(String tableName, Option<String> filterCondition) {
        return SqlUtilsBase.sqlScanTable$(this, tableName, filterCondition);
    }

    @Override
    public String sqlScanTable(String tableName, String orderBy, Option<String> filterCondition, long offset, long limit) {
        return SqlUtilsBase.sqlScanTable$(this, tableName, orderBy, filterCondition, offset, limit);
    }

    @Override
    public String sqlLookup(String tableName, String[] fieldNames, String[] keyNames) {
        return SqlUtilsBase.sqlLookup$(this, tableName, fieldNames, keyNames);
    }

    @Override
    public String sqlInsertFromTable(String fromTableName, Seq<String> fromColExprs, String intoTableName, Seq<String> intoColNames, Option<String> filterCondition) {
        return SqlUtilsBase.sqlInsertFromTable$((SqlUtilsBase)this, fromTableName, fromColExprs, intoTableName, intoColNames, filterCondition);
    }

    @Override
    public Option<String> sqlInsertFromTable$default$5() {
        return SqlUtilsBase.sqlInsertFromTable$default$5$(this);
    }

    @Override
    public String sqlInsertFromTable(String fromTable, String intoTable, Seq<String> colNames) {
        return SqlUtilsBase.sqlInsertFromTable$(this, fromTable, intoTable, colNames);
    }

    @Override
    public String sqlInsertFromTable(String dbName, String fromTableName, Seq<String> fromColNames, String intoTableName, Seq<String> intoColNames) {
        return SqlUtilsBase.sqlInsertFromTable$((SqlUtilsBase)this, dbName, fromTableName, fromColNames, intoTableName, intoColNames);
    }

    @Override
    public String sqlInsertFromTable(String dbName, String fromTable, String intoTable, Seq<String> colNames) {
        return SqlUtilsBase.sqlInsertFromTable$(this, dbName, fromTable, intoTable, colNames);
    }

    @Override
    public String sqlSet(String key, String value) {
        return SqlUtilsBase.sqlSet$(this, key, value);
    }

    @Override
    public String validateAndQualify(String dbName, String tableName) {
        return SqlUtilsBase.validateAndQualify$(this, dbName, tableName);
    }

    @Override
    public boolean skipsQuotingForValue(String s2) {
        return SqlFormatUtils.skipsQuotingForValue$(this, s2);
    }

    @Override
    public SqlFormatUtils.SeqStringOps SeqStringOps(Seq<String> xs) {
        return SqlFormatUtils.SeqStringOps$(this, xs);
    }

    public String sqlDropTable(String clusterName, String dbName, String tableName) {
        Predef$.MODULE$.require(package$StringOps$.MODULE$.nonBlank$extension(package$.MODULE$.StringOps(clusterName)), (Function0 & Serializable & scala.Serializable)() -> "Missing cluster name (non-blank)");
        Predef$.MODULE$.require(package$StringOps$.MODULE$.nonBlank$extension(package$.MODULE$.StringOps(dbName)), (Function0 & Serializable & scala.Serializable)() -> "Missing database name (non-blank)");
        Predef$.MODULE$.require(package$StringOps$.MODULE$.nonBlank$extension(package$.MODULE$.StringOps(tableName)), (Function0 & Serializable & scala.Serializable)() -> "Missing table name (non-blank)");
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(37).append("DROP TABLE ").append(package$StringOps$.MODULE$.backQuotedIfNot$extension(package$.MODULE$.StringOps(dbName))).append(".").append(package$StringOps$.MODULE$.backQuotedIfNot$extension(package$.MODULE$.StringOps(tableName))).append("\n       |ON CLUSTER ").append(package$StringOps$.MODULE$.backQuotedIfNot$extension(package$.MODULE$.StringOps(clusterName))).append(" SYNC").toString())).stripMargin();
    }

    public String sqlDropTableIfExists(String clusterName, String dbName, String tableName) {
        Predef$.MODULE$.require(package$StringOps$.MODULE$.nonBlank$extension(package$.MODULE$.StringOps(clusterName)), (Function0 & Serializable & scala.Serializable)() -> "Missing cluster name (non-blank)");
        Predef$.MODULE$.require(package$StringOps$.MODULE$.nonBlank$extension(package$.MODULE$.StringOps(dbName)), (Function0 & Serializable & scala.Serializable)() -> "Missing database name (non-blank)");
        Predef$.MODULE$.require(package$StringOps$.MODULE$.nonBlank$extension(package$.MODULE$.StringOps(tableName)), (Function0 & Serializable & scala.Serializable)() -> "Missing table name (non-blank)");
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(47).append("DROP TABLE IF EXISTS ").append(package$StringOps$.MODULE$.backQuotedIfNot$extension(package$.MODULE$.StringOps(dbName))).append(".").append(package$StringOps$.MODULE$.backQuotedIfNot$extension(package$.MODULE$.StringOps(tableName))).append("\n       |ON CLUSTER ").append(package$StringOps$.MODULE$.backQuotedIfNot$extension(package$.MODULE$.StringOps(clusterName))).append(" SYNC").toString())).stripMargin();
    }

    public <T> String sqlSet(ClickHouseSetting<T> setting) {
        return new StringBuilder(4).append("SET ").append(setting.toSqlString()).toString();
    }

    public String sqlShowTables(String dbName) {
        Predef$.MODULE$.require(package$StringOps$.MODULE$.nonBlank$extension(package$.MODULE$.StringOps(dbName)));
        return new StringBuilder(17).append("SHOW TABLES FROM ").append(package$StringOps$.MODULE$.backQuotedIfNot$extension(package$.MODULE$.StringOps(dbName))).toString();
    }

    public String sqlDescribeTable(String tableName) {
        Predef$.MODULE$.require(package$StringOps$.MODULE$.nonBlank$extension(package$.MODULE$.StringOps(tableName)), (Function0 & Serializable & scala.Serializable)() -> "Missing table name");
        return new StringBuilder(15).append("DESCRIBE TABLE ").append(package$StringOps$.MODULE$.backQuotedIfNot$extension(package$.MODULE$.StringOps(tableName))).toString();
    }

    public String sqlDescribeTable(String dbName, String tableName) {
        Predef$.MODULE$.require(package$StringOps$.MODULE$.nonBlank$extension(package$.MODULE$.StringOps(dbName)), (Function0 & Serializable & scala.Serializable)() -> "Missing database name");
        Predef$.MODULE$.require(package$StringOps$.MODULE$.nonBlank$extension(package$.MODULE$.StringOps(tableName)), (Function0 & Serializable & scala.Serializable)() -> "Missing table name");
        return new StringBuilder(16).append("DESCRIBE TABLE ").append(package$StringOps$.MODULE$.backQuotedIfNot$extension(package$.MODULE$.StringOps(dbName))).append(".").append(package$StringOps$.MODULE$.backQuotedIfNot$extension(package$.MODULE$.StringOps(tableName))).toString();
    }

    public String sqlCountDistinctShards(String clusterName) {
        Predef$.MODULE$.require(package$StringOps$.MODULE$.nonBlank$extension(package$.MODULE$.StringOps(clusterName)), (Function0 & Serializable & scala.Serializable)() -> "Missing cluster name (non-blank)");
        return (String)ChainingOps$.MODULE$.$bar$greater$extension(ChainingOps$.MODULE$.scalaUtilChainingOps(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(135).append("SELECT count(DISTINCT shard_num) as ").append("shard_count").append("\n       |FROM system.clusters\n       |WHERE cluster = ").append(package$StringOps$.MODULE$.singleQuoted$extension(package$.MODULE$.StringOps(clusterName))).append("\n       |GROUP BY cluster\n       |").toString())).stripMargin()), (Function1 & Serializable & scala.Serializable)sql -> MODULE$.compact((String)sql));
    }

    public String replaceTableDdl(String ddl, String newTableName) {
        return ChainingOps$.MODULE$.tap$extension(ChainingOps$.MODULE$.scalaUtilChainingOps(ddl.replaceFirst("(?i)(?<=CREATE\\sTABLE\\s)([0-9a-zA-Z_\\-\\s.`]+\\.[0-9a-zA-Z_\\-\\s.`]+)(?i)(?=\\s[UUID])", newTableName)), (Function1 & Serializable & scala.Serializable)x$1 -> {
            ClickHouseSqlUtils$.$anonfun$replaceTableDdl$1(ddl, x$1);
            return BoxedUnit.UNIT;
        }).replaceFirst("UUID\\s+'[a-zA-Z0-9_\\-]+'\\s", "").replaceFirst(this.UniqueKeyPattern(), "");
    }

    private final String UniqueKeyPattern() {
        return this.UniqueKeyPattern;
    }

    private final Regex CaptureUniqueKeyPattern() {
        return this.CaptureUniqueKeyPattern;
    }

    public String captureUniqueKey(String ddl) {
        return this.captureRegexPayload(ddl, this.CaptureUniqueKeyPattern());
    }

    public Option<Object> resolvedNumBuckets(int numBuckets) {
        return Option$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)numBuckets)).filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$2 -> x$2 > 0);
    }

    public Option<String> resolvedBucketKey(String colNamesClusterBy) {
        return Option$.MODULE$.apply((Object)colNamesClusterBy).filter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)ClickHouseSqlUtils$.$anonfun$resolvedBucketKey$1(x$3))).map((Function1 & Serializable & scala.Serializable)expr -> ClickHouseExpr$.MODULE$.extractVariables((String)expr)).map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.mkString(", "));
    }

    public Option<String> resolvedBucketKeyExpression(boolean isClusterByExplicitExpression, String exprClusterBy) {
        if (!isClusterByExplicitExpression) {
            return this.getBucketExpression(exprClusterBy);
        }
        return Option$.MODULE$.apply((Object)exprClusterBy).filter((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)ClickHouseSqlUtils$.$anonfun$resolvedBucketKeyExpression$1(x$5)));
    }

    public Option<String> getBucketExpression(String exprClusterBy) {
        return Option$.MODULE$.apply((Object)exprClusterBy).filter((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)ClickHouseSqlUtils$.$anonfun$getBucketExpression$1(x$6))).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            String string = x0$1;
            if (string.startsWith("(") && string.endsWith(")")) {
                return new StringBuilder(9).append("sipHash64").append(string).toString();
            }
            return new StringBuilder(11).append("sipHash64(").append(string).append(")").toString();
        });
    }

    public Option<String> resolvedShardingKey(String ddl) {
        return Option$.MODULE$.apply((Object)this.captureRegexPayload(ddl, this.CaptureShardingKeyPattern())).filter((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)ClickHouseSqlUtils$.$anonfun$resolvedShardingKey$1(x$7))).map((Function1 & Serializable & scala.Serializable)expr -> ClickHouseExpr$.MODULE$.extractVariables((String)expr)).filter((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)x$8.nonEmpty())).map((Function1 & Serializable & scala.Serializable)x$9 -> x$9.mkString(", "));
    }

    private final String ShardingKeyPattern() {
        return this.ShardingKeyPattern;
    }

    private final Regex CaptureShardingKeyPattern() {
        return this.CaptureShardingKeyPattern;
    }

    public Option<String> resolvedShardingExpression(String ddl) {
        return Option$.MODULE$.apply((Object)this.captureRegexPayload(ddl, this.CaptureShardingKeyPattern())).filter((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)ClickHouseSqlUtils$.$anonfun$resolvedShardingExpression$1(x$10)));
    }

    public String captureSettingsPayload(String ddl) {
        return this.captureRegexPayload(ddl, this.CaptureSettingsPattern());
    }

    private final Regex CaptureSettingsPattern() {
        return this.CaptureSettingsPattern;
    }

    public Option<Object> capturePartialUpdateMode(String ddl) {
        return this.CapturePartialUpdateModePattern().findFirstMatchIn((CharSequence)ddl).map((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToInteger((int)ClickHouseSqlUtils$.$anonfun$capturePartialUpdateMode$1(x$11)));
    }

    private final Regex CapturePartialUpdateModePattern() {
        return this.CapturePartialUpdateModePattern;
    }

    private String captureRegexPayload(String ddl, Regex regex) {
        return (String)Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            String string = package$StringOps$.MODULE$.flattenToSingleLine$extension(package$.MODULE$.StringOps(ddl));
            Option option = regex.unapplySeq((CharSequence)string);
            if (option.isEmpty() || option.get() == null || ((LinearSeqOptimized)option.get()).lengthCompare(1) != 0) {
                throw new MatchError((Object)string);
            }
            String payload = (String)((LinearSeqOptimized)option.get()).apply(0);
            String payload2 = payload;
            return payload2;
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
    }

    public Option<Object> captureCommonTableMode(String ddl) {
        return this.CaptureCommonTableModePattern().findFirstMatchIn((CharSequence)ddl).map((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToInteger((int)ClickHouseSqlUtils$.$anonfun$captureCommonTableMode$1(x$12)));
    }

    private final Regex CaptureCommonTableModePattern() {
        return this.CaptureCommonTableModePattern;
    }

    public int captureBinlogShardNum(String ddl, int n) {
        return BoxesRunTime.unboxToInt((Object)this.CaptureBinlogShardNum().findFirstMatchIn((CharSequence)ddl).map((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToInteger((int)ClickHouseSqlUtils$.$anonfun$captureBinlogShardNum$1(x$13))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> n));
    }

    public int captureBinlogShardNum$default$2() {
        return 64;
    }

    private final Regex CaptureBinlogShardNum() {
        return this.CaptureBinlogShardNum;
    }

    public String sqlCreateTable(String dbName, String tableName, ListMap<String, String> schema, Option<String> clusterName, ClickHouseSqlClauseUtils.CreateTableClauseSettings clauseSettings, ClickHouseSqlUtils.TableEngineType engine) {
        return this.implSqlCreateTable("CREATE TABLE", dbName, tableName, schema, clusterName, clauseSettings, engine);
    }

    public Option<String> sqlCreateTable$default$4() {
        return None$.MODULE$;
    }

    public ClickHouseSqlClauseUtils.CreateTableClauseSettings sqlCreateTable$default$5() {
        return ClickHouseSqlClauseUtils$CreateTableClauseSettings$.MODULE$.default();
    }

    public String sqlCreateTableIfNotExists(String dbName, String tableName, ListMap<String, String> schema, Option<String> clusterName, ClickHouseSqlClauseUtils.CreateTableClauseSettings clauseSettings, ClickHouseSqlUtils.TableEngineType engine) {
        return this.implSqlCreateTable("CREATE TABLE IF NOT EXISTS", dbName, tableName, schema, clusterName, clauseSettings, engine);
    }

    public Option<String> sqlCreateTableIfNotExists$default$4() {
        return None$.MODULE$;
    }

    public ClickHouseSqlClauseUtils.CreateTableClauseSettings sqlCreateTableIfNotExists$default$5() {
        return ClickHouseSqlClauseUtils$CreateTableClauseSettings$.MODULE$.default();
    }

    private String implSqlCreateTable(String keyword, String dbName, String tableName, ListMap<String, String> schema, Option<String> clusterName, ClickHouseSqlClauseUtils.CreateTableClauseSettings clauseSettings, ClickHouseSqlUtils.TableEngineType engine) {
        Predef$.MODULE$.require(package$StringOps$.MODULE$.nonBlank$extension(package$.MODULE$.StringOps(tableName)));
        Predef$.MODULE$.require(schema.nonEmpty());
        ListMap<String, String> schemaForClauseConstruction = schema;
        ClickHouseSqlUtils.TableEngineType tableEngineType = engine;
        String onClusterClause = ClickHouseSqlUtils$TableEngineTypes$CnchMergeTree$.MODULE$.equals(tableEngineType) ? "" : new StringBuilder(13).append("ON CLUSTER `").append(clusterName.get()).append("`").toString();
        Predef$.MODULE$.assert(keyword.startsWith("CREATE TABLE"));
        return package$StringOps$.MODULE$.blankLinesRemoved$extension(package$.MODULE$.StringOps(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(51).append("\n       |").append(keyword).append(" ").append(package$StringOps$.MODULE$.backQuotedIfNot$extension(package$.MODULE$.StringOps(dbName))).append(".").append(package$StringOps$.MODULE$.backQuotedIfNot$extension(package$.MODULE$.StringOps(tableName))).append(" ").append(onClusterClause).append(" (\n       |").append(this.SeqStringOps((Seq<String>)TableSchema$BasicTableSchemaOps$.MODULE$.toSqlColumns$extension0(TableSchema$.MODULE$.BasicTableSchemaOps(schema)).toSeq()).withIndent(2).mkString(",\n")).append("\n       |)\n       |").append(engine.toClause()).append("\n       |").append(clauseSettings.toClauses(schemaForClauseConstruction)).toString())).stripMargin()));
    }

    public String sqlTruncateTable(String dbName, String tableName) {
        Predef$.MODULE$.require(package$StringOps$.MODULE$.nonBlank$extension(package$.MODULE$.StringOps(dbName)), (Function0 & Serializable & scala.Serializable)() -> "Missing database name (non-blank)");
        Predef$.MODULE$.require(package$StringOps$.MODULE$.nonBlank$extension(package$.MODULE$.StringOps(tableName)), (Function0 & Serializable & scala.Serializable)() -> "Missing table name (non-blank)");
        return new StringBuilder(16).append("TRUNCATE TABLE ").append(package$StringOps$.MODULE$.backQuotedIfNot$extension(package$.MODULE$.StringOps(dbName))).append(".").append(package$StringOps$.MODULE$.backQuotedIfNot$extension(package$.MODULE$.StringOps(tableName))).toString();
    }

    public String sqlTruncateTable(String clusterName, String dbName, String tableName) {
        Predef$.MODULE$.require(package$StringOps$.MODULE$.nonBlank$extension(package$.MODULE$.StringOps(clusterName)), (Function0 & Serializable & scala.Serializable)() -> "Missing cluster name (non-blank)");
        Predef$.MODULE$.require(package$StringOps$.MODULE$.nonBlank$extension(package$.MODULE$.StringOps(dbName)), (Function0 & Serializable & scala.Serializable)() -> "Missing database name (non-blank)");
        Predef$.MODULE$.require(package$StringOps$.MODULE$.nonBlank$extension(package$.MODULE$.StringOps(tableName)), (Function0 & Serializable & scala.Serializable)() -> "Missing table name (non-blank)");
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(36).append("TRUNCATE TABLE ").append(package$StringOps$.MODULE$.backQuotedIfNot$extension(package$.MODULE$.StringOps(dbName))).append(".").append(package$StringOps$.MODULE$.backQuotedIfNot$extension(package$.MODULE$.StringOps(tableName))).append("\n       |ON CLUSTER ").append(package$StringOps$.MODULE$.backQuotedIfNot$extension(package$.MODULE$.StringOps(clusterName))).toString())).stripMargin();
    }

    public String sqlSelect(String dbName, String tableName, Seq<String> columnNamesIncluded, Option<String> filterCondition, Option<String> querySettings) {
        String fieldExpr = columnNamesIncluded.isEmpty() ? "*" : ((TraversableOnce)columnNamesIncluded.map((Function1 & Serializable & scala.Serializable)x$14 -> package$StringOps$.MODULE$.backQuotedIfNot$extension(package$.MODULE$.StringOps(x$14.trim())), Seq$.MODULE$.canBuildFrom())).mkString(", ");
        return new StringBuilder(14).append("SELECT ").append(fieldExpr).append(" FROM ").append(package$StringOps$.MODULE$.backQuotedIfNot$extension(package$.MODULE$.StringOps(dbName))).append(".").append(package$StringOps$.MODULE$.backQuotedIfNot$extension(package$.MODULE$.StringOps(tableName))).append(filterCondition.filter((Function1 & Serializable & scala.Serializable)x$15 -> BoxesRunTime.boxToBoolean((boolean)package$StringOps$.MODULE$.nonBlank$extension(package$.MODULE$.StringOps(x$15)))).map((Function1 & Serializable & scala.Serializable)x$16 -> new StringBuilder(7).append(" WHERE ").append((String)x$16).toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "")).append(querySettings.filter((Function1 & Serializable & scala.Serializable)x$17 -> BoxesRunTime.boxToBoolean((boolean)package$StringOps$.MODULE$.nonBlank$extension(package$.MODULE$.StringOps(x$17)))).map((Function1 & Serializable & scala.Serializable)x$18 -> new StringBuilder(10).append(" SETTINGS ").append((String)x$18).toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "")).toString();
    }

    public String sqlSelect(String[] fieldNames, String dbName, String tableName, ClickHouseSqlClauseUtils.WhereClauseSetting where, ClickHouseSqlClauseUtils.LimitClauseSetting limit, ClickHouseSqlClauseUtils.OffsetClauseSetting offset) {
        String string;
        Predef$.MODULE$.require(package$StringOps$.MODULE$.nonBlank$extension(package$.MODULE$.StringOps(dbName)));
        Predef$.MODULE$.require(package$StringOps$.MODULE$.nonBlank$extension(package$.MODULE$.StringOps(tableName)));
        if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fieldNames)).nonEmpty()) {
            Predef$.MODULE$.require(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fieldNames)).forall((Function1 & Serializable & scala.Serializable)x$19 -> BoxesRunTime.boxToBoolean((boolean)package$StringOps$.MODULE$.nonBlank$extension(package$.MODULE$.StringOps(x$19)))));
            string = this.prepareSqlColumnName(fieldNames).colNames();
        } else {
            string = "*";
        }
        String fieldsStr = string;
        return package$StringOps$.MODULE$.blankLinesRemoved$extension(package$.MODULE$.StringOps(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(49).append("SELECT ").append(fieldsStr).append("\n       |FROM ").append(package$StringOps$.MODULE$.backQuoted$extension(package$.MODULE$.StringOps(dbName))).append(".").append(package$StringOps$.MODULE$.backQuoted$extension(package$.MODULE$.StringOps(tableName))).append("\n       |").append(where.toClause()).append("\n       |").append(limit.toClause()).append("\n       |").append(offset.toClause()).toString())).stripMargin()));
    }

    public String[] sqlSelect$default$1() {
        return (String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class));
    }

    public ClickHouseSqlClauseUtils.WhereClauseSetting sqlSelect$default$4(String[] fieldNames) {
        return ClickHouseSqlClauseUtils$WhereClauseSetting$.MODULE$.Nil();
    }

    public ClickHouseSqlClauseUtils.LimitClauseSetting sqlSelect$default$5(String[] fieldNames) {
        return ClickHouseSqlClauseUtils$LimitClauseSetting$.MODULE$.Nil();
    }

    public ClickHouseSqlClauseUtils.OffsetClauseSetting sqlSelect$default$6(String[] fieldNames) {
        return ClickHouseSqlClauseUtils$OffsetClauseSetting$.MODULE$.Nil();
    }

    public String sqlSelectWithSettings(String tableName, String[] fieldNames, Option<String> filterCondition, ClickHouseSqlClauseUtils.SettingsClauseSetting settings) {
        return package$StringOps$.MODULE$.flattenToSingleLine$extension(package$.MODULE$.StringOps(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(9).append(this.sqlSelect(tableName, fieldNames, filterCondition)).append("\n       |").append(settings.toClause()).toString())).stripMargin()));
    }

    public ClickHouseSqlUtils.PreparedColumnNames prepareSqlColumnName(String[] fields) {
        return new ClickHouseSqlUtils.PreparedColumnNames(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fields)).map((Function1 & Serializable & scala.Serializable)x$20 -> package$StringOps$.MODULE$.backQuotedIfNot$extension(package$.MODULE$.StringOps((String)x$20)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString(", "), ((TraversableOnce)Seq$.MODULE$.fill(fields.length, (Function0 & Serializable & scala.Serializable)() -> "?")).mkString(", "));
    }

    public String sqlCountRows(String table) {
        return new StringBuilder(30).append("SELECT COUNT(*) AS total FROM ").append(package$StringOps$.MODULE$.backQuoted$extension(package$.MODULE$.StringOps(table))).toString();
    }

    public String sqlInsert(String tableName, String[] fieldNames) {
        Predef$.MODULE$.require(package$StringOps$.MODULE$.nonBlank$extension(package$.MODULE$.StringOps(tableName)));
        Predef$.MODULE$.require(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fieldNames)).nonEmpty() && new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fieldNames)).forall((Function1 & Serializable & scala.Serializable)x$21 -> BoxesRunTime.boxToBoolean((boolean)package$StringOps$.MODULE$.nonBlank$extension(package$.MODULE$.StringOps(x$21)))));
        ClickHouseSqlUtils.PreparedColumnNames preparedColumnNames = this.prepareSqlColumnName(fieldNames);
        if (preparedColumnNames == null) {
            throw new MatchError((Object)preparedColumnNames);
        }
        String colNames = preparedColumnNames.colNames();
        String placeholders = preparedColumnNames.placeholders();
        Tuple2 tuple2 = new Tuple2((Object)colNames, (Object)placeholders);
        String colNames2 = (String)tuple2._1();
        String placeholders2 = (String)tuple2._2();
        return new StringBuilder(25).append("INSERT INTO ").append(package$StringOps$.MODULE$.backQuoted$extension(package$.MODULE$.StringOps(tableName))).append(" (").append(colNames2).append(") VALUES (").append(placeholders2).append(")").toString();
    }

    public String sqlInsertWithSettings(String tableName, String[] fieldNames, TraversableOnce<ClickHouseSetting<?>> settings) {
        Predef$.MODULE$.require(package$StringOps$.MODULE$.nonBlank$extension(package$.MODULE$.StringOps(tableName)));
        Predef$.MODULE$.require(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fieldNames)).nonEmpty() && new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fieldNames)).forall((Function1 & Serializable & scala.Serializable)x$23 -> BoxesRunTime.boxToBoolean((boolean)package$StringOps$.MODULE$.nonBlank$extension(package$.MODULE$.StringOps(x$23)))));
        ClickHouseSqlUtils.PreparedColumnNames preparedColumnNames = this.prepareSqlColumnName(fieldNames);
        if (preparedColumnNames == null) {
            throw new MatchError((Object)preparedColumnNames);
        }
        String columns = preparedColumnNames.colNames();
        String placeholders = preparedColumnNames.placeholders();
        Tuple2 tuple2 = new Tuple2((Object)columns, (Object)placeholders);
        String columns2 = (String)tuple2._1();
        String placeholders2 = (String)tuple2._2();
        if (settings.isEmpty()) {
            return new StringBuilder(25).append("INSERT INTO ").append(package$StringOps$.MODULE$.backQuoted$extension(package$.MODULE$.StringOps(tableName))).append(" (").append(columns2).append(") VALUES (").append(placeholders2).append(")").toString();
        }
        return new StringBuilder(42).append("INSERT INTO ").append(package$StringOps$.MODULE$.backQuoted$extension(package$.MODULE$.StringOps(tableName))).append(" (").append(columns2).append(") ").append("SETTINGS ").append(TraversableOnce$.MODULE$.MonadOps(settings).map((Function1 & Serializable & scala.Serializable)x$25 -> x$25.toSqlString()).mkString(", ")).append(" FORMAT Values (").append(placeholders2).append(")").toString();
    }

    public String sqlLookupWithSettings(String tableName, String[] fieldNames, String[] keyNames, TraversableOnce<ClickHouseSetting<?>> settings) {
        return this.sqlLookupWithSettings(tableName, fieldNames, keyNames, new ClickHouseSqlClauseUtils.SettingsClauseSetting(settings));
    }

    public String sqlLookupWithSettings(String tableName, String[] fieldNames, String[] keyNames, ClickHouseSqlClauseUtils.SettingsClauseSetting settings) {
        return package$StringOps$.MODULE$.flattenToSingleLine$extension(package$.MODULE$.StringOps(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(9).append(this.sqlLookup(tableName, fieldNames, keyNames)).append("\n       |").append(settings.toClause()).toString())).stripMargin()));
    }

    public String sqlDelete(String table, String[] predicateFields) {
        Predef$.MODULE$.require(package$StringOps$.MODULE$.nonBlank$extension(package$.MODULE$.StringOps(table)));
        Predef$.MODULE$.require(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])predicateFields)).nonEmpty() && new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])predicateFields)).forall((Function1 & Serializable & scala.Serializable)x$26 -> BoxesRunTime.boxToBoolean((boolean)package$StringOps$.MODULE$.nonBlank$extension(package$.MODULE$.StringOps(x$26)))));
        String predicates = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])predicateFields)).map((Function1 & Serializable & scala.Serializable)x$27 -> new StringBuilder(2).append(package$StringOps$.MODULE$.backQuoted$extension(package$.MODULE$.StringOps((String)x$27))).append("=?").toString(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString(" AND ");
        return new StringBuilder(26).append("ALTER TABLE ").append(package$StringOps$.MODULE$.backQuoted$extension(package$.MODULE$.StringOps(table))).append(" DELETE WHERE ").append(predicates).toString();
    }

    public String sqlUpdate(String table, String[] updateFields, String[] predicateFields) {
        Predef$.MODULE$.require(package$StringOps$.MODULE$.nonBlank$extension(package$.MODULE$.StringOps(table)));
        Predef$.MODULE$.require(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])updateFields)).nonEmpty() && new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])updateFields)).forall((Function1 & Serializable & scala.Serializable)x$28 -> BoxesRunTime.boxToBoolean((boolean)package$StringOps$.MODULE$.nonBlank$extension(package$.MODULE$.StringOps(x$28.trim())))));
        Predef$.MODULE$.require(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])predicateFields)).nonEmpty() && new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])predicateFields)).forall((Function1 & Serializable & scala.Serializable)x$29 -> BoxesRunTime.boxToBoolean((boolean)package$StringOps$.MODULE$.nonBlank$extension(package$.MODULE$.StringOps(x$29.trim())))));
        String updates = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])updateFields)).map((Function1 & Serializable & scala.Serializable)x$30 -> new StringBuilder(2).append(package$StringOps$.MODULE$.backQuoted$extension(package$.MODULE$.StringOps((String)x$30))).append("=?").toString(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString(", ");
        String predicates = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])predicateFields)).map((Function1 & Serializable & scala.Serializable)x$31 -> new StringBuilder(2).append(package$StringOps$.MODULE$.backQuoted$extension(package$.MODULE$.StringOps((String)x$31))).append("=?").toString(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString(" AND ");
        return new StringBuilder(27).append("ALTER TABLE ").append(package$StringOps$.MODULE$.backQuoted$extension(package$.MODULE$.StringOps(table))).append(" UPDATE ").append(updates).append(" WHERE ").append(predicates).toString();
    }

    public String sqlGetColumnIndex(String dbName, String tableName, String columnName) {
        Predef$.MODULE$.require(package$StringOps$.MODULE$.nonBlank$extension(package$.MODULE$.StringOps(dbName)), (Function0 & Serializable & scala.Serializable)() -> "Database name should not be blank");
        Predef$.MODULE$.require(package$StringOps$.MODULE$.nonBlank$extension(package$.MODULE$.StringOps(tableName)), (Function0 & Serializable & scala.Serializable)() -> "Table name should not be blank");
        Predef$.MODULE$.require(package$StringOps$.MODULE$.nonBlank$extension(package$.MODULE$.StringOps(columnName)), (Function0 & Serializable & scala.Serializable)() -> "Column name should not be blank");
        String[] x$1 = (String[])((Object[])new String[]{"position"});
        String x$2 = "system";
        String x$3 = "columns";
        ClickHouseSqlClauseUtils.WhereClauseSetting x$4 = ClickHouseSqlClauseUtils$WhereClauseSetting$.MODULE$.of((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(11).append("database = ").append(package$StringOps$.MODULE$.singleQuoted$extension(package$.MODULE$.StringOps(dbName))).toString(), new StringBuilder(12).append("AND table = ").append(package$StringOps$.MODULE$.singleQuoted$extension(package$.MODULE$.StringOps(tableName))).toString(), new StringBuilder(11).append("AND name = ").append(package$StringOps$.MODULE$.singleQuoted$extension(package$.MODULE$.StringOps(columnName))).toString()}));
        ClickHouseSqlClauseUtils.LimitClauseSetting x$5 = this.sqlSelect$default$5(x$1);
        ClickHouseSqlClauseUtils.OffsetClauseSetting x$6 = this.sqlSelect$default$6(x$1);
        return this.sqlSelect(x$1, x$2, x$3, x$4, x$5, x$6);
    }

    public String sqlAlterTable(String dbName, String tableName, String manipulation) {
        return new StringBuilder(14).append("ALTER TABLE ").append(package$StringOps$.MODULE$.backQuotedIfNot$extension(package$.MODULE$.StringOps(dbName))).append(".").append(package$StringOps$.MODULE$.backQuotedIfNot$extension(package$.MODULE$.StringOps(tableName))).append(" ").append(manipulation).toString();
    }

    public String sqlAddColumn(String dbName, String tableName, String colName, String colType, String position) {
        return this.sqlAlterTable(dbName, tableName, new StringBuilder(13).append("ADD COLUMN ").append(package$StringOps$.MODULE$.backQuotedIfNot$extension(package$.MODULE$.StringOps(colName))).append(" ").append(colType).append(" ").append(position).toString().trim());
    }

    public String sqlAddColumn$default$5() {
        return "";
    }

    public String sqlDropColumnIfExists(String dbName, String tableName, String colName) {
        return this.sqlAlterTable(dbName, tableName, new StringBuilder(22).append("DROP COLUMN IF EXISTS ").append(package$StringOps$.MODULE$.backQuotedIfNot$extension(package$.MODULE$.StringOps(colName))).toString());
    }

    public String sqlRenameColumn(String dbName, String tableName, String oldColName, String newColName) {
        return this.sqlAlterTable(dbName, tableName, new StringBuilder(18).append("RENAME COLUMN ").append(package$StringOps$.MODULE$.backQuotedIfNot$extension(package$.MODULE$.StringOps(oldColName))).append(" TO ").append(package$StringOps$.MODULE$.backQuotedIfNot$extension(package$.MODULE$.StringOps(newColName))).toString());
    }

    public String sqlModifyColumn(String dbName, String tableName, String colName, String colDef, String position) {
        return this.sqlAlterTable(dbName, tableName, new StringBuilder(16).append("MODIFY COLUMN ").append(package$StringOps$.MODULE$.backQuotedIfNot$extension(package$.MODULE$.StringOps(colName))).append(" ").append(colDef).append(" ").append(position).toString().trim());
    }

    public String sqlModifyColumn$default$5() {
        return "";
    }

    @Override
    public String compact(String sql) {
        return SqlUtilsBase.compact$(this, sql).replaceAll("(?i)\\bENGINE\\b(?-i)\\s*=\\s*(\\w+)\\s*\\(", "ENGINE = $1(");
    }

    public static final /* synthetic */ void $anonfun$replaceTableDdl$1(String ddl$1, String x$1) {
        String string = x$1;
        String string2 = ddl$1;
        ChainingOps$.MODULE$.$bar$greater$extension(ChainingOps$.MODULE$.scalaUtilChainingOps(BoxesRunTime.boxToBoolean(((string == null ? string2 != null : !string.equals(string2)) ? 1 : 0) != 0)), (Function1 & Serializable & scala.Serializable)assertion -> {
            Predef$.MODULE$.assert(BoxesRunTime.unboxToBoolean((Object)assertion));
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$resolvedBucketKey$1(String x$3) {
        return new StringOps(Predef$.MODULE$.augmentString(x$3)).nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$resolvedBucketKeyExpression$1(String x$5) {
        return new StringOps(Predef$.MODULE$.augmentString(x$5)).nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$getBucketExpression$1(String x$6) {
        return new StringOps(Predef$.MODULE$.augmentString(x$6)).nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$resolvedShardingKey$1(String x$7) {
        return new StringOps(Predef$.MODULE$.augmentString(x$7)).nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$resolvedShardingExpression$1(String x$10) {
        return new StringOps(Predef$.MODULE$.augmentString(x$10)).nonEmpty();
    }

    public static final /* synthetic */ int $anonfun$capturePartialUpdateMode$1(Regex.Match x$11) {
        return new StringOps(Predef$.MODULE$.augmentString(x$11.group(1))).toInt();
    }

    public static final /* synthetic */ int $anonfun$captureCommonTableMode$1(Regex.Match x$12) {
        return new StringOps(Predef$.MODULE$.augmentString(x$12.group(1))).toInt();
    }

    public static final /* synthetic */ int $anonfun$captureBinlogShardNum$1(Regex.Match x$13) {
        return new StringOps(Predef$.MODULE$.augmentString(x$13.group(1))).toInt();
    }

    private ClickHouseSqlUtils$() {
        MODULE$ = this;
        SqlFormatUtils.$init$(this);
        SqlUtilsBase.$init$(this);
        this.UniqueKeyPattern = "UNIQUE\\s+KEY\\s+(\\w+\\b(?!\\()|`[^`]+`|(?:\\w+)?\\((?:\\w+(?:\\([^)]+\\))?|`[^`]+`)(?:\\s*,\\s*(?:\\w+(?:\\([^)]+\\))?|`[^`]+`))*\\))";
        this.CaptureUniqueKeyPattern = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(4).append(".*").append(this.UniqueKeyPattern()).append(".*").toString())).r();
        this.ShardingKeyPattern = "(?i)ENGINE\\s*=\\s*Distributed\\([^,]+,\\s*[^,]+,\\s*[^,]+,\\s*(\\w+\\([^)]*\\)|\\([^)]*\\)|\\w+|`[^`]+`|(?:\\w+)?\\((?:\\w+(?:\\([^\\)]+\\))?|`[^`]+`)(?:\\s*,\\s*(?:\\w+(?:\\([^\\)]+\\))?|`[^`]+`))*\\))\\)";
        this.CaptureShardingKeyPattern = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(4).append(".*").append(this.ShardingKeyPattern()).append(".*").toString())).r();
        this.CaptureSettingsPattern = new StringOps(Predef$.MODULE$.augmentString("^.*SETTINGS (.*)$")).r();
        this.CapturePartialUpdateModePattern = new StringOps(Predef$.MODULE$.augmentString("enable_unique_partial_update\\s*=\\s*([01])")).r();
        this.CaptureCommonTableModePattern = new StringOps(Predef$.MODULE$.augmentString("enable_common_table_mode\\s*=\\s*([01])")).r();
        this.CaptureBinlogShardNum = new StringOps(Predef$.MODULE$.augmentString("binlog_shard_num\\s*=\\s*(\\d+)")).r();
    }
}

