/*
 * Decompiled with CFR 0.152.
 */
package com.bytedance.bytehouse.clickhouse.functions;

import java.nio.charset.Charset;

public class CityHash64Impl {
    private static final long k0 = -4348849565147123417L;
    private static final long k1 = -5435081209227447693L;
    private static final long k2 = -7286425919675154353L;
    private static final long k3 = -3942382747735136937L;
    private static final long k5 = -7070675565921424023L;

    private CityHash64Impl() {
    }

    public static long combine(long l, long l2) {
        return CityHash64Impl.HashLen16(l, l2);
    }

    public static long hash(String string, Charset charset) {
        byte[] byArray = string.getBytes(charset);
        return CityHash64Impl.hash(byArray, 0, byArray.length);
    }

    public static long hash(byte[] byArray, int n, int n2) {
        if (n2 <= 16) {
            return CityHash64Impl.HashLen0to16(byArray, n, n2);
        }
        if (n2 <= 32) {
            return CityHash64Impl.HashLen17to32(byArray, n, n2);
        }
        if (n2 <= 64) {
            return CityHash64Impl.HashLen33to64(byArray, n, n2);
        }
        long l = CityHash64Impl.Fetch64(byArray, n);
        long l2 = CityHash64Impl.Fetch64(byArray, n + n2 - 16) ^ 0xB492B66FBE98F273L;
        long l3 = CityHash64Impl.Fetch64(byArray, n + n2 - 56) ^ 0xC3A5C85C97CB3127L;
        long[] lArray = CityHash64Impl.WeakHashLen32WithSeeds(byArray, n2 - 64, n2, l2);
        long[] lArray2 = CityHash64Impl.WeakHashLen32WithSeeds(byArray, n2 - 32, (long)n2 * -5435081209227447693L, -4348849565147123417L);
        l = CityHash64Impl.Rotate((l3 += CityHash64Impl.ShiftMix(lArray[1]) * -5435081209227447693L) + l, 39) * -5435081209227447693L;
        l2 = CityHash64Impl.Rotate(l2, 33) * -5435081209227447693L;
        n2 = n2 - 1 & 0xFFFFFFC0;
        do {
            l = CityHash64Impl.Rotate(l + l2 + lArray[0] + CityHash64Impl.Fetch64(byArray, n + 16), 37) * -5435081209227447693L;
            l2 = CityHash64Impl.Rotate(l2 + lArray[1] + CityHash64Impl.Fetch64(byArray, n + 48), 42) * -5435081209227447693L;
            l3 = CityHash64Impl.Rotate(l3 ^ lArray2[0], 33);
            lArray = CityHash64Impl.WeakHashLen32WithSeeds(byArray, n, lArray[1] * -5435081209227447693L, (l ^= lArray2[1]) + lArray2[0]);
            lArray2 = CityHash64Impl.WeakHashLen32WithSeeds(byArray, n + 32, l3 + lArray2[1], l2 ^= lArray[0]);
            long l4 = l3;
            l3 = l;
            l = l4;
            n += 64;
        } while ((n2 -= 64) != 0);
        return CityHash64Impl.HashLen16(CityHash64Impl.HashLen16(lArray[0], lArray2[0]) + CityHash64Impl.ShiftMix(l2) * -5435081209227447693L + l3, CityHash64Impl.HashLen16(lArray[1], lArray2[1]) + l);
    }

    private static long HashLen0to16(byte[] byArray, int n, int n2) {
        if (n2 > 8) {
            long l = CityHash64Impl.Fetch64(byArray, n);
            long l2 = CityHash64Impl.Fetch64(byArray, n + n2 - 8);
            return CityHash64Impl.HashLen16(l, CityHash64Impl.RotateByAtLeastOne(l2 + (long)n2, n2)) ^ l2;
        }
        if (n2 >= 4) {
            long l = CityHash64Impl.Fetch32(byArray, n);
            return CityHash64Impl.HashLen16((long)n2 + (l << 3), CityHash64Impl.Fetch32(byArray, n + n2 - 4));
        }
        if (n2 > 0) {
            byte by2 = byArray[n];
            byte by3 = byArray[n + n2 >>> 1];
            byte by4 = byArray[n + n2 - 1];
            int n3 = CityHash64Impl.toInt(by2) + (CityHash64Impl.toInt(by3) << 8);
            int n4 = n2 + (CityHash64Impl.toInt(by4) << 2);
            return CityHash64Impl.ShiftMix((long)n3 * -7286425919675154353L ^ (long)n4 * -3942382747735136937L) * -7286425919675154353L;
        }
        return -7286425919675154353L;
    }

    private static long HashLen17to32(byte[] byArray, int n, int n2) {
        long l = CityHash64Impl.Fetch64(byArray, n) * -5435081209227447693L;
        long l2 = CityHash64Impl.Fetch64(byArray, n + 8);
        long l3 = CityHash64Impl.Fetch64(byArray, n + n2 - 8) * -7286425919675154353L;
        long l4 = CityHash64Impl.Fetch64(byArray, n + n2 - 16) * -4348849565147123417L;
        return CityHash64Impl.HashLen16(CityHash64Impl.Rotate(l - l2, 43) + CityHash64Impl.Rotate(l3, 30) + l4, l + CityHash64Impl.Rotate(l2 ^ 0xC949D7C7509E6557L, 20) - l3 + (long)n2);
    }

    private static long HashLen33to64(byte[] byArray, int n, int n2) {
        long l = CityHash64Impl.Fetch64(byArray, n + 24);
        long l2 = CityHash64Impl.Fetch64(byArray, n) + ((long)n2 + CityHash64Impl.Fetch64(byArray, n + n2 - 16)) * -4348849565147123417L;
        long l3 = CityHash64Impl.Rotate(l2 + l, 52);
        long l4 = CityHash64Impl.Rotate(l2, 37);
        long l5 = (l2 += CityHash64Impl.Fetch64(byArray, n + 16)) + l;
        long l6 = l3 + CityHash64Impl.Rotate(l2, 31) + (l4 += CityHash64Impl.Rotate(l2 += CityHash64Impl.Fetch64(byArray, n + 8), 7));
        l2 = CityHash64Impl.Fetch64(byArray, n + 16) + CityHash64Impl.Fetch64(byArray, n + n2 - 32);
        l = CityHash64Impl.Fetch64(byArray, n + n2 - 8);
        l3 = CityHash64Impl.Rotate(l2 + l, 52);
        l4 = CityHash64Impl.Rotate(l2, 37);
        long l7 = (l2 += CityHash64Impl.Fetch64(byArray, n + n2 - 16)) + l;
        long l8 = l3 + CityHash64Impl.Rotate(l2, 31) + (l4 += CityHash64Impl.Rotate(l2 += CityHash64Impl.Fetch64(byArray, n + n2 - 24), 7));
        long l9 = CityHash64Impl.ShiftMix((l5 + l8) * -7286425919675154353L + (l7 + l6) * -4348849565147123417L);
        return CityHash64Impl.ShiftMix(l9 * -4348849565147123417L + l6) * -7286425919675154353L;
    }

    private static long Fetch64(byte[] byArray, int n) {
        return CityHash64Impl.toLongLE(byArray, n);
    }

    private static long Fetch32(byte[] byArray, int n) {
        return CityHash64Impl.toIntLE(byArray, n);
    }

    private static long[] WeakHashLen32WithSeeds(long l, long l2, long l3, long l4, long l5, long l6) {
        l6 = CityHash64Impl.Rotate(l6 + (l5 += l) + l4, 21);
        long l7 = l5;
        l5 += l2;
        return new long[]{l5 + l4, (l6 += CityHash64Impl.Rotate(l5 += l3, 44)) + l7};
    }

    private static long[] WeakHashLen32WithSeeds(byte[] byArray, int n, long l, long l2) {
        return CityHash64Impl.WeakHashLen32WithSeeds(CityHash64Impl.Fetch64(byArray, n), CityHash64Impl.Fetch64(byArray, n + 8), CityHash64Impl.Fetch64(byArray, n + 16), CityHash64Impl.Fetch64(byArray, n + 24), l, l2);
    }

    private static long toLongLE(byte[] byArray, int n) {
        return ((long)byArray[n + 7] << 56) + ((long)(byArray[n + 6] & 0xFF) << 48) + ((long)(byArray[n + 5] & 0xFF) << 40) + ((long)(byArray[n + 4] & 0xFF) << 32) + ((long)(byArray[n + 3] & 0xFF) << 24) + (long)((byArray[n + 2] & 0xFF) << 16) + (long)((byArray[n + 1] & 0xFF) << 8) + (long)((byArray[n + 0] & 0xFF) << 0);
    }

    private static long toIntLE(byte[] byArray, int n) {
        return 0xFFFFFFFFL & ((long)(byArray[n + 3] & 0xFF) << 24) + (long)((byArray[n + 2] & 0xFF) << 16) + (long)((byArray[n + 1] & 0xFF) << 8) + (long)((byArray[n + 0] & 0xFF) << 0);
    }

    public static int toInt(byte by2) {
        return by2 & 0xFF;
    }

    private static long RotateByAtLeastOne(long l, int n) {
        return l >>> n | l << 64 - n;
    }

    private static long ShiftMix(long l) {
        return l ^ l >>> 47;
    }

    private static long UInt128Low64(long[] lArray) {
        return lArray[0];
    }

    private static long Rotate(long l, int n) {
        return n == 0 ? l : l >>> n | l << 64 - n;
    }

    private static long UInt128High64(long[] lArray) {
        return lArray[1];
    }

    private static long Hash128to64(long[] lArray) {
        long l = (CityHash64Impl.UInt128Low64(lArray) ^ CityHash64Impl.UInt128High64(lArray)) * -7070675565921424023L;
        l ^= l >>> 47;
        long l2 = (CityHash64Impl.UInt128High64(lArray) ^ l) * -7070675565921424023L;
        l2 ^= l2 >>> 47;
        return l2 *= -7070675565921424023L;
    }

    private static long HashLen16(long l, long l2) {
        return CityHash64Impl.Hash128to64(new long[]{l, l2});
    }
}

