/*
 * Decompiled with CFR 0.152.
 */
package com.bytedance.bytehouse.clickhouse.functions;

import com.bytedance.bytehouse.expr4s.FunctionExpr;
import com.bytedance.bytehouse.expr4s.FunctionExpr$;
import java.math.BigInteger;
import scala.collection.Seq;
import scala.math.BigInt;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import shaded.bytehouse.com.google.common.primitives.UnsignedInteger;
import shaded.bytehouse.com.google.common.primitives.UnsignedLong;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001db\u0001\u0002\n\u0014\u0001yA\u0001\"\n\u0001\u0003\u0002\u0003\u0006IA\n\u0005\u0006Y\u0001!\t!L\u0003\u0005c\u0001\u0001c\u0005C\u00033\u0001\u0011\u00053\u0007C\u0003=\u0001\u0011\u0005Q\bC\u0003=\u0001\u0011\u0005\u0001\nC\u0003=\u0001\u0011\u0005a\u000bC\u0003=\u0001\u0011\u0005!\rC\u0003=\u0001\u0011\u0005q\rC\u0003=\u0001\u0011\u0005A\u000eC\u0003=\u0001\u0011\u0005a\u000eC\u0003=\u0001\u0011\u00051\u000f\u0003\u0005y\u0001!\u0015\r\u0011\"\u0003z\u0011!Q\b\u0001#b\u0001\n\u0013Y\b\u0002\u0003?\u0001\u0011\u000b\u0007I\u0011B?\t\u0015\u0005\u0015\u0001\u0001#b\u0001\n\u0013\t9\u0001\u0003\u0006\u0002\n\u0001A)\u0019!C\u0005\u0003\u0017\u0011Q!T8emQR!\u0001F\u000b\u0002\u0013\u0019,hn\u0019;j_:\u001c(B\u0001\f\u0018\u0003)\u0019G.[2lQ>,8/\u001a\u0006\u00031e\t\u0011BY=uK\"|Wo]3\u000b\u0005iY\u0012!\u00032zi\u0016$\u0017M\\2f\u0015\u0005a\u0012aA2p[\u000e\u00011C\u0001\u0001 !\t\u00013%D\u0001\"\u0015\t\u0011s#\u0001\u0004fqB\u0014Hg]\u0005\u0003I\u0005\u0012ABR;oGRLwN\\#yaJ\fq\u0001Z5wSN|'\u000f\u0005\u0002(U5\t\u0001FC\u0001*\u0003\u0015\u00198-\u00197b\u0013\tY\u0003FA\u0002J]R\fa\u0001P5oSRtDC\u0001\u00181!\ty\u0003!D\u0001\u0014\u0011\u0015)#\u00011\u0001'\u0005)\u0011V\r^;s]RK\b/Z\u0001\u000bCB\u0004H.\u001f+p\u0003:LHC\u0001\u00145\u0011\u0015)D\u00011\u00017\u0003\u0011\t'oZ:\u0011\u0007\u001d:\u0014(\u0003\u00029Q\tQAH]3qK\u0006$X\r\u001a \u0011\u0005\u001dR\u0014BA\u001e)\u0005\r\te._\u0001\u0006CB\u0004H.\u001f\u000b\u0003MyBQaP\u0003A\u0002\u0001\u000b\u0011\u0001\u001f\t\u0003\u0003\u001ak\u0011A\u0011\u0006\u0003\u0007\u0012\u000bA!\\1uQ*\tQ)\u0001\u0003kCZ\f\u0017BA$C\u0005)\u0011\u0015nZ%oi\u0016<WM\u001d\u000b\u0003M%CQa\u0010\u0004A\u0002)\u0003\"aS*\u000f\u00051\u000bfBA'Q\u001b\u0005q%BA(\u001e\u0003\u0019a$o\\8u}%\t\u0011&\u0003\u0002SQ\u00059\u0001/Y2lC\u001e,\u0017B\u0001+V\u0005\u0019\u0011\u0015nZ%oi*\u0011!\u000b\u000b\u000b\u0003M]CQaP\u0004A\u0002a\u0003\"!\u00171\u000e\u0003iS1aWA\f\u0003)\u0001(/[7ji&4Xm\u001d\u0006\u0004;\u0006}\u0011AB2p[6|gNC\u0002`\u0003K\taaZ8pO2,\u0017BA1[\u00051)fn]5h]\u0016$Gj\u001c8h)\t13\rC\u0003@\u0011\u0001\u0007A\r\u0005\u0002(K&\u0011a\r\u000b\u0002\u0005\u0019>tw\r\u0006\u0002'Q\")q(\u0003a\u0001SB\u0011\u0011L[\u0005\u0003Wj\u0013q\"\u00168tS\u001etW\rZ%oi\u0016<WM\u001d\u000b\u0003M5DQa\u0010\u0006A\u0002\u0019\"\"AJ8\t\u000b}Z\u0001\u0019\u00019\u0011\u0005\u001d\n\u0018B\u0001:)\u0005\u0019!u.\u001e2mKR\u0011a\u0005\u001e\u0005\u0006\u007f1\u0001\r!\u001e\t\u0003OYL!a\u001e\u0015\u0003\u000b\u0019cw.\u0019;\u0002\u00171|gn\u001a#jm&\u001cxN]\u000b\u0002I\u0006\t\".\u0019<b\u0005&<\u0017J\u001c;ESZL7o\u001c:\u0016\u0003\u0001\u000bQBY5h\u0013:$H)\u001b<jg>\u0014X#\u0001@\u0011\u0007}\f\u0019!\u0004\u0002\u0002\u0002)\u00111\tK\u0005\u0004)\u0006\u0005\u0011aE;og&<g.\u001a3M_:<G)\u001b<jg>\u0014X#\u0001-\u0002%Ut7/[4oK\u0012Le\u000e\u001e#jm&\u001cxN]\u000b\u0002S\u000611\u000f[1eK\u0012T!!!\u0004\u000b\u0007a\tyAC\u0002\u001d\u0003#Q1aXA\n\u0015\ri\u0016Q\u0003\u0006\u0003\u0003\u001bQ1\u0001GA\r\u0015\ra\u00121\u0004\u0006\u0004?\u0006u!BAA\u0007\u0015\rA\u0012\u0011\u0005\u0006\u00049\u0005\r\u0002")
public class Mod64
extends FunctionExpr {
    private long longDivisor;
    private BigInteger javaBigIntDivisor;
    private BigInt bigIntDivisor;
    private UnsignedLong unsignedLongDivisor;
    private UnsignedInteger unsignedIntDivisor;
    private final int divisor;
    private volatile byte bitmap$0;

    public int applyToAny(Seq<Object> args) {
        Object object = args.apply(0);
        if (object instanceof BigInteger) {
            BigInteger bigInteger = (BigInteger)object;
            return this.apply(bigInteger);
        }
        if (object instanceof BigInt) {
            BigInt bigInt = (BigInt)object;
            return this.apply(bigInt);
        }
        if (object instanceof UnsignedLong) {
            UnsignedLong unsignedLong = (UnsignedLong)object;
            return this.apply(unsignedLong);
        }
        if (object instanceof Long) {
            long l = BoxesRunTime.unboxToLong((Object)object);
            return this.apply(l);
        }
        if (object instanceof UnsignedInteger) {
            UnsignedInteger unsignedInteger = (UnsignedInteger)object;
            return this.apply(unsignedInteger);
        }
        if (object instanceof Integer) {
            int n = BoxesRunTime.unboxToInt((Object)object);
            return this.apply(n);
        }
        if (object instanceof Double) {
            double d = BoxesRunTime.unboxToDouble((Object)object);
            return this.apply(d);
        }
        if (object instanceof Float) {
            float f = BoxesRunTime.unboxToFloat((Object)object);
            return this.apply(f);
        }
        if (object instanceof String) {
            String string = (String)object;
            return this.apply(string.hashCode());
        }
        throw new IllegalArgumentException(new StringBuilder(73).append("Unable to perform modulo on value '").append(object).append("' ").append("due to its class being unsupported: ").append(object.getClass().getName()).toString());
    }

    public int apply(BigInteger x) {
        return x.mod(this.javaBigIntDivisor()).intValue();
    }

    public int apply(BigInt x) {
        return x.mod(this.bigIntDivisor()).intValue();
    }

    public int apply(UnsignedLong x) {
        return x.mod(this.unsignedLongDivisor()).intValue();
    }

    public int apply(long x) {
        return (int)Math.floorMod(x, this.longDivisor());
    }

    public int apply(UnsignedInteger x) {
        return x.mod(this.unsignedIntDivisor()).intValue();
    }

    public int apply(int x) {
        return Math.floorMod(x, this.divisor);
    }

    public int apply(double x) {
        return this.apply((long)x);
    }

    public int apply(float x) {
        return this.apply((long)x);
    }

    private long longDivisor$lzycompute() {
        Mod64 mod64 = this;
        synchronized (mod64) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.longDivisor = this.divisor;
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.longDivisor;
    }

    private long longDivisor() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.longDivisor$lzycompute();
        }
        return this.longDivisor;
    }

    private BigInteger javaBigIntDivisor$lzycompute() {
        Mod64 mod64 = this;
        synchronized (mod64) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.javaBigIntDivisor = BigInteger.valueOf(this.divisor);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.javaBigIntDivisor;
    }

    private BigInteger javaBigIntDivisor() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.javaBigIntDivisor$lzycompute();
        }
        return this.javaBigIntDivisor;
    }

    private BigInt bigIntDivisor$lzycompute() {
        Mod64 mod64 = this;
        synchronized (mod64) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.bigIntDivisor = package$.MODULE$.BigInt().apply(this.divisor);
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.bigIntDivisor;
    }

    private BigInt bigIntDivisor() {
        if ((byte)(this.bitmap$0 & 4) == 0) {
            return this.bigIntDivisor$lzycompute();
        }
        return this.bigIntDivisor;
    }

    private UnsignedLong unsignedLongDivisor$lzycompute() {
        Mod64 mod64 = this;
        synchronized (mod64) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.unsignedLongDivisor = UnsignedLong.valueOf(this.divisor);
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.unsignedLongDivisor;
    }

    private UnsignedLong unsignedLongDivisor() {
        if ((byte)(this.bitmap$0 & 8) == 0) {
            return this.unsignedLongDivisor$lzycompute();
        }
        return this.unsignedLongDivisor;
    }

    private UnsignedInteger unsignedIntDivisor$lzycompute() {
        Mod64 mod64 = this;
        synchronized (mod64) {
            if ((byte)(this.bitmap$0 & 0x10) == 0) {
                this.unsignedIntDivisor = UnsignedInteger.valueOf(this.divisor);
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x10);
            }
        }
        return this.unsignedIntDivisor;
    }

    private UnsignedInteger unsignedIntDivisor() {
        if ((byte)(this.bitmap$0 & 0x10) == 0) {
            return this.unsignedIntDivisor$lzycompute();
        }
        return this.unsignedIntDivisor;
    }

    public Mod64(int divisor) {
        this.divisor = divisor;
        super("mod64", FunctionExpr$.MODULE$.$lessinit$greater$default$2());
    }
}

