/*
 * Decompiled with CFR 0.152.
 */
package com.bytedance.bytehouse.commons;

import com.bytedance.bytehouse.commons.DottedProgressPrintableUtils;
import com.bytedance.bytehouse.commons.DottedProgressPrintableUtils$NumberDotsPerLineBreak$;
import com.bytedance.bytehouse.commons.Using$;
import com.bytedance.bytehouse.commons.Using$Releasable$AutoCloseableIsReleasable$;
import com.bytedance.bytehouse.commons.atomic.Atomic$;
import com.bytedance.bytehouse.commons.atomic.AtomicLong;
import com.bytedance.bytehouse.commons.atomic.AtomicMagnet$;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.math.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong;
import scala.runtime.java8.JFunction0;

public final class DottedProgressPrintableUtils$ {
    public static DottedProgressPrintableUtils$ MODULE$;

    static {
        new DottedProgressPrintableUtils$();
    }

    public <R> void executeWithProgressPrinted(long numIterations, Function1<Object, R> f, int numIterationsPerPrintDot, int numDotsPerLineBreak) {
        int numIterationsPerLineBreak = numIterationsPerPrintDot * numDotsPerLineBreak;
        this.iterate$1(1L, numIterations, numIterationsPerPrintDot, f, numIterationsPerLineBreak);
    }

    public <R> int executeWithProgressPrinted$default$4(long numIterations, Function1<Object, R> f) {
        return DottedProgressPrintableUtils$NumberDotsPerLineBreak$.MODULE$.default();
    }

    public <T, R> void parallelExecuteWithProgressPrinted(long numIterations, int parallelism, boolean isSilent, Function0<DottedProgressPrintableUtils.BatchExecutable<T, R>> newExecutable, ExecutionContext execCtx, int numIterationsPerPrintDot, int numDotsPerLineBreak) {
        Predef$.MODULE$.require(parallelism > 0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(39).append("Parallelism must be positive: [Actual] ").append(parallelism).toString());
        int numIterationsPerLineBreak = numIterationsPerPrintDot * numDotsPerLineBreak;
        AtomicLong watermark = Atomic$.MODULE$.apply(AtomicMagnet$.MODULE$.AtomicLongMagnet(1L));
        AtomicLong numCompleted = Atomic$.MODULE$.apply(AtomicMagnet$.MODULE$.AtomicLongMagnet(0L));
        ((IterableLike)Seq$.MODULE$.tabulate(parallelism, (Function1 & Serializable & scala.Serializable)i -> this.concurrentTask$1(BoxesRunTime.unboxToInt((Object)i), newExecutable, watermark, numIterationsPerPrintDot, numIterations, isSilent, parallelism, execCtx, numCompleted, numIterationsPerLineBreak))).foreach((Function1 & Serializable & scala.Serializable)x$1 -> (Future)Await$.MODULE$.ready((Awaitable)x$1, (Duration)Duration$.MODULE$.Inf()));
        if (!isSilent && numIterations % (long)numIterationsPerPrintDot != 0L) {
            Predef$.MODULE$.print((Object)" .");
        }
        if (!isSilent && numIterations % (long)numIterationsPerLineBreak != 0L) {
            Predef$.MODULE$.println((Object)this.markDanglingEnd(numIterations));
            return;
        }
    }

    public <T, R> boolean parallelExecuteWithProgressPrinted$default$3() {
        return false;
    }

    public <T, R> int parallelExecuteWithProgressPrinted$default$7(long numIterations, int parallelism, boolean isSilent, Function0<DottedProgressPrintableUtils.BatchExecutable<T, R>> newExecutable) {
        return DottedProgressPrintableUtils$NumberDotsPerLineBreak$.MODULE$.default();
    }

    private String markLineBreak(long count, long total) {
        return new StringBuilder(1).append("\t").append(this.markProgress(count, total)).toString();
    }

    private String markDanglingEnd(long count) {
        return new StringBuilder(1).append(" ").append(this.markProgress(count, count)).toString();
    }

    private String markProgress(long count, long total) {
        double arg$macro$1 = 100.0 / (double)total * (double)count;
        long arg$macro$2 = count;
        return new StringOps("%5.01f%% | %,d").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)arg$macro$1), BoxesRunTime.boxToLong((long)arg$macro$2)}));
    }

    private final void iterate$1(long begin, long numIterations$1, int numIterationsPerPrintDot$1, Function1 f$1, int numIterationsPerLineBreak$1) {
        while (begin <= numIterations$1) {
            long end = package$.MODULE$.min(begin + (long)numIterationsPerPrintDot$1 - 1L, numIterations$1);
            new RichLong(Predef$.MODULE$.longWrapper(begin)).to((Object)BoxesRunTime.boxToLong((long)end)).foreach(f$1);
            Some suffix = end % (long)numIterationsPerLineBreak$1 == 0L ? new Some((Object)new StringBuilder(1).append(this.markLineBreak(end, numIterations$1)).append("\n").toString()) : (end == numIterations$1 ? new Some((Object)new StringBuilder(1).append(this.markDanglingEnd(end)).append("\n").toString()) : None$.MODULE$);
            Predef$.MODULE$.print((Object)new StringBuilder(2).append(" .").append(suffix.getOrElse((Function0 & Serializable & scala.Serializable)() -> "")).toString());
            begin = end + 1L;
        }
    }

    private final void printDot$1(long batchSize, int numIterationsPerPrintDot$2, AtomicLong numCompleted$1, int numIterationsPerLineBreak$2, long numIterations$2) {
        if (batchSize == (long)numIterationsPerPrintDot$2) {
            AtomicLong atomicLong = numCompleted$1;
            synchronized (atomicLong) {
                long x = numCompleted$1.addAndGet(batchSize);
                None$ suffix = x % (long)numIterationsPerLineBreak$2 == 0L ? new Some((Object)new StringBuilder(1).append(this.markLineBreak(x, numIterations$2)).append("\n").toString()) : None$.MODULE$;
                Predef$.MODULE$.print((Object)new StringBuilder(2).append(" .").append(suffix.getOrElse((Function0 & Serializable & scala.Serializable)() -> "")).toString());
            }
            return;
        }
    }

    private final void iterate$2(AtomicLong watermark$1, int numIterationsPerPrintDot$2, long numIterations$2, DottedProgressPrintableUtils.BatchExecutable exec$1, boolean isSilent$1, AtomicLong numCompleted$1, int numIterationsPerLineBreak$2) {
        long begin;
        while ((begin = watermark$1.getAndAdd(numIterationsPerPrintDot$2)) <= numIterations$2) {
            long end = package$.MODULE$.min(begin + (long)numIterationsPerPrintDot$2 - 1L, numIterations$2);
            exec$1.beforeEachBatch(begin, end);
            exec$1.executeBatch(begin, end);
            exec$1.afterEachBatch(begin, end);
            if (isSilent$1) continue;
            this.printDot$1(end - begin + 1L, numIterationsPerPrintDot$2, numCompleted$1, numIterationsPerLineBreak$2, numIterations$2);
        }
    }

    public static final /* synthetic */ void $anonfun$parallelExecuteWithProgressPrinted$4(DottedProgressPrintableUtils$ $this, AtomicLong watermark$1, int numIterationsPerPrintDot$2, long numIterations$2, boolean isSilent$1, int i$1, int parallelism$1, AtomicLong numCompleted$1, int numIterationsPerLineBreak$2, DottedProgressPrintableUtils.BatchExecutable exec) {
        exec.open(i$1, parallelism$1);
        exec.beforeAllBatches();
        $this.iterate$2(watermark$1, numIterationsPerPrintDot$2, numIterations$2, exec, isSilent$1, numCompleted$1, numIterationsPerLineBreak$2);
        exec.afterAllBatches();
    }

    private final Future concurrentTask$1(int i, Function0 newExecutable$1, AtomicLong watermark$1, int numIterationsPerPrintDot$2, long numIterations$2, boolean isSilent$1, int parallelism$1, ExecutionContext execCtx$1, AtomicLong numCompleted$1, int numIterationsPerLineBreak$2) {
        return Future$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> Using$.MODULE$.resource(newExecutable$1.apply(), (Function1 & Serializable & scala.Serializable)exec -> {
            DottedProgressPrintableUtils$.$anonfun$parallelExecuteWithProgressPrinted$4(this, watermark$1, numIterationsPerPrintDot$2, numIterations$2, isSilent$1, i, parallelism$1, numCompleted$1, numIterationsPerLineBreak$2, exec);
            return BoxedUnit.UNIT;
        }, Using$Releasable$AutoCloseableIsReleasable$.MODULE$), execCtx$1);
    }

    private DottedProgressPrintableUtils$() {
        MODULE$ = this;
    }
}

