/*
 * Decompiled with CFR 0.152.
 */
package com.bytedance.bytehouse.commons;

import com.bytedance.bytehouse.commons.ExponentialBackoff$;
import com.bytedance.bytehouse.commons.atomic.Atomic$;
import com.bytedance.bytehouse.commons.atomic.AtomicInt;
import com.bytedance.bytehouse.commons.atomic.AtomicMagnet$;
import com.bytedance.bytehouse.commons.package$;
import com.bytedance.bytehouse.commons.package$RandomOps$;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Random;
import scala.util.Random$;

@ScalaSignature(bytes="\u0006\u0001\u0005ua\u0001\u0002\u000f\u001e\u0005\u0019B\u0001\u0002\r\u0001\u0003\u0002\u0003\u0006I!\r\u0005\ts\u0001\u0011\t\u0011)A\u0005c!A!\b\u0001B\u0001B\u0003%\u0011\u0007C\u0003<\u0001\u0011\u0005A\bC\u0003<\u0001\u0011\u0005!\tC\u0004F\u0001\t\u0007I\u0011\u0002$\t\r)\u0003\u0001\u0015!\u0003H\u0011\u001dY\u0005A1A\u0005\n\u0019Ca\u0001\u0014\u0001!\u0002\u00139\u0005bB'\u0001\u0005\u0004%IA\u0014\u0005\u0007%\u0002\u0001\u000b\u0011B(\t\u000fM\u0003!\u0019!C\u0005)\"11\f\u0001Q\u0001\nUCq\u0001\u0018\u0001A\u0002\u0013%Q\fC\u0004b\u0001\u0001\u0007I\u0011\u00022\t\r!\u0004\u0001\u0015)\u0003_\u0011\u0015I\u0007\u0001\"\u0001k\u0011\u0015Y\u0007\u0001\"\u0001m\u0011\u0015i\u0007\u0001\"\u0001m\u0011\u0015q\u0007\u0001\"\u0003p\u0011\u0015)\b\u0001\"\u0001w\u0011\u0015Q\b\u0001\"\u0001|\u000f\u0015aX\u0004#\u0001~\r\u0015aR\u0004#\u0001\u007f\u0011\u0015Y\u0004\u0004\"\u0001\u0000\u0011\u001d\t\t\u0001\u0007C\u0001\u0003\u0007A\u0011\"!\u0003\u0019\u0003\u0003%I!a\u0003\u0003%\u0015C\bo\u001c8f]RL\u0017\r\u001c\"bG.|gM\u001a\u0006\u0003=}\tqaY8n[>t7O\u0003\u0002!C\u0005I!-\u001f;fQ>,8/\u001a\u0006\u0003E\r\n\u0011BY=uK\u0012\fgnY3\u000b\u0003\u0011\n1aY8n\u0007\u0001\u00192\u0001A\u0014.!\tA3&D\u0001*\u0015\u0005Q\u0013!B:dC2\f\u0017B\u0001\u0017*\u0005\u0019\te.\u001f*fMB\u0011\u0001FL\u0005\u0003_%\u0012AbU3sS\u0006d\u0017N_1cY\u0016\fA!\u001b8jiB\u0011!gN\u0007\u0002g)\u0011A'N\u0001\tIV\u0014\u0018\r^5p]*\u0011a'K\u0001\u000bG>t7-\u001e:sK:$\u0018B\u0001\u001d4\u0005!!UO]1uS>t\u0017aA7bq\u0006\u0001\".\u001b;uKJ,\u0006\u000f]3s\u0005>,h\u000eZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\tuz\u0004)\u0011\t\u0003}\u0001i\u0011!\b\u0005\u0006a\u0011\u0001\r!\r\u0005\u0006s\u0011\u0001\r!\r\u0005\u0006u\u0011\u0001\r!\r\u000b\u0004{\r#\u0005\"\u0002\u0019\u0006\u0001\u0004\t\u0004\"B\u001d\u0006\u0001\u0004\t\u0014AB5oSRl5/F\u0001H!\tA\u0003*\u0003\u0002JS\t!Aj\u001c8h\u0003\u001dIg.\u001b;Ng\u0002\nQ!\\1y\u001bN\fa!\\1y\u001bN\u0004\u0013aC4fi*KG\u000f^3s\u001bN,\u0012a\u0014\t\u0004QA;\u0015BA)*\u0005%1UO\\2uS>t\u0007'\u0001\u0007hKRT\u0015\u000e\u001e;fe6\u001b\b%A\bj]Z|7-\u0019;j_:\u001cu.\u001e8u+\u0005)\u0006C\u0001,Z\u001b\u00059&B\u0001-\u001e\u0003\u0019\tGo\\7jG&\u0011!l\u0016\u0002\n\u0003R|W.[2J]R\f\u0001#\u001b8w_\u000e\fG/[8o\u0007>,h\u000e\u001e\u0011\u0002\u0017%\u001cX*\u0019=j[&TX\rZ\u000b\u0002=B\u0011\u0001fX\u0005\u0003A&\u0012qAQ8pY\u0016\fg.A\bjg6\u000b\u00070[7ju\u0016$w\fJ3r)\t\u0019g\r\u0005\u0002)I&\u0011Q-\u000b\u0002\u0005+:LG\u000fC\u0004h\u001f\u0005\u0005\t\u0019\u00010\u0002\u0007a$\u0013'\u0001\u0007jg6\u000b\u00070[7ju\u0016$\u0007%A\u0003sKN,G\u000fF\u0001d\u0003a\u0001X-Z6OKb$\u0018\t\u001d9s_bLW.\u0019;f\u001b&dGn\u001d\u000b\u0002\u000f\u0006Qa.\u001a=u\u001b&dG.[:\u0002!\u001d,GOQ1dW>4g-T5mY&\u001cHCA$q\u0011\u0015\tH\u00031\u0001s\u0003!)\u0007\u0010]8oK:$\bC\u0001\u0015t\u0013\t!\u0018FA\u0002J]R\f1\u0004]3fW:+\u0007\u0010^!qaJ|\u00070[7bi\u0016$UO]1uS>tW#A<\u0011\u0005IB\u0018BA=4\u000591\u0015N\\5uK\u0012+(/\u0019;j_:\fAB\\3yi\u0012+(/\u0019;j_:$\u0012a^\u0001\u0013\u000bb\u0004xN\\3oi&\fGNQ1dW>4g\r\u0005\u0002?1M\u0019\u0001dJ\u0017\u0015\u0003u\fq\u0001\u001d:fG&\u001cX\rF\u0003>\u0003\u000b\t9\u0001C\u000315\u0001\u0007\u0011\u0007C\u0003:5\u0001\u0007\u0011'A\u0006sK\u0006$'+Z:pYZ,GCAA\u0007!\u0011\ty!!\u0007\u000e\u0005\u0005E!\u0002BA\n\u0003+\tA\u0001\\1oO*\u0011\u0011qC\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002\u001c\u0005E!AB(cU\u0016\u001cG\u000f")
public final class ExponentialBackoff
implements Serializable {
    private final Duration init;
    private final Duration max;
    private final Duration jitterUpperBound;
    private final long initMs;
    private final long maxMs;
    private final Function0<Object> getJitterMs;
    private final AtomicInt invocationCount;
    private boolean isMaximized;

    public static ExponentialBackoff precise(Duration duration, Duration duration2) {
        return ExponentialBackoff$.MODULE$.precise(duration, duration2);
    }

    private long initMs() {
        return this.initMs;
    }

    private long maxMs() {
        return this.maxMs;
    }

    private Function0<Object> getJitterMs() {
        return this.getJitterMs;
    }

    private AtomicInt invocationCount() {
        return this.invocationCount;
    }

    private boolean isMaximized() {
        return this.isMaximized;
    }

    private void isMaximized_$eq(boolean x$1) {
        this.isMaximized = x$1;
    }

    public void reset() {
        this.invocationCount().$colon$eq(BoxesRunTime.boxToInteger((int)0));
        this.isMaximized_$eq(this.initMs() >= this.maxMs());
    }

    public long peekNextApproximateMills() {
        return this.getBackoffMillis(BoxesRunTime.unboxToInt(this.invocationCount().apply()));
    }

    public long nextMillis() {
        return this.getBackoffMillis(this.invocationCount().getAndIncrement());
    }

    private long getBackoffMillis(int exponent) {
        if (this.isMaximized()) {
            return this.maxMs();
        }
        long millis = (this.initMs() << exponent) + this.getJitterMs().apply$mcJ$sp();
        if (millis < this.maxMs()) {
            return millis;
        }
        this.isMaximized_$eq(true);
        return this.maxMs();
    }

    public FiniteDuration peekNextApproximateDuration() {
        return new package.DurationLong(scala.concurrent.duration.package$.MODULE$.DurationLong(this.peekNextApproximateMills())).millis();
    }

    public FiniteDuration nextDuration() {
        return new package.DurationLong(scala.concurrent.duration.package$.MODULE$.DurationLong(this.nextMillis())).millis();
    }

    public ExponentialBackoff(Duration init, Duration max, Duration jitterUpperBound) {
        this.init = init;
        this.max = max;
        this.jitterUpperBound = jitterUpperBound;
        Predef$.MODULE$.require(init.isFinite(), (Function0 & java.io.Serializable & Serializable)() -> "Infinite initial value for exponential backoff is not allowed");
        this.initMs = init.toMillis();
        Predef$.MODULE$.require(this.initMs() > 0L, (Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(47).append("Invalid initial value for exponential backoff: ").append($this.init).toString());
        Predef$.MODULE$.require(max.isFinite(), (Function0 & java.io.Serializable & Serializable)() -> "Infinite maximum value for exponential backoff is not allowed");
        this.maxMs = max.toMillis();
        Predef$.MODULE$.require(this.maxMs() > 0L, (Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(47).append("Invalid maximum value for exponential backoff: ").append($this.max).toString());
        Predef$.MODULE$.require(jitterUpperBound.isFinite(), (Function0 & java.io.Serializable & Serializable)() -> "Infinite jitter upper bound for exponential backoff is not allowed");
        long jitterUpperBoundMs = jitterUpperBound.toMillis();
        Predef$.MODULE$.require(jitterUpperBoundMs >= 0L, (Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(52).append("Invalid jitter upper bound for exponential backoff: ").append($this.jitterUpperBound).toString());
        this.getJitterMs = jitterUpperBoundMs > 0L ? (JFunction0.mcJ.sp & java.io.Serializable & Serializable)() -> package$RandomOps$.MODULE$.nextLong$extension(package$.MODULE$.RandomOps((Random)Random$.MODULE$), jitterUpperBoundMs) : (JFunction0.mcJ.sp & java.io.Serializable & Serializable)() -> 0L;
        this.invocationCount = Atomic$.MODULE$.apply(AtomicMagnet$.MODULE$.AtomicIntMagnet(0));
        this.isMaximized = this.initMs() >= this.maxMs();
    }

    public ExponentialBackoff(Duration init, Duration max) {
        this(init, max, init.$times(0.75));
    }
}

