/*
 * Decompiled with CFR 0.152.
 */
package com.bytedance.bytehouse.commons;

import com.bytedance.bytehouse.commons.ChainingOps$;
import com.bytedance.bytehouse.commons.TimeUtils$;
import com.bytedance.bytehouse.commons.atomic.Atomic$;
import com.bytedance.bytehouse.commons.atomic.AtomicLong;
import com.bytedance.bytehouse.commons.atomic.AtomicMagnet$;
import java.io.Serializable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Traversable;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.concurrent.duration.Duration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005=c!\u0002\f\u0018\u0003\u0003\u0001\u0003\u0002\u0003\u0015\u0001\u0005\u0003\u0005\u000b\u0011B\u0015\t\u000bE\u0002A\u0011\u0001\u001a\t\u0011\u0011\u0003\u0001R1A\u0005\n\u0015CQA\u0016\u0001\u0007\u0012]Cqa\u001a\u0001C\u0002\u0013%\u0001\u000e\u0003\u0004r\u0001\u0001\u0006I!\u001b\u0005\be\u0002\u0011\r\u0011\"\u0003t\u0011\u0019Q\b\u0001)A\u0005i\"91\u0010\u0001b\u0001\n\u0013a\bbBA\u0001\u0001\u0001\u0006I! \u0005\t\u0003\u0007\u0001\u0001\u0019!C\u0005y\"I\u0011Q\u0001\u0001A\u0002\u0013%\u0011q\u0001\u0005\b\u0003'\u0001\u0001\u0015)\u0003~\u0011!\t)\u0002\u0001a\u0001\n\u0013a\b\"CA\f\u0001\u0001\u0007I\u0011BA\r\u0011\u001d\ti\u0002\u0001Q!\nuDq!a\b\u0001\t\u000b\t\t\u0003C\u0004\u0002<\u0001!)!!\u0010\t\u000f\u0005\u001d\u0003\u0001\"\u0003\u0002J!9\u00111\n\u0001\u0005\n\u0005%\u0003bBA'\u0001\u0011%\u0011\u0011\n\u0002\u0013'&l\u0007\u000f\\3Ui24U\u000f\u001c7DC\u000eDWM\u0003\u0002\u00193\u000591m\\7n_:\u001c(B\u0001\u000e\u001c\u0003%\u0011\u0017\u0010^3i_V\u001cXM\u0003\u0002\u001d;\u0005I!-\u001f;fI\u0006t7-\u001a\u0006\u0002=\u0005\u00191m\\7\u0004\u0001U\u0019\u0011eN!\u0014\u0005\u0001\u0011\u0003CA\u0012'\u001b\u0005!#\"A\u0013\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u001d\"#AB!osJ+g-A\u0002ui2\u0004\"AK\u0018\u000e\u0003-R!\u0001L\u0017\u0002\u0011\u0011,(/\u0019;j_:T!A\f\u0013\u0002\u0015\r|gnY;se\u0016tG/\u0003\u00021W\tAA)\u001e:bi&|g.\u0001\u0004=S:LGO\u0010\u000b\u0003g\r\u0003B\u0001\u000e\u00016\u00016\tq\u0003\u0005\u00027o1\u0001A!\u0002\u001d\u0001\u0005\u0004I$!A&\u0012\u0005ij\u0004CA\u0012<\u0013\taDEA\u0004O_RD\u0017N\\4\u0011\u0005\rr\u0014BA %\u0005\r\te.\u001f\t\u0003m\u0005#QA\u0011\u0001C\u0002e\u0012\u0011A\u0016\u0005\u0006Q\t\u0001\r!K\u0001\u0004Y><W#\u0001$\u0011\u0005\u001d\u0003V\"\u0001%\u000b\u0005%S\u0015!\u00027pORR'BA&M\u0003\u001dawnZ4j]\u001eT!!\u0014(\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005y\u0015aA8sO&\u0011\u0011\u000b\u0013\u0002\u0007\u0019><w-\u001a:)\u0005\r\u0019\u0006CA\u0012U\u0013\t)FEA\u0005ue\u0006t7/[3oi\u00069An\\1e\u00032dG#\u0001-\u0011\u0007e\u000bGM\u0004\u0002[?:\u00111LX\u0007\u00029*\u0011QlH\u0001\u0007yI|w\u000e\u001e \n\u0003\u0015J!\u0001\u0019\u0013\u0002\u000fA\f7m[1hK&\u0011!m\u0019\u0002\f)J\fg/\u001a:tC\ndWM\u0003\u0002aIA!1%Z\u001bA\u0013\t1GE\u0001\u0004UkBdWMM\u0001\u0006G\u0006\u001c\u0007.Z\u000b\u0002SB!!n\\\u001bA\u001b\u0005Y'B\u00017n\u0003\u001diW\u000f^1cY\u0016T!A\u001c\u0013\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002qW\n9\u0001*Y:i\u001b\u0006\u0004\u0018AB2bG\",\u0007%\u0001\noKb$Hj\\1e)&lW-T5mY&\u001cX#\u0001;\u0011\u0005UDX\"\u0001<\u000b\u0005]<\u0012AB1u_6L7-\u0003\u0002zm\nQ\u0011\t^8nS\u000eduN\\4\u0002'9,\u0007\u0010\u001e'pC\u0012$\u0016.\\3NS2d\u0017n\u001d\u0011\u0002\u000bQ$H.T:\u0016\u0003u\u0004\"a\t@\n\u0005}$#\u0001\u0002'p]\u001e\fa\u0001\u001e;m\u001bN\u0004\u0013\u0001D2pk:$\u0018+^3sS\u0016\u001c\u0018\u0001E2pk:$\u0018+^3sS\u0016\u001cx\fJ3r)\u0011\tI!a\u0004\u0011\u0007\r\nY!C\u0002\u0002\u000e\u0011\u0012A!\u00168ji\"A\u0011\u0011\u0003\u0007\u0002\u0002\u0003\u0007Q0A\u0002yIE\nQbY8v]R\fV/\u001a:jKN\u0004\u0013!C2pk:$\b*\u001b;t\u00035\u0019w.\u001e8u\u0011&$8o\u0018\u0013fcR!\u0011\u0011BA\u000e\u0011!\t\tbDA\u0001\u0002\u0004i\u0018AC2pk:$\b*\u001b;tA\u0005Iq-\u001a;Pe\u0016c7/Z\u000b\u0005\u0003G\t9\u0003\u0006\u0004\u0002&\u00055\u0012\u0011\u0007\t\u0004m\u0005\u001dBaBA\u0015#\t\u0007\u00111\u0006\u0002\u0003-F\n\"\u0001Q\u001f\t\r\u0005=\u0012\u00031\u00016\u0003\rYW-\u001f\u0005\t\u0003g\tB\u00111\u0001\u00026\u00059A-\u001a4bk2$\b#B\u0012\u00028\u0005\u0015\u0012bAA\u001dI\tAAHY=oC6,g(A\u0002hKR$B!a\u0010\u0002FA!1%!\u0011A\u0013\r\t\u0019\u0005\n\u0002\u0007\u001fB$\u0018n\u001c8\t\r\u0005=\"\u00031\u00016\u00035\tG\u000f^3naR\u0014V\r\\8bIR\u0011\u0011\u0011B\u0001\u0007e\u0016dw.\u00193\u0002\u00151|w\rS5u%\u0006$X\r")
public abstract class SimpleTtlFullCache<K, V> {
    private transient Logger log;
    private final HashMap<K, V> cache = HashMap$.MODULE$.empty();
    private final AtomicLong nextLoadTimeMillis = Atomic$.MODULE$.apply(AtomicMagnet$.MODULE$.AtomicLongMagnet(-1L));
    private final long ttlMs;
    private long countQueries;
    private long countHits;
    private volatile transient boolean bitmap$trans$0;

    private Logger log$lzycompute() {
        SimpleTtlFullCache simpleTtlFullCache = this;
        synchronized (simpleTtlFullCache) {
            if (!this.bitmap$trans$0) {
                this.log = LogManager.getLogger(this.getClass());
                this.bitmap$trans$0 = true;
            }
        }
        return this.log;
    }

    private Logger log() {
        if (!this.bitmap$trans$0) {
            return this.log$lzycompute();
        }
        return this.log;
    }

    public abstract Traversable<Tuple2<K, V>> loadAll();

    private HashMap<K, V> cache() {
        return this.cache;
    }

    private AtomicLong nextLoadTimeMillis() {
        return this.nextLoadTimeMillis;
    }

    private long ttlMs() {
        return this.ttlMs;
    }

    private long countQueries() {
        return this.countQueries;
    }

    private void countQueries_$eq(long x$1) {
        this.countQueries = x$1;
    }

    private long countHits() {
        return this.countHits;
    }

    private void countHits_$eq(long x$1) {
        this.countHits = x$1;
    }

    public final <V1> V1 getOrElse(K key, Function0<V1> function0) {
        return (V1)this.get(key).getOrElse(function0);
    }

    public final Option<V> get(K key) {
        this.attemptReload();
        this.countQueries_$eq(this.countQueries() + 1L);
        return ChainingOps$.MODULE$.tap$extension(ChainingOps$.MODULE$.scalaUtilChainingOps(this.cache().get(key)), (Function1 & Serializable & scala.Serializable)resultOpt -> {
            SimpleTtlFullCache.$anonfun$get$1(this, resultOpt);
            return BoxedUnit.UNIT;
        });
    }

    private void attemptReload() {
        if (BoxesRunTime.unboxToLong(this.nextLoadTimeMillis().apply()) <= System.currentTimeMillis()) {
            HashMap<K, V> hashMap = this.cache();
            synchronized (hashMap) {
                this.logHitRate();
                long startAt = System.currentTimeMillis();
                if (BoxesRunTime.unboxToLong(this.nextLoadTimeMillis().apply()) <= startAt) {
                    this.reload();
                    long reloadedAt = System.currentTimeMillis();
                    this.log().info(new StringBuilder(36).append("(Re-)Loaded ").append(this.cache().size()).append(" entities into cache in ").append(TimeUtils$.MODULE$.formatMillis(reloadedAt - startAt, TimeUtils$.MODULE$.formatMillis$default$2())).toString());
                    this.nextLoadTimeMillis().$colon$eq(BoxesRunTime.boxToLong((long)(reloadedAt + this.ttlMs())));
                    this.countQueries_$eq(0L);
                    this.countHits_$eq(0L);
                }
            }
            return;
        }
    }

    private void reload() {
        this.cache().clear();
        this.cache().$plus$plus$eq(this.loadAll());
    }

    private void logHitRate() {
        if (this.countQueries() > 0L) {
            double hitRate = (double)this.countHits() / (double)this.countQueries();
            double arg$macro$1 = hitRate * (double)100;
            this.log().info(new StringOps("Hit rate of TTL full-cache: %.2f%%").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)arg$macro$1)})));
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$get$1(SimpleTtlFullCache $this, Option resultOpt) {
        if (resultOpt.isDefined()) {
            $this.countHits_$eq($this.countHits() + 1L);
            return;
        }
    }

    public SimpleTtlFullCache(Duration ttl) {
        this.ttlMs = ttl.toMillis();
        this.countQueries = 0L;
        this.countHits = 0L;
    }
}

