/*
 * Decompiled with CFR 0.152.
 */
package com.bytedance.bytehouse.commons;

import com.bytedance.bytehouse.clickhouse.ClickHouseConstants$;
import com.bytedance.bytehouse.commons.SpacedGeneralTimeUnitNames$;
import com.bytedance.bytehouse.commons.TimeUnitNamesLike;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.concurrent.TimeUnit;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.concurrent.duration.Duration;
import scala.runtime.BoxesRunTime;

public final class TimeUtils$ {
    public static TimeUtils$ MODULE$;

    static {
        new TimeUtils$();
    }

    public void sleep(Duration duration) {
        TimeUnit.MILLISECONDS.sleep(duration.toMillis());
    }

    public String formatMillis(long millis, TimeUnitNamesLike unitNames) {
        if (millis < 1000L) {
            return new StringBuilder(0).append(millis).append(unitNames.milliseconds()).toString();
        }
        if (millis < 60000L) {
            double arg$macro$1 = (double)millis / 1000.0;
            String arg$macro$2 = unitNames.seconds();
            return new StringOps("%.3f%s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)arg$macro$1), arg$macro$2}));
        }
        if (millis < 3600000L) {
            double arg$macro$3 = (double)millis / 60000.0;
            String arg$macro$4 = unitNames.minutes();
            return new StringOps("%.1f%s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)arg$macro$3), arg$macro$4}));
        }
        if (millis < 86400000L) {
            double arg$macro$5 = (double)millis / 3600000.0;
            String arg$macro$6 = unitNames.hours();
            return new StringOps("%.2f%s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)arg$macro$5), arg$macro$6}));
        }
        double arg$macro$7 = (double)millis / 8.64E7;
        String arg$macro$8 = unitNames.days();
        return new StringOps("%.3f%s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)arg$macro$7), arg$macro$8}));
    }

    public TimeUnitNamesLike formatMillis$default$2() {
        return SpacedGeneralTimeUnitNames$.MODULE$;
    }

    public LocalDateTime convertEpochMillisToLocalDateTime(long epochMillis, ZoneId zoneId) {
        return Instant.ofEpochMilli(epochMillis).atZone(zoneId).toLocalDateTime();
    }

    public String convertEpochMillisToDateTimeString(long epochMillis, ZoneId zoneId, DateTimeFormatter formatter) {
        return this.convertEpochMillisToLocalDateTime(epochMillis, zoneId).format(formatter);
    }

    public Timestamp clampToClickHouseBounds(Timestamp ts) {
        Timestamp timestamp = ts;
        if (ts.before(ClickHouseConstants$.MODULE$.DateTime64MinTimestamp())) {
            return ClickHouseConstants$.MODULE$.DateTime64MinTimestamp();
        }
        if (ts.after(ClickHouseConstants$.MODULE$.DateTime64MaxTimestamp())) {
            return ClickHouseConstants$.MODULE$.DateTime64MaxTimestamp();
        }
        return ts;
    }

    public Instant clampToClickHouseBounds(Instant instant) {
        Instant instant2 = instant;
        if (instant.isBefore(ClickHouseConstants$.MODULE$.DateTime64MinInstant())) {
            return ClickHouseConstants$.MODULE$.DateTime64MinInstant();
        }
        if (instant.isAfter(ClickHouseConstants$.MODULE$.DateTime64MaxInstant())) {
            return ClickHouseConstants$.MODULE$.DateTime64MaxInstant();
        }
        return instant;
    }

    private TimeUtils$() {
        MODULE$ = this;
    }
}

