/*
 * Decompiled with CFR 0.152.
 */
package com.bytedance.bytehouse.flink.connector.clickhouse;

import com.bytedance.bytehouse.commons.ChainingOps$;
import com.bytedance.bytehouse.commons.Implicits$;
import com.bytedance.bytehouse.commons.Implicits$TryOps$;
import com.bytedance.bytehouse.commons.RetryUtils;
import com.bytedance.bytehouse.commons.RetryUtils$;
import com.bytedance.bytehouse.flink.connector.clickhouse.ClickHouseAsyncLookupReaderLike;
import com.bytedance.bytehouse.flink.connector.clickhouse.metrics.AbstractClickHouseLookupMetrics;
import com.bytedance.bytehouse.flink.connector.jdbc.JdbcRowDataLookupOperationHandler;
import java.io.Serializable;
import java.util.Collection;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.flink.table.data.RowData;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.collection.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import shaded.bytehouse.com.google.common.base.Stopwatch;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001dc\u0001B\u0006\r\u0005eA\u0001B\n\u0001\u0003\u0002\u0003\u0006Ia\n\u0005\t\u007f\u0001\u0011\t\u0011)A\u0006\u0001\"Aa\t\u0001B\u0001B\u0003-q\t\u0003\u0005P\u0001\t\u0005\t\u0015a\u0003Q\u0011!\t\u0007A!A!\u0002\u0017\u0011\u0007\"B3\u0001\t\u00031\u0007\u0002\u00038\u0001\u0011\u000b\u0007I\u0011B8\t\u0015\u0005\u0005\u0001\u0001#b\u0001\n\u0013\t\u0019\u0001C\u0004\u0002\u0016\u0001!\t%a\u0006\t\u000f\u0005u\u0002\u0001\"\u0011\u0002@\tY2\t\\5dW\"{Wo]3Bgft7\rT8pWV\u0004(+Z1eKJT!!\u0004\b\u0002\u0015\rd\u0017nY6i_V\u001cXM\u0003\u0002\u0010!\u0005I1m\u001c8oK\u000e$xN\u001d\u0006\u0003#I\tQA\u001a7j].T!a\u0005\u000b\u0002\u0013\tLH/\u001a5pkN,'BA\u000b\u0017\u0003%\u0011\u0017\u0010^3eC:\u001cWMC\u0001\u0018\u0003\r\u0019w.\\\u0002\u0001'\r\u0001!D\t\t\u00037\u0001j\u0011\u0001\b\u0006\u0003;y\tA\u0001\\1oO*\tq$\u0001\u0003kCZ\f\u0017BA\u0011\u001d\u0005\u0019y%M[3diB\u00111\u0005J\u0007\u0002\u0019%\u0011Q\u0005\u0004\u0002 \u00072L7m\u001b%pkN,\u0017i]=oG2{wn[;q%\u0016\fG-\u001a:MS.,\u0017!\u00058fo2{wn[;q\u0011\u0006tG\r\\3sgB\u0019\u0001fK\u0017\u000e\u0003%R\u0011AK\u0001\u0006g\u000e\fG.Y\u0005\u0003Y%\u0012\u0011BR;oGRLwN\u001c\u0019\u0011\u000792\u0014H\u0004\u00020i9\u0011\u0001gM\u0007\u0002c)\u0011!\u0007G\u0001\u0007yI|w\u000e\u001e \n\u0003)J!!N\u0015\u0002\u000fA\f7m[1hK&\u0011q\u0007\u000f\u0002\u0004'\u0016\f(BA\u001b*!\tQT(D\u0001<\u0015\tad\"\u0001\u0003kI\n\u001c\u0017B\u0001 <\u0005\u0005REMY2S_^$\u0015\r^1M_>\\W\u000f](qKJ\fG/[8o\u0011\u0006tG\r\\3s\u0003\t)7\r\u0005\u0002B\t6\t!I\u0003\u0002DS\u0005Q1m\u001c8dkJ\u0014XM\u001c;\n\u0005\u0015\u0013%\u0001E#yK\u000e,H/[8o\u0007>tG/\u001a=u\u0003\u001diW\r\u001e:jGN\u00042\u0001\u000b%K\u0013\tI\u0015F\u0001\u0004PaRLwN\u001c\t\u0003\u00176k\u0011\u0001\u0014\u0006\u0003\r2I!A\u0014'\u0003?\u0005\u00137\u000f\u001e:bGR\u001cE.[2l\u0011>,8/\u001a'p_.,\b/T3ue&\u001c7/\u0001\u0006sKR\u0014\u0018\u0010R3mCf\u0004\"!\u00150\u000f\u0005I[fBA*Z\u001d\t!\u0006L\u0004\u0002V/:\u0011\u0001GV\u0005\u0002/%\u0011QCF\u0005\u0003'QI!A\u0017\n\u0002\u000f\r|W.\\8og&\u0011A,X\u0001\u000b%\u0016$(/_+uS2\u001c(B\u0001.\u0013\u0013\ty\u0006MA\u0005EK2\f\u0017\u0010T5lK*\u0011A,X\u0001\u000ee\u0016$(/_!ui\u0016l\u0007\u000f^:\u0011\u0005E\u001b\u0017B\u00013a\u000551\u0015N\\5uK\u0006#H/Z7qi\u00061A(\u001b8jiz\"\"aZ7\u0015\u000b!L'n\u001b7\u0011\u0005\r\u0002\u0001\"B \u0007\u0001\b\u0001\u0005\"\u0002$\u0007\u0001\b9\u0005\"B(\u0007\u0001\b\u0001\u0006\"B1\u0007\u0001\b\u0011\u0007\"\u0002\u0014\u0007\u0001\u00049\u0013a\u00017pOV\t\u0001\u000f\u0005\u0002ru6\t!O\u0003\u0002ti\u0006)An\\45U*\u0011QO^\u0001\bY><w-\u001b8h\u0015\t9\b0\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002s\u0006\u0019qN]4\n\u0005m\u0014(A\u0002'pO\u001e,'\u000f\u000b\u0002\b{B\u0011\u0001F`\u0005\u0003\u007f&\u0012\u0011\u0002\u001e:b]NLWM\u001c;\u0002\u001d1|wn[;q\u0011\u0006tG\r\\3sgV\u0011\u0011Q\u0001\t\u0006\u0003\u000f\ty!O\u0007\u0003\u0003\u0013Q1aQA\u0006\u0015\r\tiAH\u0001\u0005kRLG.\u0003\u0003\u0002\u0012\u0005%!a\u0005'j].,GM\u00117pG.LgnZ)vKV,\u0007F\u0001\u0005~\u0003-\t7/\u001f8d\u0019>|7.\u001e9\u0015\t\u0005e\u0011\u0011\b\t\u0006\u0003\u0006m\u0011qD\u0005\u0004\u0003;\u0011%A\u0002$viV\u0014X\r\u0005\u0004\u0002\"\u0005\r\u0012qE\u0007\u0003\u0003\u0017IA!!\n\u0002\f\tQ1i\u001c7mK\u000e$\u0018n\u001c8\u0011\t\u0005%\u0012QG\u0007\u0003\u0003WQA!!\f\u00020\u0005!A-\u0019;b\u0015\u0011\t\t$a\r\u0002\u000bQ\f'\r\\3\u000b\u0005E1\u0018\u0002BA\u001c\u0003W\u0011qAU8x\t\u0006$\u0018\rC\u0004\u0002<%\u0001\r!a\n\u0002\r-,\u0017PU8x\u0003\u0015\u0019Gn\\:f)\t\t\t\u0005E\u0002)\u0003\u0007J1!!\u0012*\u0005\u0011)f.\u001b;")
public final class ClickHouseAsyncLookupReader
implements ClickHouseAsyncLookupReaderLike {
    private transient Logger log;
    private transient LinkedBlockingQueue<JdbcRowDataLookupOperationHandler> lookupHandlers;
    private final Function0<Seq<JdbcRowDataLookupOperationHandler>> newLookupHandlers;
    private final ExecutionContext ec;
    private final Option<AbstractClickHouseLookupMetrics> metrics;
    private final RetryUtils.DelayLike retryDelay;
    private final RetryUtils.FiniteAttempt retryAttempts;
    private volatile transient byte bitmap$trans$0;

    private Logger log$lzycompute() {
        ClickHouseAsyncLookupReader clickHouseAsyncLookupReader = this;
        synchronized (clickHouseAsyncLookupReader) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.log = LogManager.getLogger(this.getClass());
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.log;
    }

    private Logger log() {
        if ((byte)(this.bitmap$trans$0 & 1) == 0) {
            return this.log$lzycompute();
        }
        return this.log;
    }

    private LinkedBlockingQueue<JdbcRowDataLookupOperationHandler> lookupHandlers$lzycompute() {
        ClickHouseAsyncLookupReader clickHouseAsyncLookupReader = this;
        synchronized (clickHouseAsyncLookupReader) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                Seq handlers = (Seq)this.newLookupHandlers.apply();
                this.log().debug(new StringBuilder(39).append("Created ").append(handlers.size()).append(" JDBC lookup operation handlers").toString());
                this.lookupHandlers = ChainingOps$.MODULE$.tap$extension(ChainingOps$.MODULE$.scalaUtilChainingOps(new LinkedBlockingQueue(handlers.size())), (Function1 & Serializable & scala.Serializable)queue -> {
                    handlers.foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                        queue.put(x$1);
                        return BoxedUnit.UNIT;
                    });
                    return BoxedUnit.UNIT;
                });
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.lookupHandlers;
    }

    private LinkedBlockingQueue<JdbcRowDataLookupOperationHandler> lookupHandlers() {
        if ((byte)(this.bitmap$trans$0 & 2) == 0) {
            return this.lookupHandlers$lzycompute();
        }
        return this.lookupHandlers;
    }

    @Override
    public Future<Collection<RowData>> asyncLookup(RowData keyRow) {
        return Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Collection collection;
            JdbcRowDataLookupOperationHandler handler = this.lookupHandlers().take();
            try {
                try {
                    collection = (Collection)Implicits$TryOps$.MODULE$.getOrElseThrow$extension(Implicits$.MODULE$.TryOps(RetryUtils$.MODULE$.retry($this.retryDelay, $this.retryAttempts, true, (Function0 & Serializable & scala.Serializable)() -> {
                        Stopwatch stopwatch = Stopwatch.createStarted();
                        Collection result = handler.lookup(keyRow);
                        $this.metrics.foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                            x$1.reportLookupLatency(stopwatch.elapsed().toMillis());
                            return BoxedUnit.UNIT;
                        });
                        return result;
                    })), (Function1 & Serializable & scala.Serializable)x$2 -> new RuntimeException(new StringBuilder(61).append("Failed to lookup values with given key row '").append(keyRow).append("' after ").append($this.retryAttempts.value()).append(" attempts").toString(), (Throwable)x$2));
                }
                catch (Throwable ex) {
                    throw new RuntimeException(new StringBuilder(29).append("Async lookup failed for key: ").append(keyRow).toString(), ex);
                }
            }
            finally {
                this.lookupHandlers().put(handler);
            }
            return collection;
        }, this.ec);
    }

    @Override
    public void close() {
        this.log().debug("Closing ClickHouse async lookup reader ...");
    }

    public ClickHouseAsyncLookupReader(Function0<Seq<JdbcRowDataLookupOperationHandler>> newLookupHandlers, ExecutionContext ec, Option<AbstractClickHouseLookupMetrics> metrics, RetryUtils.DelayLike retryDelay, RetryUtils.FiniteAttempt retryAttempts) {
        this.newLookupHandlers = newLookupHandlers;
        this.ec = ec;
        this.metrics = metrics;
        this.retryDelay = retryDelay;
        this.retryAttempts = retryAttempts;
    }
}

