/*
 * Decompiled with CFR 0.152.
 */
package com.bytedance.bytehouse.jdbc;

import com.bytedance.bytehouse.ce.CeSqlUtils$;
import com.bytedance.bytehouse.clickhouse.ClickHouseExpr$;
import com.bytedance.bytehouse.clickhouse.ClickHouseSetting;
import com.bytedance.bytehouse.clickhouse.ClickHouseSqlUtils$;
import com.bytedance.bytehouse.clickhouse.ClickHouseTable;
import com.bytedance.bytehouse.clickhouse.ClickHouseTable$;
import com.bytedance.bytehouse.clickhouse.ClickHouseTable$CeTableType$;
import com.bytedance.bytehouse.clickhouse.ClickHouseTable$CnchTableType$;
import com.bytedance.bytehouse.cnch.CnchConstants$;
import com.bytedance.bytehouse.cnch.CnchResultSetUtils$;
import com.bytedance.bytehouse.cnch.CnchSettings$InteractiveTransaction$;
import com.bytedance.bytehouse.cnch.CnchSqlUtils$;
import com.bytedance.bytehouse.commons.CallByLambdaOperable0;
import com.bytedance.bytehouse.commons.ChainingOps$;
import com.bytedance.bytehouse.commons.Using$;
import com.bytedance.bytehouse.commons.Using$Releasable$AutoCloseableIsReleasable$;
import com.bytedance.bytehouse.commons.package$;
import com.bytedance.bytehouse.commons.package$StringOps$;
import com.bytedance.bytehouse.jdbc.LazyConnection;
import com.bytedance.bytehouse.jdbc.LazyStatement;
import com.bytedance.bytehouse.jdbc.ResultSetUtils$;
import com.bytedance.bytehouse.jdbc.ResultSetUtils$ResultSetOps$;
import com.bytedance.bytehouse.jdbc.ResultSetUtils$ValueStringParsers$;
import com.bytedance.bytehouse.table.TableSchema$BasicTableSchema$;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple6;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.ListMap;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class JdbcOpsUtils$ {
    public static JdbcOpsUtils$ MODULE$;
    private transient Logger log;
    private volatile transient boolean bitmap$trans$0;

    static {
        new JdbcOpsUtils$();
    }

    private Logger log$lzycompute() {
        JdbcOpsUtils$ jdbcOpsUtils$ = this;
        synchronized (jdbcOpsUtils$) {
            if (!this.bitmap$trans$0) {
                this.log = LogManager.getLogger(this.getClass());
                this.bitmap$trans$0 = true;
            }
        }
        return this.log;
    }

    private Logger log() {
        if (!this.bitmap$trans$0) {
            return this.log$lzycompute();
        }
        return this.log;
    }

    public <T> void applySetting(CallByLambdaOperable0<LazyStatement> stmt, ClickHouseSetting<T> setting) {
        stmt.op((Function1<LazyStatement, BoxedUnit>)(Function1 & Serializable & scala.Serializable)x$1 -> {
            JdbcOpsUtils$.$anonfun$applySetting$1(x$1);
            return BoxedUnit.UNIT;
        }, (Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)JdbcOpsUtils$.$anonfun$applySetting$2(setting, x$2)));
    }

    public Seq<String> retrieveTableNames(CallByLambdaOperable0<LazyStatement> stmt, String dbName) {
        Function1 & Serializable & scala.Serializable intersect = (Function1 & Serializable & scala.Serializable)x$3 -> {
            JdbcOpsUtils$.$anonfun$retrieveTableNames$1(x$3);
            return BoxedUnit.UNIT;
        };
        this.log().debug(new StringBuilder(41).append("Retrieving table names in database '").append(dbName).append("' ...").toString());
        return (Seq)ChainingOps$.MODULE$.tap$extension(ChainingOps$.MODULE$.scalaUtilChainingOps(ChainingOps$.MODULE$.pipe$extension(ChainingOps$.MODULE$.scalaUtilChainingOps(stmt.op((Function1<LazyStatement, BoxedUnit>)intersect, (Function1 & Serializable & scala.Serializable)x$4 -> ((Statement)x$4.apply()).executeQuery(ClickHouseSqlUtils$.MODULE$.sqlShowTables(dbName)))), (Function1 & Serializable & scala.Serializable)x$5 -> (Seq)Using$.MODULE$.resource(x$5, (Function1 & Serializable & scala.Serializable)x$6 -> ResultSetUtils$ResultSetOps$.MODULE$.parsedBy$extension1(ResultSetUtils$.MODULE$.ResultSetOps((ResultSet)x$6), CnchResultSetUtils$.MODULE$.showTablesResultParserList()), Using$Releasable$AutoCloseableIsReleasable$.MODULE$))), (Function1 & Serializable & scala.Serializable)tableNames -> {
            JdbcOpsUtils$.$anonfun$retrieveTableNames$5(dbName, tableNames);
            return BoxedUnit.UNIT;
        });
    }

    public String retrieveTableDdl(CallByLambdaOperable0<LazyStatement> stmt, String dbName, String tableName) {
        Function1 & Serializable & scala.Serializable intersect = (Function1 & Serializable & scala.Serializable)x$7 -> {
            JdbcOpsUtils$.$anonfun$retrieveTableDdl$1(x$7);
            return BoxedUnit.UNIT;
        };
        this.log().debug(new StringBuilder(23).append("Retrieving DDL of ").append(package$StringOps$.MODULE$.backQuotedIfNot$extension(package$.MODULE$.StringOps(dbName))).append(".").append(package$StringOps$.MODULE$.backQuotedIfNot$extension(package$.MODULE$.StringOps(tableName))).append(" ...").toString());
        return (String)ChainingOps$.MODULE$.tap$extension(ChainingOps$.MODULE$.scalaUtilChainingOps(ChainingOps$.MODULE$.pipe$extension(ChainingOps$.MODULE$.scalaUtilChainingOps(stmt.op((Function1<LazyStatement, BoxedUnit>)intersect, (Function1 & Serializable & scala.Serializable)x$8 -> ((Statement)x$8.apply()).executeQuery(ClickHouseSqlUtils$.MODULE$.sqlShowCreateTable(dbName, tableName)))), (Function1 & Serializable & scala.Serializable)x$9 -> (String)Using$.MODULE$.resource(x$9, (Function1 & Serializable & scala.Serializable)x$10 -> (String)ResultSetUtils$ResultSetOps$.MODULE$.parsedBy$extension1(ResultSetUtils$.MODULE$.ResultSetOps((ResultSet)x$10), CnchResultSetUtils$.MODULE$.showCreateTableResultParserList()).head(), Using$Releasable$AutoCloseableIsReleasable$.MODULE$))), (Function1 & Serializable & scala.Serializable)ddl -> {
            JdbcOpsUtils$.$anonfun$retrieveTableDdl$5(dbName, tableName, ddl);
            return BoxedUnit.UNIT;
        });
    }

    public ListMap<String, String> retrieveTableSchema(CallByLambdaOperable0<LazyStatement> stmt, String tableName) {
        Function1 & Serializable & scala.Serializable intersect = (Function1 & Serializable & scala.Serializable)x$11 -> {
            JdbcOpsUtils$.$anonfun$retrieveTableSchema$1(x$11);
            return BoxedUnit.UNIT;
        };
        this.log().debug(new StringBuilder(33).append("Retrieving schema of table '").append(tableName).append("' ...").toString());
        return (ListMap)ChainingOps$.MODULE$.pipe$extension(ChainingOps$.MODULE$.scalaUtilChainingOps(ChainingOps$.MODULE$.pipe$extension(ChainingOps$.MODULE$.scalaUtilChainingOps(stmt.op((Function1<LazyStatement, BoxedUnit>)intersect, (Function1 & Serializable & scala.Serializable)x$12 -> ((Statement)x$12.apply()).executeQuery(ClickHouseSqlUtils$.MODULE$.sqlDescribeTable(tableName)))), (Function1 & Serializable & scala.Serializable)x$13 -> (Seq)Using$.MODULE$.resource(x$13, (Function1 & Serializable & scala.Serializable)x$14 -> ResultSetUtils$ResultSetOps$.MODULE$.parsedBy$extension1(ResultSetUtils$.MODULE$.ResultSetOps((ResultSet)x$14), CnchResultSetUtils$.MODULE$.describeTableResultParserList()), Using$Releasable$AutoCloseableIsReleasable$.MODULE$))), (Function1 & Serializable & scala.Serializable)x$15 -> TableSchema$BasicTableSchema$.MODULE$.apply((Seq<Tuple2<String, String>>)x$15));
    }

    public Seq<String> retrieveTablePartitionIds(CallByLambdaOperable0<LazyStatement> stmt, String tableName) {
        Function1 & Serializable & scala.Serializable intersect = (Function1 & Serializable & scala.Serializable)x$16 -> {
            JdbcOpsUtils$.$anonfun$retrieveTablePartitionIds$1(x$16);
            return BoxedUnit.UNIT;
        };
        this.log().debug(new StringBuilder(40).append("Retrieving partition IDs of table '").append(tableName).append("' ...").toString());
        return (Seq)ChainingOps$.MODULE$.pipe$extension(ChainingOps$.MODULE$.scalaUtilChainingOps(stmt.op((Function1<LazyStatement, BoxedUnit>)intersect, (Function1 & Serializable & scala.Serializable)x$17 -> ((Statement)x$17.apply()).executeQuery(ClickHouseSqlUtils$.MODULE$.sqlSelect(tableName, new StringBuilder(22).append("DISTINCT ").append("_partition_id").toString(), (Option<String>)None$.MODULE$)))), (Function1 & Serializable & scala.Serializable)x$18 -> (Seq)((SeqLike)Using$.MODULE$.resource(x$18, (Function1 & Serializable & scala.Serializable)x$19 -> ResultSetUtils$ResultSetOps$.MODULE$.parsedBy$extension0(ResultSetUtils$.MODULE$.ResultSetOps((ResultSet)x$19), ResultSetUtils$ValueStringParsers$.MODULE$.SingleColumn("_partition_id")), Using$Releasable$AutoCloseableIsReleasable$.MODULE$)).sorted((Ordering)Ordering.String$.MODULE$));
    }

    public ClickHouseTable retrieveClickHouseTable(CallByLambdaOperable0<LazyStatement> stmt, String dbName, String tableName, ClickHouseTable.ClickHouseTableType tableType, Level jdbcLogLevel) {
        ListMap<String, String> schema = this.retrieveTableSchema(stmt, tableName);
        if (tableType.equals(ClickHouseTable$CnchTableType$.MODULE$)) {
            return this.retrieveCnchTableDefinition(stmt, dbName, tableName, schema, jdbcLogLevel);
        }
        return this.retrieveCeTableDefinition(stmt, dbName, tableName, schema, jdbcLogLevel);
    }

    private ClickHouseTable retrieveCeTableDefinition(CallByLambdaOperable0<LazyStatement> stmt, String dbName, String tableName, ListMap<String, String> schema, Level jdbcLogLevel) {
        return (ClickHouseTable)ChainingOps$.MODULE$.tap$extension(ChainingOps$.MODULE$.scalaUtilChainingOps(ChainingOps$.MODULE$.pipe$extension(ChainingOps$.MODULE$.scalaUtilChainingOps(ChainingOps$.MODULE$.pipe$extension(ChainingOps$.MODULE$.scalaUtilChainingOps(stmt.op((Function1<LazyStatement, BoxedUnit>)(Function1 & Serializable & scala.Serializable)x$20 -> {
            JdbcOpsUtils$.$anonfun$retrieveCeTableDefinition$1(x$20);
            return BoxedUnit.UNIT;
        }, (Function1 & Serializable & scala.Serializable)x$21 -> ((Statement)x$21.apply()).executeQuery(CeSqlUtils$.MODULE$.sqlGetTableDefinition(dbName, tableName, CeSqlUtils$.MODULE$.sqlGetTableDefinition$default$3())))), (Function1 & Serializable & scala.Serializable)x$22 -> (String[])Using$.MODULE$.resource(x$22, (Function1 & Serializable & scala.Serializable)x$23 -> (String[])ResultSetUtils$ResultSetOps$.MODULE$.parsedBy$extension0(ResultSetUtils$.MODULE$.ResultSetOps((ResultSet)x$23), ResultSetUtils$ValueStringParsers$.MODULE$.Row(CeSqlUtils$.MODULE$.TableDdlFields())).head(), Using$Releasable$AutoCloseableIsReleasable$.MODULE$))), (Function1 & Serializable & scala.Serializable)res -> {
            String[] stringArray = res;
            Option option = Array$.MODULE$.unapplySeq((Object)stringArray);
            if (option.isEmpty() || option.get() == null || ((SeqLike)option.get()).lengthCompare(6) != 0) {
                throw new MatchError((Object)stringArray);
            }
            String uuid = (String)((SeqLike)option.get()).apply(0);
            String partitionKey = (String)((SeqLike)option.get()).apply(1);
            String sortingKey = (String)((SeqLike)option.get()).apply(2);
            String primaryKey = (String)((SeqLike)option.get()).apply(3);
            String samplingKey = (String)((SeqLike)option.get()).apply(4);
            String ddl = (String)((SeqLike)option.get()).apply(5);
            Tuple6 tuple6 = new Tuple6((Object)uuid, (Object)partitionKey, (Object)sortingKey, (Object)primaryKey, (Object)samplingKey, (Object)ddl);
            String uuid2 = (String)tuple6._1();
            String partitionKey2 = (String)tuple6._2();
            String sortingKey2 = (String)tuple6._3();
            String primaryKey2 = (String)tuple6._4();
            String samplingKey2 = (String)tuple6._5();
            String ddl2 = (String)tuple6._6();
            return ClickHouseTable$.MODULE$.fromSystemTableQuery(dbName, tableName, partitionKey2, sortingKey2, primaryKey2, samplingKey2, "", ddl2, (Option<String>)new Some((Object)uuid2), schema, ClickHouseTable$CeTableType$.MODULE$);
        })), (Function1 & Serializable & scala.Serializable)table -> {
            JdbcOpsUtils$.$anonfun$retrieveCeTableDefinition$6(jdbcLogLevel, table);
            return BoxedUnit.UNIT;
        });
    }

    private ClickHouseTable retrieveCnchTableDefinition(CallByLambdaOperable0<LazyStatement> stmt, String dbName, String tableName, ListMap<String, String> schema, Level jdbcLogLevel) {
        return (ClickHouseTable)ChainingOps$.MODULE$.tap$extension(ChainingOps$.MODULE$.scalaUtilChainingOps(ChainingOps$.MODULE$.pipe$extension(ChainingOps$.MODULE$.scalaUtilChainingOps(ChainingOps$.MODULE$.pipe$extension(ChainingOps$.MODULE$.scalaUtilChainingOps(stmt.op((Function1<LazyStatement, BoxedUnit>)(Function1 & Serializable & scala.Serializable)x$25 -> {
            JdbcOpsUtils$.$anonfun$retrieveCnchTableDefinition$1(x$25);
            return BoxedUnit.UNIT;
        }, (Function1 & Serializable & scala.Serializable)x$26 -> ((Statement)x$26.apply()).executeQuery(ClickHouseSqlUtils$.MODULE$.sqlShowCreateTable(dbName, tableName)))), (Function1 & Serializable & scala.Serializable)x$27 -> (Seq)Using$.MODULE$.resource(x$27, (Function1 & Serializable & scala.Serializable)x$28 -> ResultSetUtils$ResultSetOps$.MODULE$.parsedBy$extension1(ResultSetUtils$.MODULE$.ResultSetOps((ResultSet)x$28), CnchResultSetUtils$.MODULE$.showCreateTableResultParserList()), Using$Releasable$AutoCloseableIsReleasable$.MODULE$))), (Function1 & Serializable & scala.Serializable)res -> {
            Seq seq = res;
            Some some = Seq$.MODULE$.unapplySeq(seq);
            if (some.isEmpty() || some.get() == null || ((SeqLike)some.get()).lengthCompare(1) < 0) {
                throw new MatchError((Object)seq);
            }
            String ddl = (String)((SeqLike)some.get()).apply(0);
            String ddl2 = ddl;
            return ClickHouseTable$.MODULE$.fromSystemTableQuery(dbName, tableName, "", "", "", "", "", ddl2, (Option<String>)new Some((Object)""), schema, ClickHouseTable$CnchTableType$.MODULE$);
        })), (Function1 & Serializable & scala.Serializable)table -> {
            JdbcOpsUtils$.$anonfun$retrieveCnchTableDefinition$6(jdbcLogLevel, table);
            return BoxedUnit.UNIT;
        });
    }

    public boolean dropTableIfExists(CallByLambdaOperable0<LazyStatement> stmt, String tableName) {
        Function1 & Serializable & scala.Serializable intersect = (Function1 & Serializable & scala.Serializable)x$29 -> {
            JdbcOpsUtils$.$anonfun$dropTableIfExists$1(x$29);
            return BoxedUnit.UNIT;
        };
        this.log().info(new StringBuilder(34).append("Dropping table '").append(tableName).append("' if it exists ...").toString());
        return BoxesRunTime.unboxToBoolean(ChainingOps$.MODULE$.tap$extension(ChainingOps$.MODULE$.scalaUtilChainingOps(stmt.op((Function1<LazyStatement, BoxedUnit>)intersect, (Function1 & Serializable & scala.Serializable)x$30 -> BoxesRunTime.boxToBoolean((boolean)JdbcOpsUtils$.$anonfun$dropTableIfExists$2(tableName, x$30)))), (Function1 & Serializable & scala.Serializable)x$31 -> {
            JdbcOpsUtils$.$anonfun$dropTableIfExists$3(tableName, BoxesRunTime.unboxToBoolean((Object)x$31));
            return BoxedUnit.UNIT;
        }));
    }

    public ResultSet insertFromTable(CallByLambdaOperable0<Statement> jdbcStmt, String fromTableName, String intoTableName, Seq<String> colNames) {
        Function1 & Serializable & scala.Serializable intersect = (Function1 & Serializable & scala.Serializable)x$32 -> {
            JdbcOpsUtils$.$anonfun$insertFromTable$1(x$32);
            return BoxedUnit.UNIT;
        };
        this.log().info(new StringBuilder(46).append("Inserting rows from table '").append(fromTableName).append("' into table '").append(intoTableName).append("' ...").toString());
        return (ResultSet)ChainingOps$.MODULE$.tap$extension(ChainingOps$.MODULE$.scalaUtilChainingOps(jdbcStmt.op((Function1<Statement, BoxedUnit>)intersect, (Function1 & Serializable & scala.Serializable)x$33 -> x$33.executeQuery(ClickHouseSqlUtils$.MODULE$.sqlInsertFromTable(fromTableName, intoTableName, colNames)))), (Function1 & Serializable & scala.Serializable)x$34 -> {
            JdbcOpsUtils$.$anonfun$insertFromTable$3(fromTableName, intoTableName, x$34);
            return BoxedUnit.UNIT;
        });
    }

    public boolean enableInteractiveTransaction(CallByLambdaOperable0<LazyStatement> stmt) {
        return BoxesRunTime.unboxToBoolean(ChainingOps$.MODULE$.tap$extension(ChainingOps$.MODULE$.scalaUtilChainingOps(stmt.op((Function1<LazyStatement, BoxedUnit>)(Function1 & Serializable & scala.Serializable)x$35 -> {
            JdbcOpsUtils$.$anonfun$enableInteractiveTransaction$1(x$35);
            return BoxedUnit.UNIT;
        }, (Function1 & Serializable & scala.Serializable)x$36 -> BoxesRunTime.boxToBoolean((boolean)JdbcOpsUtils$.$anonfun$enableInteractiveTransaction$2(x$36)))), (Function1 & Serializable & scala.Serializable)x$37 -> {
            JdbcOpsUtils$.$anonfun$enableInteractiveTransaction$3(BoxesRunTime.unboxToBoolean((Object)x$37));
            return BoxedUnit.UNIT;
        }));
    }

    public boolean existsTable(String tableName, CallByLambdaOperable0<LazyConnection> conn) {
        return BoxesRunTime.unboxToBoolean(conn.op((Function1<LazyConnection, BoxedUnit>)(Function1 & Serializable & scala.Serializable)x$38 -> {
            JdbcOpsUtils$.$anonfun$existsTable$1(x$38);
            return BoxedUnit.UNIT;
        }, (Function1 & Serializable & scala.Serializable)x$39 -> BoxesRunTime.boxToBoolean((boolean)JdbcOpsUtils$.$anonfun$existsTable$2(tableName, x$39))));
    }

    public void executeDdl(CallByLambdaOperable0<LazyStatement> stmt, String ddl) {
        stmt.op((Function1<LazyStatement, BoxedUnit>)(Function1 & Serializable & scala.Serializable)x$40 -> {
            JdbcOpsUtils$.$anonfun$executeDdl$1(x$40);
            return BoxedUnit.UNIT;
        }, (Function1 & Serializable & scala.Serializable)x$41 -> BoxesRunTime.boxToInteger((int)JdbcOpsUtils$.$anonfun$executeDdl$2(ddl, x$41)));
    }

    public Map<String, String> retrieveTableSettings(String tableName, CallByLambdaOperable0<LazyConnection> conn) {
        String sql = CnchSqlUtils$.MODULE$.sqlShowTableSettings(tableName);
        Try try_ = (Try)conn.op((Function1<LazyConnection, BoxedUnit>)(Function1 & Serializable & scala.Serializable)x$42 -> {
            JdbcOpsUtils$.$anonfun$retrieveTableSettings$1(x$42);
            return BoxedUnit.UNIT;
        }, (Function1 & Serializable & scala.Serializable)connection -> Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> ((Connection)connection.apply()).createStatement().executeQuery(sql)));
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            ResultSet result = (ResultSet)success.value();
            return ((TraversableOnce)Using$.MODULE$.resource(result, (Function1 & Serializable & scala.Serializable)x$43 -> ResultSetUtils$ResultSetOps$.MODULE$.parsedBy$extension0(ResultSetUtils$.MODULE$.ResultSetOps((ResultSet)x$43), ResultSetUtils$ValueStringParsers$.MODULE$.KeyValueColumns(CnchConstants$.MODULE$.TableSettingFields())), Using$Releasable$AutoCloseableIsReleasable$.MODULE$)).toMap(Predef$.MODULE$.$conforms());
        }
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable ex = failure.exception();
            String errMsg = ex.getMessage();
            if (errMsg.contains("DB::ExceptionDB::Exception:") && errMsg.contains("Syntax error:")) {
                this.log().error(new StringBuilder(50).append("Failed to retrieve table settings. SQL statement: ").append(sql).toString(), ex);
                return Predef$.MODULE$.Map().empty();
            }
            throw ex;
        }
        throw new MatchError((Object)try_);
    }

    public Set<String> retrieveUpsertKeyColumnNames(String tableName, CallByLambdaOperable0<LazyConnection> conn) {
        return (Set)ChainingOps$.MODULE$.pipe$extension(ChainingOps$.MODULE$.scalaUtilChainingOps(ChainingOps$.MODULE$.pipe$extension(ChainingOps$.MODULE$.scalaUtilChainingOps(ChainingOps$.MODULE$.pipe$extension(ChainingOps$.MODULE$.scalaUtilChainingOps(conn.op((Function1<LazyConnection, BoxedUnit>)(Function1 & Serializable & scala.Serializable)x$44 -> {
            JdbcOpsUtils$.$anonfun$retrieveUpsertKeyColumnNames$1(x$44);
            return BoxedUnit.UNIT;
        }, (Function1 & Serializable & scala.Serializable)x$45 -> ((Connection)x$45.apply()).createStatement().executeQuery(CnchSqlUtils$.MODULE$.sqlShowTableKeys(tableName)))), (Function1 & Serializable & scala.Serializable)x$46 -> (Seq)Using$.MODULE$.resource(x$46, (Function1 & Serializable & scala.Serializable)x$47 -> ResultSetUtils$ResultSetOps$.MODULE$.parsedBy$extension0(ResultSetUtils$.MODULE$.ResultSetOps((ResultSet)x$47), ResultSetUtils$ValueStringParsers$.MODULE$.Row(CnchConstants$.MODULE$.UpsertKeyFields())), Using$Releasable$AutoCloseableIsReleasable$.MODULE$))), (Function1 & Serializable & scala.Serializable)x$48 -> (String[])x$48.headOption().getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalStateException("Failed to retrieve upsert associated keys (i.e., partition & unique keys)");
        }))), (Function1 & Serializable & scala.Serializable)x$49 -> (Set)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$49)).map((Function1 & Serializable & scala.Serializable)expr -> ClickHouseExpr$.MODULE$.extractVariables((String)expr), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Set.class))))).reduce((Function2 & Serializable & scala.Serializable)(x$50, x$51) -> (Set)x$50.$plus$plus((GenTraversableOnce)x$51)));
    }

    public int retrieveTableLookupProfile(CallByLambdaOperable0<LazyConnection> conn) {
        return BoxesRunTime.unboxToInt(ChainingOps$.MODULE$.pipe$extension(ChainingOps$.MODULE$.scalaUtilChainingOps(conn.op((Function1<LazyConnection, BoxedUnit>)(Function1 & Serializable & scala.Serializable)x$52 -> {
            JdbcOpsUtils$.$anonfun$retrieveTableLookupProfile$1(x$52);
            return BoxedUnit.UNIT;
        }, (Function1 & Serializable & scala.Serializable)x$53 -> ((Connection)x$53.apply()).createStatement().executeQuery(CnchSqlUtils$.MODULE$.sqlSelect("system", "settings", new StringBuilder(24).append("count() as ").append("lookupProfile").toString(), (Option<String>)new Some((Object)"name = 'enable_point_lookup_profile'"))))), (Function1 & Serializable & scala.Serializable)x$54 -> BoxesRunTime.boxToInteger((int)JdbcOpsUtils$.$anonfun$retrieveTableLookupProfile$3(x$54))));
    }

    public static final /* synthetic */ void $anonfun$applySetting$1(LazyStatement x$1) {
    }

    public static final /* synthetic */ boolean $anonfun$applySetting$2(ClickHouseSetting setting$1, LazyStatement x$2) {
        return ((Statement)x$2.apply()).execute(ClickHouseSqlUtils$.MODULE$.sqlSet(setting$1));
    }

    public static final /* synthetic */ void $anonfun$retrieveTableNames$1(LazyStatement x$3) {
    }

    public static final /* synthetic */ void $anonfun$retrieveTableNames$5(String dbName$1, Seq tableNames) {
        MODULE$.log().debug(new StringBuilder(29).append("Retrieved table names in '").append(dbName$1).append("':\n").append(tableNames.mkString("\n")).toString());
    }

    public static final /* synthetic */ void $anonfun$retrieveTableDdl$1(LazyStatement x$7) {
    }

    public static final /* synthetic */ void $anonfun$retrieveTableDdl$5(String dbName$2, String tableName$1, String ddl) {
        MODULE$.log().debug(new StringBuilder(21).append("Retrieved DDL of ").append(package$StringOps$.MODULE$.backQuotedIfNot$extension(package$.MODULE$.StringOps(dbName$2))).append(".").append(package$StringOps$.MODULE$.backQuotedIfNot$extension(package$.MODULE$.StringOps(tableName$1))).append(":\n").append(ddl).append(";").toString());
    }

    public static final /* synthetic */ void $anonfun$retrieveTableSchema$1(LazyStatement x$11) {
    }

    public static final /* synthetic */ void $anonfun$retrieveTablePartitionIds$1(LazyStatement x$16) {
    }

    public static final /* synthetic */ void $anonfun$retrieveCeTableDefinition$1(LazyStatement x$20) {
    }

    public static final /* synthetic */ void $anonfun$retrieveCeTableDefinition$6(Level jdbcLogLevel$1, ClickHouseTable table) {
        MODULE$.log().atLevel(jdbcLogLevel$1).log(table.toString());
    }

    public static final /* synthetic */ void $anonfun$retrieveCnchTableDefinition$1(LazyStatement x$25) {
    }

    public static final /* synthetic */ void $anonfun$retrieveCnchTableDefinition$6(Level jdbcLogLevel$2, ClickHouseTable table) {
        MODULE$.log().atLevel(jdbcLogLevel$2).log(table.toString());
    }

    public static final /* synthetic */ void $anonfun$dropTableIfExists$1(LazyStatement x$29) {
    }

    public static final /* synthetic */ boolean $anonfun$dropTableIfExists$2(String tableName$6, LazyStatement x$30) {
        return ((Statement)x$30.apply()).execute(ClickHouseSqlUtils$.MODULE$.sqlDropTableIfExists(tableName$6));
    }

    public static final /* synthetic */ void $anonfun$dropTableIfExists$3(String tableName$6, boolean x$31) {
        MODULE$.log().info(new StringBuilder(25).append("Table '").append(tableName$6).append("' has been dropped").toString());
    }

    public static final /* synthetic */ void $anonfun$insertFromTable$1(Statement x$32) {
    }

    public static final /* synthetic */ void $anonfun$insertFromTable$3(String fromTableName$1, String intoTableName$1, ResultSet x$34) {
        MODULE$.log().info(new StringBuilder(55).append("All rows from table '").append(fromTableName$1).append("' have been inserted into table '").append(intoTableName$1).append("'").toString());
    }

    public static final /* synthetic */ void $anonfun$enableInteractiveTransaction$1(LazyStatement x$35) {
    }

    public static final /* synthetic */ boolean $anonfun$enableInteractiveTransaction$2(LazyStatement x$36) {
        return ((Statement)x$36.apply()).execute(ClickHouseSqlUtils$.MODULE$.sqlSet(CnchSettings$InteractiveTransaction$.MODULE$.Enable()));
    }

    public static final /* synthetic */ void $anonfun$enableInteractiveTransaction$3(boolean x$37) {
        MODULE$.log().info("Enabled interactive transaction for CNCH");
    }

    public static final /* synthetic */ void $anonfun$existsTable$1(LazyConnection x$38) {
    }

    public static final /* synthetic */ boolean $anonfun$existsTable$2(String tableName$7, LazyConnection x$39) {
        return ((Connection)x$39.apply()).getMetaData().getTables((String)None$.MODULE$.orNull(Predef$.MODULE$.$conforms()), (String)None$.MODULE$.orNull(Predef$.MODULE$.$conforms()), tableName$7, (String[])((Object[])new String[]{"TABLE"})).next();
    }

    public static final /* synthetic */ void $anonfun$executeDdl$1(LazyStatement x$40) {
    }

    public static final /* synthetic */ int $anonfun$executeDdl$2(String ddl$1, LazyStatement x$41) {
        return ((Statement)x$41.apply()).executeUpdate(ddl$1);
    }

    public static final /* synthetic */ void $anonfun$retrieveTableSettings$1(LazyConnection x$42) {
    }

    public static final /* synthetic */ void $anonfun$retrieveUpsertKeyColumnNames$1(LazyConnection x$44) {
    }

    public static final /* synthetic */ void $anonfun$retrieveTableLookupProfile$1(LazyConnection x$52) {
    }

    public static final /* synthetic */ int $anonfun$retrieveTableLookupProfile$3(ResultSet x$54) {
        return new StringOps(Predef$.MODULE$.augmentString((String)((IterableLike)Using$.MODULE$.resource(x$54, (Function1 & Serializable & scala.Serializable)x$55 -> ResultSetUtils$ResultSetOps$.MODULE$.parsedBy$extension0(ResultSetUtils$.MODULE$.ResultSetOps((ResultSet)x$55), ResultSetUtils$ValueStringParsers$.MODULE$.SingleColumn("lookupProfile")), Using$Releasable$AutoCloseableIsReleasable$.MODULE$)).head())).toInt();
    }

    private JdbcOpsUtils$() {
        MODULE$ = this;
    }
}

