/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client;

import com.clickhouse.client.ClickHouseClient;
import com.clickhouse.client.ClickHouseConfig;
import com.clickhouse.client.ClickHouseException;
import com.clickhouse.client.ClickHouseNode;
import com.clickhouse.client.ClickHouseNodeSelector;
import com.clickhouse.client.ClickHouseProtocol;
import com.clickhouse.client.ClickHouseRequest;
import com.clickhouse.client.ClickHouseResponse;
import com.clickhouse.client.config.ClickHouseClientOption;
import com.clickhouse.client.config.ClickHouseHealthCheckMethod;
import com.clickhouse.config.ClickHouseOption;
import com.clickhouse.data.ClickHouseChecker;
import com.clickhouse.data.ClickHouseUtils;
import com.clickhouse.logging.Logger;
import com.clickhouse.logging.LoggerFactory;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Function;

public abstract class AbstractClient<T>
implements ClickHouseClient {
    private static final Logger log = LoggerFactory.getLogger(AbstractClient.class);
    private boolean initialized = false;
    private ExecutorService executor = null;
    private ClickHouseConfig config = null;
    private ClickHouseNode server = null;
    private T connection = null;
    protected final ReadWriteLock lock = new ReentrantReadWriteLock();

    private void ensureInitialized() {
        if (!this.initialized) {
            throw new IllegalStateException("Please initialize the client first");
        }
    }

    final boolean isInitialized() {
        return this.initialized;
    }

    protected abstract boolean checkHealth(ClickHouseNode var1, int var2);

    protected CompletableFuture<ClickHouseResponse> failedResponse(Throwable ex) {
        CompletableFuture<ClickHouseResponse> future = new CompletableFuture<ClickHouseResponse>();
        future.completeExceptionally(ex);
        return future;
    }

    protected final ExecutorService getExecutor() {
        this.lock.readLock().lock();
        try {
            this.ensureInitialized();
            ExecutorService executorService = this.executor;
            return executorService;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    protected abstract Collection<ClickHouseProtocol> getSupportedProtocols();

    protected final ClickHouseNode getServer() {
        this.lock.readLock().lock();
        try {
            this.ensureInitialized();
            ClickHouseNode clickHouseNode = this.server;
            return clickHouseNode;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    protected boolean checkConnection(T connection, ClickHouseNode requestServer, ClickHouseNode currentServer, ClickHouseRequest<?> request) {
        return connection != null && requestServer.equals(currentServer);
    }

    protected abstract T newConnection(T var1, ClickHouseNode var2, ClickHouseRequest<?> var3);

    protected abstract void closeConnection(T var1, boolean var2);

    protected Object[] getAsyncExecArguments(ClickHouseRequest<?> sealedRequest) {
        return new Object[0];
    }

    protected ClickHouseResponse sendAsync(ClickHouseRequest<?> sealedRequest, Object ... args) throws ClickHouseException, IOException {
        return this.send(sealedRequest);
    }

    protected abstract ClickHouseResponse send(ClickHouseRequest<?> var1) throws ClickHouseException, IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final T getConnection(ClickHouseRequest<?> request) {
        ClickHouseNode newNode = ClickHouseChecker.nonNull(request, "request").getServer();
        this.lock.readLock().lock();
        try {
            this.ensureInitialized();
            if (this.checkConnection(this.connection, newNode, this.server, request)) {
                T t2 = this.connection;
                return t2;
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        this.lock.writeLock().lock();
        try {
            this.server = newNode;
            log.debug((Object)"Connecting to: %s", newNode);
            this.connection = this.newConnection(this.connection, this.server, request);
            log.debug((Object)"Connection established: %s", this.connection);
            T t3 = this.connection;
            return t3;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public boolean accept(ClickHouseProtocol protocol) {
        for (ClickHouseProtocol p : this.getSupportedProtocols()) {
            if (p != protocol) continue;
            return true;
        }
        return ClickHouseClient.super.accept(protocol);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ClickHouseRequest<?> read(Function<ClickHouseNodeSelector, ClickHouseNode> nodeFunc, Map<ClickHouseOption, Serializable> options) {
        this.lock.readLock().lock();
        try {
            this.ensureInitialized();
            ClickHouseRequest<?> clickHouseRequest = ClickHouseClient.super.read(nodeFunc, options);
            return clickHouseRequest;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public final ClickHouseConfig getConfig() {
        this.lock.readLock().lock();
        try {
            this.ensureInitialized();
            ClickHouseConfig clickHouseConfig = this.config;
            return clickHouseConfig;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init(ClickHouseConfig config) {
        ClickHouseChecker.nonNull(config, "Config");
        this.lock.writeLock().lock();
        try {
            Collection<ClickHouseProtocol> protocols = this.getSupportedProtocols();
            this.config = new ClickHouseConfig(config.getAllOptions(), config.getDefaultCredentials(), config.getNodeSelector() != ClickHouseNodeSelector.EMPTY || protocols.isEmpty() ? config.getNodeSelector() : ClickHouseNodeSelector.of(protocols, null), config.getMetricRegistry().orElse(null));
            if (this.executor == null) {
                int threads = config.getMaxThreadsPerClient();
                this.executor = threads < 1 ? ClickHouseClient.getExecutorService() : ClickHouseUtils.newThreadPool(this, threads, config.getMaxQueuedRequests());
            }
            this.initialized = true;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public CompletableFuture<ClickHouseResponse> execute(ClickHouseRequest<?> request) {
        ClickHouseRequest<?> sealedRequest = request.seal();
        if (sealedRequest.getConfig().isAsync()) {
            Object[] args = this.getAsyncExecArguments(sealedRequest);
            return CompletableFuture.supplyAsync(() -> {
                try {
                    return this.sendAsync(sealedRequest, args);
                }
                catch (ClickHouseException | IOException e) {
                    throw new CompletionException(ClickHouseException.of(e, sealedRequest.getServer()));
                }
            }, this.getExecutor());
        }
        try {
            return CompletableFuture.completedFuture(this.send(sealedRequest));
        }
        catch (ClickHouseException | IOException e) {
            return this.failedResponse(ClickHouseException.of(e, sealedRequest.getServer()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void close() {
        this.lock.readLock().lock();
        try {
            if (!this.initialized) {
                return;
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        this.lock.writeLock().lock();
        try {
            this.server = null;
            if (this.connection != null) {
                this.closeConnection(this.connection, false);
                this.connection = null;
            }
            if (this.executor != null && this.config.getMaxThreadsPerClient() > 0 && !this.executor.isTerminated()) {
                this.executor.shutdown();
            }
            this.executor = null;
        }
        catch (Exception e) {
            log.warn((Object)"Exception occurred when closing client", e);
        }
        finally {
            this.initialized = false;
            try {
                if (this.connection != null) {
                    this.closeConnection(this.connection, true);
                }
                if (this.executor != null && this.config.getMaxThreadsPerClient() > 0) {
                    this.executor.shutdownNow();
                }
            }
            finally {
                this.executor = null;
                this.connection = null;
                this.lock.writeLock().unlock();
            }
        }
    }

    @Override
    public boolean ping(ClickHouseNode server, int timeout) {
        if (server == null) {
            return false;
        }
        if (server.config.getOption((ClickHouseOption)ClickHouseClientOption.HEALTH_CHECK_METHOD, this.getConfig()) != ClickHouseHealthCheckMethod.PING) {
            return ClickHouseClient.super.ping(server, timeout);
        }
        if (server.getProtocol() == ClickHouseProtocol.ANY) {
            server = ClickHouseNode.probe(server.getHost(), server.getPort(), timeout);
        }
        return this.checkHealth(server, timeout);
    }
}

