/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.api.data_formats;

import com.clickhouse.client.api.data_formats.internal.AbstractBinaryFormatReader;
import com.clickhouse.client.api.metadata.TableSchema;
import com.clickhouse.client.api.query.QuerySettings;
import com.clickhouse.data.ClickHouseColumn;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;

public class RowBinaryFormatReader
extends AbstractBinaryFormatReader {
    public RowBinaryFormatReader(InputStream inputStream, TableSchema schema) {
        this(inputStream, null, schema);
    }

    public RowBinaryFormatReader(InputStream inputStream, QuerySettings querySettings, TableSchema schema) {
        super(inputStream, querySettings, schema);
        this.readNextRecord();
    }

    @Override
    public boolean readRecord(Map<String, Object> record2) throws IOException {
        boolean firstColumn = true;
        for (ClickHouseColumn column : this.getSchema().getColumns()) {
            try {
                Object val = this.binaryStreamReader.readValue(column);
                if (val != null) {
                    record2.put(column.getColumnName(), val);
                }
                firstColumn = false;
            }
            catch (EOFException e) {
                if (firstColumn) {
                    this.endReached();
                    return false;
                }
                throw e;
            }
        }
        return true;
    }
}

