/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.http;

import com.clickhouse.client.AbstractSocketClient;
import com.clickhouse.client.ClickHouseClient;
import com.clickhouse.client.ClickHouseConfig;
import com.clickhouse.client.ClickHouseNode;
import com.clickhouse.client.ClickHouseRequest;
import com.clickhouse.client.ClickHouseSocketFactory;
import com.clickhouse.client.ClickHouseSslContextProvider;
import com.clickhouse.client.config.ClickHouseClientOption;
import com.clickhouse.client.config.ClickHouseProxyType;
import com.clickhouse.client.config.ClickHouseSslMode;
import com.clickhouse.client.http.ClickHouseHttpConnection;
import com.clickhouse.client.http.ClickHouseHttpEntity;
import com.clickhouse.client.http.ClickHouseHttpResponse;
import com.clickhouse.client.http.config.ClickHouseHttpOption;
import com.clickhouse.data.ClickHouseChecker;
import com.clickhouse.data.ClickHouseExternalTable;
import com.clickhouse.data.ClickHouseFormat;
import com.clickhouse.data.ClickHouseInputStream;
import com.clickhouse.data.ClickHouseOutputStream;
import com.clickhouse.data.ClickHouseUtils;
import com.clickhouse.logging.Logger;
import com.clickhouse.logging.LoggerFactory;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.config.ConnectionConfig;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.socket.ConnectionSocketFactory;
import org.apache.hc.client5.http.socket.PlainConnectionSocketFactory;
import org.apache.hc.client5.http.ssl.DefaultHostnameVerifier;
import org.apache.hc.client5.http.ssl.SSLConnectionSocketFactory;
import org.apache.hc.core5.http.ConnectionClosedException;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.NoHttpResponseException;
import org.apache.hc.core5.http.config.Registry;
import org.apache.hc.core5.http.config.RegistryBuilder;
import org.apache.hc.core5.http.io.SocketConfig;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.pool.PoolConcurrencyPolicy;
import org.apache.hc.core5.pool.PoolReusePolicy;
import org.apache.hc.core5.ssl.SSLContexts;
import org.apache.hc.core5.util.TimeValue;
import org.apache.hc.core5.util.Timeout;
import org.apache.hc.core5.util.VersionInfo;

public class ApacheHttpConnectionImpl
extends ClickHouseHttpConnection {
    private static final Logger log = LoggerFactory.getLogger(ApacheHttpConnectionImpl.class);
    private final CloseableHttpClient client;

    protected ApacheHttpConnectionImpl(ClickHouseNode server, ClickHouseRequest<?> request, ExecutorService executor) throws IOException {
        super(server, request, Collections.emptyMap());
        this.client = this.newConnection(this.config);
    }

    private CloseableHttpClient newConnection(ClickHouseConfig c) throws IOException {
        ClickHouseSocketFactory socketFactory = AbstractSocketClient.getCustomSocketFactory(c.getCustomSocketFactory(), ApacheHttpClientSocketFactory.instance, PlainConnectionSocketFactory.class);
        RegistryBuilder<ConnectionSocketFactory> r = RegistryBuilder.create().register("http", socketFactory.create(c, PlainConnectionSocketFactory.class));
        if (c.isSsl()) {
            r.register("https", socketFactory.create(c, SSLConnectionSocketFactory.class));
        }
        long connectionTTL = this.config.getLongOption(ClickHouseClientOption.CONNECTION_TTL);
        log.info((Object)"Connection TTL: %d ms", connectionTTL);
        String poolReuseStrategy = c.getStrOption(ClickHouseHttpOption.CONNECTION_REUSE_STRATEGY);
        PoolReusePolicy poolReusePolicy = PoolReusePolicy.LIFO;
        if (poolReuseStrategy != null && !poolReuseStrategy.isEmpty()) {
            try {
                poolReusePolicy = PoolReusePolicy.valueOf(poolReuseStrategy);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Invalid connection reuse strategy: " + poolReuseStrategy);
            }
        }
        log.info((Object)"Connection reuse strategy: %s", poolReusePolicy.name());
        HttpConnectionManager connManager = new HttpConnectionManager(r.build(), c, PoolConcurrencyPolicy.LAX, poolReusePolicy, TimeValue.ofMilliseconds(connectionTTL));
        int maxConnection = this.config.getIntOption(ClickHouseHttpOption.MAX_OPEN_CONNECTIONS);
        connManager.setMaxTotal(Integer.MAX_VALUE);
        connManager.setDefaultMaxPerRoute(maxConnection);
        HttpClientBuilder builder = HttpClientBuilder.create().setConnectionManager(connManager).disableContentCompression();
        long timeout = c.getLongOption(ClickHouseHttpOption.KEEP_ALIVE_TIMEOUT);
        if (timeout > 0L) {
            builder.setKeepAliveStrategy((response, context) -> TimeValue.ofMilliseconds(timeout));
        }
        if (c.getProxyType() == ClickHouseProxyType.HTTP) {
            builder.setProxy(new HttpHost(c.getProxyHost(), c.getProxyPort()));
        }
        return builder.build();
    }

    private ClickHouseHttpResponse buildResponse(ClickHouseConfig config, CloseableHttpResponse response, ClickHouseOutputStream output, Runnable postCloseAction) throws IOException {
        Runnable action;
        InputStream source;
        String displayName = this.getResponseHeader(response, "X-ClickHouse-Server-Display-Name", this.server.getHost());
        String queryId = this.getResponseHeader(response, "X-ClickHouse-Query-Id", "");
        String summary = this.getResponseHeader(response, "X-ClickHouse-Summary", "{}");
        ClickHouseFormat format = config.getFormat();
        TimeZone timeZone = config.getServerTimeZone();
        boolean hasCustomOutput = output != null && output.getUnderlyingStream().hasOutput();
        boolean hasQueryResult = false;
        if (!ClickHouseChecker.isNullOrEmpty(queryId)) {
            String tzValue;
            String value = this.getResponseHeader(response, "X-ClickHouse-Format", "");
            if (!ClickHouseChecker.isNullOrEmpty(value)) {
                format = ClickHouseFormat.valueOf(value);
                hasQueryResult = true;
            }
            TimeZone timeZone2 = timeZone = !ClickHouseChecker.isNullOrEmpty(tzValue = this.getResponseHeader(response, "X-ClickHouse-Timezone", "")) ? TimeZone.getTimeZone(tzValue) : timeZone;
        }
        if (output != null) {
            source = ClickHouseInputStream.empty();
            action = () -> {
                try (ClickHouseOutputStream o = output;){
                    ClickHouseInputStream.pipe(response.getEntity().getContent(), (OutputStream)o, config.getWriteBufferSize());
                    if (postCloseAction != null) {
                        postCloseAction.run();
                    }
                }
                catch (IOException e) {
                    throw new UncheckedIOException("Failed to redirect response to given output stream", e);
                }
            };
        } else {
            source = response.getEntity().getContent();
            action = postCloseAction;
        }
        return new ClickHouseHttpResponse(this, hasCustomOutput ? ClickHouseInputStream.of(source, config.getReadBufferSize(), action) : (hasQueryResult ? ClickHouseClient.getAsyncResponseInputStream(config, source, action) : ClickHouseClient.getResponseInputStream(config, source, action)), displayName, queryId, summary, format, timeZone);
    }

    private String getResponseHeader(CloseableHttpResponse response, String header, String defaultValue) {
        Header h2 = response.getFirstHeader(header);
        return h2 == null ? defaultValue : h2.getValue();
    }

    private void setHeaders(HttpRequest request, Map<String, String> headers) {
        if ((headers = this.mergeHeaders(headers)) != null && !headers.isEmpty()) {
            for (Map.Entry<String, String> header : headers.entrySet()) {
                request.setHeader(header.getKey(), header.getValue());
            }
        }
    }

    private void checkResponse(ClickHouseConfig config, CloseableHttpResponse response) throws IOException {
        String errorMsg;
        if (response.getCode() == 200) {
            return;
        }
        Header errorCode = response.getFirstHeader("X-ClickHouse-Exception-Code");
        Header serverName = response.getFirstHeader("X-ClickHouse-Server-Display-Name");
        if (response.getEntity() == null) {
            throw new ConnectException(ClickHouseUtils.format("HTTP response %d %s(code %s returned from server %s)", response.getCode(), response.getReasonPhrase(), errorCode == null ? null : errorCode.getValue(), serverName == null ? null : serverName.getValue()));
        }
        int bufferSize = config.getReadBufferSize();
        ByteArrayOutputStream output = new ByteArrayOutputStream(bufferSize);
        ClickHouseInputStream.pipe(response.getEntity().getContent(), (OutputStream)output, bufferSize);
        byte[] bytes = output.toByteArray();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)ClickHouseClient.getResponseInputStream(config, new ByteArrayInputStream(bytes), null), StandardCharsets.UTF_8));){
            StringBuilder builder = new StringBuilder();
            while ((errorMsg = reader.readLine()) != null) {
                builder.append(errorMsg).append('\n');
            }
            errorMsg = builder.toString();
        }
        catch (IOException e) {
            errorMsg = ApacheHttpConnectionImpl.parseErrorFromException(errorCode != null ? errorCode.getValue() : null, serverName != null ? serverName.getValue() : null, e, bytes);
        }
        if (errorMsg != null && errorMsg.isEmpty() && errorCode != null && serverName != null) {
            String errorCodeValue = errorCode.getValue();
            String serverNameValue = serverName.getValue();
            if (errorCodeValue != null && serverNameValue != null) {
                throw new IOException(ClickHouseUtils.format("Code: %s, server: %s, %s", errorCodeValue, serverNameValue, response.toString()));
            }
        }
        throw new IOException(errorMsg);
    }

    @Override
    protected final String getDefaultUserAgent() {
        return HttpConnectionManager.USER_AGENT;
    }

    @Override
    protected boolean isReusable() {
        return true;
    }

    @Override
    protected ClickHouseHttpResponse post(ClickHouseConfig config, String sql, ClickHouseInputStream data, List<ClickHouseExternalTable> tables, ClickHouseOutputStream output, String url, Map<String, String> headers, Runnable postCloseAction) throws IOException {
        HttpPost post = new HttpPost(url == null ? this.url : url);
        this.setHeaders(post, headers);
        byte[] boundary = null;
        String contentType = "text/plain; charset=UTF-8";
        if (tables != null && !tables.isEmpty()) {
            String uuid = this.rm.createUniqueId();
            contentType = "multipart/form-data; boundary=".concat(uuid);
            boundary = uuid.getBytes(StandardCharsets.US_ASCII);
        }
        post.setHeader("Content-Type", contentType);
        String contentEncoding = headers == null ? null : (String)headers.getOrDefault("content-encoding", null);
        ClickHouseHttpEntity postBody = new ClickHouseHttpEntity(config, contentType, contentEncoding, boundary, sql, data, tables);
        post.setEntity(postBody);
        CloseableHttpResponse response = null;
        int retryAttempts = config.getBoolOption(ClickHouseHttpOption.AHC_RETRY_ON_FAILURE) ? 2 : 1;
        for (int attempt = 0; attempt < retryAttempts; ++attempt) {
            boolean isLastAttempt = attempt == retryAttempts - 1;
            log.debug((Object)("HTTP request attempt " + attempt), new Object[0]);
            try {
                response = this.client.execute(post);
                if (isLastAttempt || response.getCode() != 503) break;
                log.debug((Object)"HTTP request failed with status code 503, retrying...", new Object[0]);
                continue;
            }
            catch (ConnectionClosedException | NoHttpResponseException e) {
                if (!isLastAttempt) continue;
                throw new ConnectException(e.getMessage());
            }
            catch (IOException e) {
                log.error((Object)"HTTP request failed", e);
                throw new ConnectException(e.getMessage());
            }
        }
        if (response == null) {
            throw new ConnectException("HTTP request failed");
        }
        this.checkResponse(config, response);
        return this.buildResponse(config, response, output, postCloseAction);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean ping(int timeout) {
        String url = this.getBaseUrl().concat("ping");
        HttpGet ping = new HttpGet(url);
        ClickHouseConfig c = this.config;
        try (CloseableHttpClient httpClient = this.newConnection(c);){
            boolean bl;
            block14: {
                CloseableHttpResponse response = httpClient.execute(ping);
                try {
                    this.checkResponse(c, response);
                    String ok = c.getStrOption(ClickHouseHttpOption.DEFAULT_RESPONSE);
                    bl = ok.equals(EntityUtils.toString(response.getEntity()));
                    if (response == null) break block14;
                }
                catch (Throwable throwable) {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                response.close();
            }
            return bl;
        }
        catch (Exception e) {
            log.debug((Object)"Failed to ping url %s due to: %s", url, e.getMessage());
            return false;
        }
    }

    @Override
    public void close() throws IOException {
        this.client.close();
    }

    static class ApacheHttpClientSocketFactory
    implements ClickHouseSocketFactory {
        static final ApacheHttpClientSocketFactory instance = new ApacheHttpClientSocketFactory();

        @Override
        public <T> T create(ClickHouseConfig config, Class<T> clazz) throws IOException, UnsupportedOperationException {
            if (config == null || clazz == null) {
                throw new IllegalArgumentException("Non-null configuration and class are required");
            }
            if (SSLConnectionSocketFactory.class.equals(clazz)) {
                return clazz.cast(new SSLSocketFactory(config));
            }
            if (PlainConnectionSocketFactory.class.equals(clazz)) {
                return clazz.cast(new SocketFactory(config));
            }
            throw new UnsupportedOperationException(ClickHouseUtils.format("Class %s is not supported", clazz));
        }

        @Override
        public boolean supports(Class<?> clazz) {
            return PlainConnectionSocketFactory.class.equals(clazz) || SSLConnectionSocketFactory.class.equals(clazz);
        }

        private ApacheHttpClientSocketFactory() {
        }
    }

    static class HttpConnectionManager
    extends PoolingHttpClientConnectionManager {
        private static final String PROVIDER = "Apache-HttpClient";
        private static final String USER_AGENT;

        public HttpConnectionManager(Registry<ConnectionSocketFactory> socketFactory, ClickHouseConfig config, PoolConcurrencyPolicy poolConcurrentcyPolicy, PoolReusePolicy poolReusePolicy, TimeValue ttl) {
            super(socketFactory, poolConcurrentcyPolicy, poolReusePolicy, ttl);
            int maxQueuedBuffers;
            int bufferSize;
            ConnectionConfig connConfig = ConnectionConfig.custom().setConnectTimeout(Timeout.of(config.getConnectionTimeout(), TimeUnit.MILLISECONDS)).setValidateAfterInactivity(config.getLongOption(ClickHouseHttpOption.AHC_VALIDATE_AFTER_INACTIVITY), TimeUnit.MILLISECONDS).build();
            this.setDefaultConnectionConfig(connConfig);
            SocketConfig.Builder builder = SocketConfig.custom().setSoTimeout(Timeout.of(config.getSocketTimeout(), TimeUnit.MILLISECONDS)).setRcvBufSize(config.getReadBufferSize()).setSndBufSize(config.getWriteBufferSize());
            if (config.hasOption(ClickHouseClientOption.SOCKET_KEEPALIVE)) {
                builder.setSoKeepAlive(config.getBoolOption(ClickHouseClientOption.SOCKET_KEEPALIVE));
            }
            if (config.hasOption(ClickHouseClientOption.SOCKET_LINGER)) {
                int solinger = config.getIntOption(ClickHouseClientOption.SOCKET_LINGER);
                builder.setSoLinger(solinger, TimeUnit.SECONDS);
            }
            if (config.hasOption(ClickHouseClientOption.SOCKET_REUSEADDR)) {
                builder.setSoReuseAddress(config.getBoolOption(ClickHouseClientOption.SOCKET_REUSEADDR));
            }
            if (config.hasOption(ClickHouseClientOption.SOCKET_TCP_NODELAY)) {
                builder.setTcpNoDelay(config.getBoolOption(ClickHouseClientOption.SOCKET_TCP_NODELAY));
            }
            if (config.getProxyType() == ClickHouseProxyType.SOCKS) {
                builder.setSocksProxyAddress(new InetSocketAddress(config.getProxyHost(), config.getProxyPort()));
            }
            if (config.hasOption(ClickHouseClientOption.SOCKET_RCVBUF)) {
                bufferSize = config.getIntOption(ClickHouseClientOption.SOCKET_RCVBUF);
                builder.setRcvBufSize(bufferSize > 0 ? bufferSize : config.getReadBufferSize());
            } else {
                bufferSize = config.getBufferSize();
                maxQueuedBuffers = config.getMaxQueuedBuffers();
                builder.setRcvBufSize(bufferSize * maxQueuedBuffers);
            }
            if (config.hasOption(ClickHouseClientOption.SOCKET_SNDBUF)) {
                bufferSize = config.getIntOption(ClickHouseClientOption.SOCKET_SNDBUF);
                builder.setSndBufSize(bufferSize > 0 ? bufferSize : config.getWriteBufferSize());
            } else {
                bufferSize = config.getBufferSize();
                maxQueuedBuffers = config.getMaxQueuedBuffers();
                builder.setSndBufSize(bufferSize * maxQueuedBuffers);
            }
            this.setDefaultSocketConfig(builder.build());
        }

        static {
            String versionInfo = null;
            try {
                String pkg = VersionInfo.class.getPackage().getName();
                pkg = pkg.substring(0, pkg.lastIndexOf(46));
                versionInfo = VersionInfo.getSoftwareInfo(PROVIDER, pkg, HttpClientBuilder.class).split("\\s")[0];
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            USER_AGENT = ClickHouseClientOption.buildUserAgent(null, versionInfo != null && !versionInfo.isEmpty() ? versionInfo : PROVIDER);
        }
    }

    static class SSLSocketFactory
    extends SSLConnectionSocketFactory {
        private final ClickHouseConfig config;

        private SSLSocketFactory(ClickHouseConfig config) throws SSLException {
            super(ClickHouseSslContextProvider.getProvider().getSslContext(SSLContext.class, config).orElse(SSLContexts.createDefault()), config.getSslMode() == ClickHouseSslMode.STRICT ? new DefaultHostnameVerifier() : (hostname, session) -> true);
            this.config = config;
        }

        @Override
        public Socket createSocket(HttpContext context) throws IOException {
            return AbstractSocketClient.setSocketOptions(this.config, new Socket());
        }

        public static SSLSocketFactory create(ClickHouseConfig config) throws SSLException {
            return new SSLSocketFactory(config);
        }
    }

    static class SocketFactory
    extends PlainConnectionSocketFactory {
        private final ClickHouseConfig config;

        private SocketFactory(ClickHouseConfig config) {
            this.config = config;
        }

        @Override
        public Socket createSocket(HttpContext context) throws IOException {
            return AbstractSocketClient.setSocketOptions(this.config, new Socket());
        }

        public static SocketFactory create(ClickHouseConfig config) {
            return new SocketFactory(config);
        }
    }
}

