/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.data.stream;

import com.clickhouse.data.ClickHouseByteUtils;
import com.clickhouse.data.ClickHouseChecker;
import com.clickhouse.data.ClickHouseCityHash;
import com.clickhouse.data.ClickHousePassThruStream;
import com.clickhouse.data.stream.AbstractByteArrayOutputStream;
import com.clickhouse.logging.Logger;
import com.clickhouse.logging.LoggerFactory;
import java.io.IOException;
import java.io.OutputStream;
import shaded.bytehouse.net.jpountz.lz4.LZ4Compressor;
import shaded.bytehouse.net.jpountz.lz4.LZ4Factory;

public class Lz4OutputStream
extends AbstractByteArrayOutputStream {
    private static final LZ4Factory factory = LZ4Factory.fastestInstance();
    private static final Logger log = LoggerFactory.getLogger(Lz4OutputStream.class);
    private final OutputStream output;
    private final LZ4Compressor compressor;
    private final byte[] compressedBlock;

    @Override
    protected void flushBuffer() throws IOException {
        log.debug((Object)"flushBuffer [{}:{}]", 0, this.position);
        if (this.position == 0) {
            log.debug((Object)"flushBuffer: nothing to flush", new Object[0]);
            return;
        }
        byte[] block = this.compressedBlock;
        block[16] = -126;
        int compressed = this.compressor.compress(this.buffer, 0, this.position, block, 25);
        int compressedSizeWithHeader = compressed + 9;
        ClickHouseByteUtils.setInt32(block, 17, compressedSizeWithHeader);
        ClickHouseByteUtils.setInt32(block, 21, this.position);
        long[] hash2 = ClickHouseCityHash.cityHash128(block, 16, compressedSizeWithHeader);
        ClickHouseByteUtils.setInt64(block, 0, hash2[0]);
        ClickHouseByteUtils.setInt64(block, 8, hash2[1]);
        this.output.write(block, 0, compressed + 25);
        this.position = 0;
    }

    @Override
    protected void flushBuffer(byte[] bytes, int offset, int length) throws IOException {
        log.debug((Object)"flushBuffer [{}:{}]", offset, length);
        int maxLen = this.compressor.maxCompressedLength(length) + 15;
        byte[] block = maxLen <= this.compressedBlock.length ? this.compressedBlock : new byte[maxLen];
        block[16] = -126;
        int compressed = this.compressor.compress(bytes, offset, length, block, 25);
        int compressedSizeWithHeader = compressed + 9;
        ClickHouseByteUtils.setInt32(block, 17, compressedSizeWithHeader);
        ClickHouseByteUtils.setInt32(block, 21, length);
        long[] hash2 = ClickHouseCityHash.cityHash128(block, 16, compressedSizeWithHeader);
        ClickHouseByteUtils.setInt64(block, 0, hash2[0]);
        ClickHouseByteUtils.setInt64(block, 8, hash2[1]);
        this.output.write(block, 0, compressed + 25);
    }

    public Lz4OutputStream(OutputStream out, int maxCompressBlockSize, Runnable postCloseAction) {
        this(null, out, -1, maxCompressBlockSize, postCloseAction);
    }

    public Lz4OutputStream(OutputStream out, int compressLevel, int maxCompressBlockSize, Runnable postCloseAction) {
        this(null, out, compressLevel, maxCompressBlockSize, postCloseAction);
    }

    public Lz4OutputStream(ClickHousePassThruStream stream, OutputStream out, int compressLevel, int maxCompressBlockSize, Runnable postCloseAction) {
        super(stream, maxCompressBlockSize, postCloseAction);
        this.output = ClickHouseChecker.nonNull(out, "OutputStream");
        this.compressor = compressLevel < 0 ? factory.fastCompressor() : factory.highCompressor(compressLevel);
        this.compressedBlock = new byte[this.compressor.maxCompressedLength(maxCompressBlockSize) + 15];
    }

    @Override
    public void flush() throws IOException {
        this.ensureOpen();
        if (this.position > 0) {
            this.flushBuffer();
        }
        this.output.flush();
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            try {
                super.close();
            }
            finally {
                this.output.close();
            }
        }
    }
}

