/*
 * Decompiled with CFR 0.152.
 */
package org.byted.security.zti.jwt.shaded.com.bytedance.commons.conf;

import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.byted.security.zti.jwt.shaded.com.bytedance.commons.consul.Discovery;
import org.byted.security.zti.jwt.shaded.com.google.common.base.Charsets;
import org.byted.security.zti.jwt.shaded.com.google.common.io.Files;
import org.byted.security.zti.jwt.shaded.org.slf4j.Logger;
import org.byted.security.zti.jwt.shaded.org.slf4j.LoggerFactory;

public class ParseConf {
    private static Logger logger = LoggerFactory.getLogger(Discovery.class);
    private static final String CONF_BASE_PATH = "/opt/tiger/ss_conf/ss/";
    private static final String LF = "lf";
    private static final String HY = "hy";
    private static Discovery discovery = new Discovery();
    private Map<String, String> conf = new HashMap<String, String>();

    public ParseConf(String fileName) {
        this.loadConfFile(fileName);
    }

    public List<String> getList(String name) {
        String value = this.getString(name);
        if (value != null) {
            List<String> res = Arrays.asList(this.conf.get(name).trim().split(","));
            return res;
        }
        return null;
    }

    public int getInt(String name) {
        int res = -1;
        try {
            if (this.conf.containsKey(name)) {
                res = Integer.parseInt(this.conf.get(name));
            }
        }
        catch (NumberFormatException e) {
            logger.error(e.toString());
        }
        return res;
    }

    public String getString(String name) {
        return this.getConfValue(name);
    }

    public long getLong(String name) {
        long res = -1L;
        try {
            if (this.conf.containsKey(name)) {
                res = Long.parseLong(this.conf.get(name));
            }
        }
        catch (NumberFormatException e) {
            logger.error(e.toString());
        }
        return res;
    }

    public Boolean getBoolean(String name) {
        String res = this.getConfValue(name);
        if (res != null && res.equals("true")) {
            return true;
        }
        return false;
    }

    public Map<String, String> getServerHosts(String name, String type) {
        HashMap<String, String> res = new HashMap<String, String>();
        for (String key : this.conf.keySet()) {
            if (!key.contains(name)) continue;
            if (type.equals("memcache") && !key.endsWith("use_proxy")) {
                res.put(key, this.conf.get(key));
            }
            if (type.equals("springdb") && key.endsWith("servers")) {
                res.put(key, this.conf.get(key));
            }
            if (!type.equals("table") || key.endsWith("table")) continue;
            res.put(key, this.conf.get(key));
        }
        return res;
    }

    public String getValueFromConsul(String key) {
        return discovery.translateUri(key);
    }

    private void loadConfFile(String confPath) {
        try {
            File confFile = new File(confPath);
            List<String> lines = Files.readLines(confFile, Charsets.UTF_8);
            HashMap<String, String> cacheKey = new HashMap<String, String>();
            for (String line : lines) {
                if (line.startsWith("#")) continue;
                int delimiterIdx = line.indexOf("#");
                if (delimiterIdx != -1) {
                    line = line.substring(0, delimiterIdx);
                }
                if (line.startsWith("include")) {
                    this.loadConfFile(CONF_BASE_PATH + line.split("\\s+")[1]);
                    continue;
                }
                int startSplit = line.indexOf(" ");
                if (startSplit == -1) continue;
                String key = line.substring(0, startSplit);
                String value = line.substring(startSplit + 1);
                if (value.contains("consul")) {
                    if (value.contains("dummy")) {
                        String[] dummyPart = value.substring(value.indexOf("?")).split("&");
                        HashMap<String, String> dcMap = new HashMap<String, String>();
                        for (String part : dummyPart) {
                            if ((part = part.substring(part.indexOf("{{") + 2, part.indexOf("}}"))).contains(LF)) {
                                dcMap.put(LF, part);
                            }
                            if (!part.contains(HY)) continue;
                            dcMap.put(HY, part);
                        }
                        if (ParseConf.discovery.dc.contains(LF)) {
                            cacheKey.put(key, (String)dcMap.get(LF));
                            continue;
                        }
                        if (!ParseConf.discovery.dc.contains(HY)) continue;
                        cacheKey.put(key, (String)dcMap.get(HY));
                        continue;
                    }
                    this.addKeyValue(key, value);
                    continue;
                }
                if (value.startsWith("{{") && value.endsWith("}}")) {
                    value = value.substring(2, value.length() - 2).trim();
                    cacheKey.put(key, value);
                }
                this.addKeyValue(key, value);
            }
            for (String key : cacheKey.keySet()) {
                this.addKeyValue(key, this.recursionCacheMap((String)cacheKey.get(key), cacheKey));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String recursionCacheMap(String key, Map<String, String> cacheMap) {
        if (!cacheMap.containsKey(key)) {
            return this.getConfValue(key);
        }
        return this.recursionCacheMap(cacheMap.get(key), cacheMap);
    }

    private void addKeyValue(String key, String value) {
        this.conf.put(key, value);
    }

    private String getConfValue(String key) {
        if (this.confHasKey(key)) {
            return this.conf.get(key);
        }
        return null;
    }

    private boolean confHasKey(String key) {
        return this.conf.containsKey(key);
    }
}

