/*
 * Decompiled with CFR 0.152.
 */
package org.byted.security.zti.jwt.shaded.com.bytedance.commons.consul;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.byted.security.zti.jwt.shaded.com.bytedance.commons.consul.Discovery;
import org.byted.security.zti.jwt.shaded.com.bytedance.commons.consul.RegisterParam;
import org.byted.security.zti.jwt.shaded.org.slf4j.Logger;
import org.byted.security.zti.jwt.shaded.org.slf4j.LoggerFactory;

public class Register {
    private static Logger logger = LoggerFactory.getLogger(Register.class);
    private static final AtomicBoolean STOPPED = new AtomicBoolean(false);
    private final ScheduledExecutorService executorService;
    private final Map<String, RegisterParam> services = new ConcurrentHashMap<String, RegisterParam>();
    private final Discovery discovery = new Discovery();

    public Register() {
        this(1);
    }

    public Register(int threadCount) {
        this.executorService = new ScheduledThreadPoolExecutor(threadCount, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread thread = new Thread(r);
                thread.setDaemon(true);
                thread.setName("org.byted.security.zti.jwt.shaded.com.bytedance.commons.consul.register");
                return thread;
            }
        });
    }

    public void defineService(String name, String addr, int port, int ttl, Map<String, String> tags) throws Exception {
        if (name == null || name.isEmpty() || port < 0 || port > 65535) {
            throw new Exception("invalid service");
        }
        if (ttl <= 10) {
            ttl = 120;
        }
        RegisterParam registerParam = this.discovery.defineService(name, addr, port, ttl, tags);
        String checkId = String.format("service:%s", registerParam.getId());
        this.services.put(checkId, registerParam);
    }

    public void setDualStack(boolean dualstack) {
        this.discovery.setRegisterDualStack(dualstack);
    }

    public void start() {
        STOPPED.set(false);
        for (String checkId : this.services.keySet()) {
            RegisterParam param = this.services.get(checkId);
            double dur = this.discovery.register(param);
            if (dur > 0.0) {
                int ttl = param.getCheck().getTtlInt();
                this.executorService.schedule(new TtlTask(checkId, ttl / 2), (long)(ttl / 2), TimeUnit.SECONDS);
                continue;
            }
            logger.error("SD: register {} failed", (Object)checkId);
        }
    }

    public void stop() {
        if (!STOPPED.compareAndSet(false, true)) {
            return;
        }
        this.executorService.shutdown();
        for (String checkId : this.services.keySet()) {
            RegisterParam param = this.services.get(checkId);
            this.discovery.deregister(param.getName(), param.getPort());
        }
    }

    class TtlTask
    implements Runnable {
        String checkId;
        int period;

        public TtlTask(String checkId, int period) {
            this.checkId = checkId;
            this.period = period;
        }

        @Override
        public void run() {
            if (STOPPED.get()) {
                return;
            }
            if (!Register.this.discovery.pass(this.checkId)) {
                logger.error("SD: pass {} failed", (Object)this.checkId);
            }
            Register.this.executorService.schedule(new TtlTask(this.checkId, this.period), (long)this.period, TimeUnit.SECONDS);
        }
    }
}

