/*
 * Decompiled with CFR 0.152.
 */
package org.byted.security.zti.jwt.shaded.com.bytedance.metrics;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Supplier;
import org.byted.security.zti.jwt.shaded.com.bytedance.apm.shade.jnr.constants.platform.Sock;
import org.byted.security.zti.jwt.shaded.com.bytedance.metrics.BytedanceMetricsReporter;
import org.byted.security.zti.jwt.shaded.com.bytedance.metrics.BytedanceMetricsV2Impl;
import org.byted.security.zti.jwt.shaded.com.bytedance.metrics.CallTracer;
import org.byted.security.zti.jwt.shaded.com.codahale.metrics.MetricRegistry;
import org.byted.security.zti.jwt.shaded.com.sun.istack.NotNull;
import org.byted.security.zti.jwt.shaded.com.sun.istack.Nullable;

public abstract class BytedanceMetricsV2 {
    private static final int REPORT_PERIOD_SECONDS = 10;

    public static ByteDanceMetricsBuilder newBuilder() {
        return new ByteDanceMetricsBuilder();
    }

    public abstract void emitGauge(@NotNull String var1, String var2, Function<Object, Long> var3);

    public abstract void emitCounterWithPID(@NotNull String var1, @NotNull long var2, @Nullable String var4);

    public abstract void emitCounter(@NotNull String var1, @NotNull long var2, @Nullable String var4);

    public abstract void emitTimerWithPID(@NotNull String var1, @NotNull long var2, @Nullable String var4);

    public abstract void emitTimerWithPID(@NotNull String var1, @NotNull long var2, @Nullable String var4, @Nullable TimeUnit var5);

    public abstract void emitTimerWithPID(@NotNull String var1, @NotNull long var2, @Nullable String var4, @Nullable TimeUnit var5, @NotNull int var6);

    public abstract void emitTimer(@NotNull String var1, @NotNull long var2, @Nullable String var4);

    public abstract void emitTimer(@NotNull String var1, @NotNull long var2, @Nullable String var4, @Nullable TimeUnit var5);

    public abstract void emitTimer(@NotNull String var1, @NotNull long var2, @Nullable String var4, @Nullable TimeUnit var5, @Nullable int var6);

    public abstract void emitHistogram(@NotNull String var1, @NotNull int var2);

    public abstract void emitHistogram(@NotNull String var1, @NotNull long var2);

    public abstract void emitHistogram(@NotNull String var1, @NotNull int var2, @Nullable int var3);

    public abstract void emitHistogram(@NotNull String var1, @NotNull long var2, @Nullable int var4);

    public abstract void getGaugeValue(@NotNull String var1, @NotNull Function<Object, Long> var2);

    public abstract void emitStore(String var1, double var2, long var4) throws IOException;

    public abstract Supplier<CallTracer> callTracer(String var1);

    public abstract Supplier<CallTracer> callTracer(String var1, String var2);

    public abstract boolean remove(String var1);

    public abstract void close();

    public static class ByteDanceMetricsBuilder {
        private String metricPrefix = "";
        private MetricRegistry registry;
        private BytedanceMetricsReporter reporter;
        private long ttlInMs;
        private boolean useUnixDomainSocket;
        private Sock sock;

        private ByteDanceMetricsBuilder() {
        }

        public ByteDanceMetricsBuilder setPrefix(String prefix) {
            this.metricPrefix = prefix;
            return this;
        }

        public ByteDanceMetricsBuilder setTllInMs(long ttlInMs) {
            this.ttlInMs = ttlInMs;
            return this;
        }

        public ByteDanceMetricsBuilder setUseUnixDomainSocket(boolean useUnixDomainSocket) {
            this.setUseUnixDomainSocket(useUnixDomainSocket, Sock.SOCK_DGRAM);
            return this;
        }

        public ByteDanceMetricsBuilder setUseUnixDomainSocket(boolean useUnixDomainSocket, Sock sock) {
            this.useUnixDomainSocket = useUnixDomainSocket;
            this.sock = sock;
            return this;
        }

        public ByteDanceMetricsBuilder setSock(Sock sock) {
            this.sock = sock;
            return this;
        }

        public BytedanceMetricsV2 build() {
            if (this.metricPrefix == null || this.metricPrefix.isEmpty()) {
                throw new IllegalArgumentException("null or empty metric prefix");
            }
            this.registry = new MetricRegistry();
            this.reporter = BytedanceMetricsReporter.forRegistry(this.registry).prefixedWith(this.metricPrefix).convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.MILLISECONDS).setUnixDomainSocket(this.useUnixDomainSocket).setSock(this.sock).build();
            this.reporter.start(10L, TimeUnit.SECONDS);
            return new BytedanceMetricsV2Impl(this.reporter, this.registry, this.ttlInMs);
        }
    }
}

