/*
 * Decompiled with CFR 0.152.
 */
package org.byted.security.zti.jwt.shaded.com.bytedance.metrics;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class MetricUtils {
    private static Map<String, String> vendorEnvTags = new HashMap<String, String>();

    public static Map<String, String> getVendorEnvTags() {
        if (MetricUtils.stringEmpty(vendorEnvTags.get("host"))) {
            MetricUtils.loadHostTag();
        }
        if (MetricUtils.stringEmpty(vendorEnvTags.get("pod_ip"))) {
            MetricUtils.loadPodIpTag();
        }
        return vendorEnvTags;
    }

    public static String ipv4ToHost(String ipv4) {
        if (MetricUtils.stringEmpty(ipv4)) {
            return "";
        }
        if (ipv4.startsWith("10.")) {
            String[] ips = ipv4.split("\\.");
            String hostName = String.format("n%s-%03d-%03d", ips[1], Integer.valueOf(ips[2]), Integer.valueOf(ips[3]));
            return hostName;
        }
        if (ipv4.startsWith("33.")) {
            String[] ips = ipv4.split("\\.");
            String hostName = String.format("p%s-%03d-%03d", ips[1], Integer.valueOf(ips[2]), Integer.valueOf(ips[3]));
            return hostName;
        }
        return ipv4;
    }

    public static String ipv6ToHost(String ipv6) {
        if (MetricUtils.stringEmpty(ipv6)) {
            return "";
        }
        List subStrings = Arrays.stream(ipv6.split(":")).filter(s2 -> !Objects.equals(s2, "")).collect(Collectors.toList());
        subStrings.remove("");
        if (subStrings.size() == 0 || !"fdbd".equals(subStrings.get(0)) || subStrings.size() < 5) {
            return ipv6;
        }
        if (subStrings.size() == 5) {
            return String.format("%s-p%s-t%s-n%03d", subStrings.get(1), subStrings.get(2), subStrings.get(3), Integer.valueOf((String)subStrings.get(subStrings.size() - 1)));
        }
        StringBuilder host = new StringBuilder();
        host.append(String.format("%s-p%s-", subStrings.get(1), subStrings.get(2)));
        for (int i = 3; i < subStrings.size(); ++i) {
            host.append((String)subStrings.get(i));
            host.append("-");
        }
        return host.substring(0, host.length() - 1);
    }

    public static boolean stringEmpty(String str) {
        return str == null || str.length() == 0;
    }

    private static void loadHostTag() {
        String hostName = System.getenv("HOSTNAME");
        if (hostName != null && (hostName.startsWith("dc") || hostName.startsWith("n") || hostName.startsWith("p"))) {
            vendorEnvTags.put("host", hostName);
            return;
        }
        String ipv4 = System.getenv("BYTED_HOST_IP");
        if (ipv4 != null) {
            vendorEnvTags.put("host", MetricUtils.ipv4ToHost(ipv4));
            return;
        }
        String ipv6 = System.getenv("BYTED_HOST_IPV6");
        if (ipv6 != null) {
            vendorEnvTags.put("host", MetricUtils.ipv6ToHost(ipv6));
        }
    }

    private static void loadPodIpTag() {
        String podIpv4 = System.getenv("MY_POD_IP");
        if (podIpv4 != null) {
            vendorEnvTags.put("pod_ip", podIpv4);
            return;
        }
        String podIpv6 = System.getenv("MY_POD_IPV6");
        if (podIpv6 != null) {
            vendorEnvTags.put("pod_ip", podIpv6);
        }
    }

    static {
        MetricUtils.loadHostTag();
        MetricUtils.loadPodIpTag();
    }
}

