/*
 * Decompiled with CFR 0.152.
 */
package org.byted.security.zti.jwt.shaded.com.bytedance.metrics;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.byted.security.zti.jwt.shaded.org.slf4j.Logger;
import org.byted.security.zti.jwt.shaded.org.slf4j.LoggerFactory;

public class TagParser {
    private static final Logger LOG;
    private static final String psmKey = "_psm";
    private static final String psmValue;
    private static final String deployStageKey = "deploy_stage";
    private static final String deployStageValue;
    private static final String dcKey = "dc";
    private static final String hostKey = "host";
    private static boolean[] validCharTable;
    private static final boolean[] tagValueSpecificValidCharTable;

    static ParsedMetricAndTags parse(String name) {
        int pos = name.indexOf(123);
        if (pos < 0) {
            TagParser.checkMetricName(name);
            return new ParsedMetricAndTags(name);
        }
        String metricName = name.substring(0, pos);
        TagParser.checkMetricName(metricName);
        ParsedMetricAndTags m4 = new ParsedMetricAndTags(metricName, new ArrayList<String>(), new ArrayList<String>());
        TagParser.parseTags(m4, name.substring(pos));
        return m4;
    }

    public static void parseTags(ParsedMetricAndTags m4, String tags) {
        String tagKey = null;
        String tagValue = null;
        int pos = 0;
        int rem = -1;
        while (pos < tags.length()) {
            char ch = tags.charAt(pos);
            if (ch == '{') {
                rem = ++pos;
                continue;
            }
            if (ch == '=') {
                if (rem == -1) {
                    throw new IllegalArgumentException(tags);
                }
                tagKey = tags.substring(rem, pos);
                rem = ++pos;
                continue;
            }
            if (ch == ',' || ch == '|') {
                if (rem == -1) {
                    throw new IllegalArgumentException(tags);
                }
                tagValue = tags.substring(rem, pos);
                m4.tagKeys.add(tagKey);
                m4.tagValues.add(tagValue);
                rem = ++pos;
                continue;
            }
            if (ch == '}') {
                if (rem == -1) {
                    throw new IllegalArgumentException(tags);
                }
                tagValue = tags.substring(rem, pos);
                m4.tagKeys.add(tagKey);
                m4.tagValues.add(tagValue);
                break;
            }
            if (TagParser.isInValidTagValueChar(ch)) {
                throw new IllegalArgumentException(tags);
            }
            ++pos;
        }
    }

    private static void checkMetricName(String name) {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException(name);
        }
        for (char ch : name.toCharArray()) {
            if (!TagParser.isInValidChar(ch)) continue;
            throw new IllegalArgumentException(name);
        }
    }

    public static boolean isInValidChar(char ch) {
        return ch > '\u007f' || !validCharTable[ch];
    }

    public static boolean isInValidTagValueChar(char ch) {
        return ch > '\u007f' || !validCharTable[ch] && !tagValueSpecificValidCharTable[ch];
    }

    static {
        int i;
        LOG = LoggerFactory.getLogger(TagParser.class);
        psmValue = System.getenv("TCE_PSM");
        deployStageValue = System.getenv("TCE_STAGE");
        validCharTable = new boolean[128];
        for (i = 48; i <= 57; ++i) {
            TagParser.validCharTable[i] = true;
        }
        for (i = 97; i <= 122; ++i) {
            TagParser.validCharTable[i] = true;
        }
        for (i = 65; i <= 90; ++i) {
            TagParser.validCharTable[i] = true;
        }
        TagParser.validCharTable[46] = true;
        TagParser.validCharTable[45] = true;
        TagParser.validCharTable[95] = true;
        TagParser.validCharTable[47] = true;
        TagParser.validCharTable[123] = true;
        TagParser.validCharTable[125] = true;
        TagParser.validCharTable[58] = true;
        TagParser.validCharTable[37] = true;
        tagValueSpecificValidCharTable = new boolean[128];
        TagParser.tagValueSpecificValidCharTable[32] = true;
        TagParser.tagValueSpecificValidCharTable[44] = true;
        TagParser.tagValueSpecificValidCharTable[91] = true;
        TagParser.tagValueSpecificValidCharTable[93] = true;
    }

    public static class ParsedMetricAndTags {
        final String metricName;
        final List<String> tagKeys;
        final List<String> tagValues;
        String builtTags = null;
        String kafkaTags = null;

        public ParsedMetricAndTags(String metricName) {
            this(metricName, Collections.emptyList(), Collections.emptyList());
        }

        public ParsedMetricAndTags(String metricName, List<String> tagKeys, List<String> tagValues) {
            this.metricName = metricName;
            this.tagKeys = tagKeys;
            this.tagValues = tagValues;
        }

        public String getMetricName() {
            return this.metricName;
        }

        public List<String> getTagKeys() {
            return this.tagKeys;
        }

        public List<String> getTagValues() {
            return this.tagValues;
        }

        public String buildTags() {
            if (this.builtTags != null) {
                return this.builtTags;
            }
            this.builtTags = this.buildTagsWithDelimiter('|', false, null, null);
            return this.builtTags;
        }

        public String buildKafkaTags(String host, String dc) {
            if (this.kafkaTags != null) {
                return this.kafkaTags;
            }
            this.kafkaTags = this.buildTagsWithDelimiter(' ', true, host, dc);
            return this.kafkaTags;
        }

        private String buildTagsWithDelimiter(char delimiter, boolean addTag, String host, String dc) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.tagKeys.size(); ++i) {
                this.appendPairs(sb, delimiter, this.tagKeys.get(i), this.tagValues.get(i));
            }
            if (addTag) {
                if (!this.tagKeys.contains(TagParser.hostKey)) {
                    this.appendPairs(sb, delimiter, TagParser.hostKey, host);
                }
                if (!this.tagKeys.contains(TagParser.dcKey)) {
                    this.appendPairs(sb, delimiter, TagParser.dcKey, dc);
                }
                if (!this.tagKeys.contains(TagParser.psmKey)) {
                    this.appendPairs(sb, delimiter, TagParser.psmKey, psmValue != null ? psmValue : "data.default.alert");
                }
                if (!this.tagKeys.contains(TagParser.deployStageKey)) {
                    this.appendPairs(sb, delimiter, TagParser.deployStageKey, deployStageValue);
                }
            }
            String tags = sb.toString();
            return tags;
        }

        private void appendPairs(StringBuilder sb, char delimiter, String key, String value) {
            if (sb.length() > 0) {
                sb.append(delimiter);
            }
            sb.append(key);
            sb.append('=');
            sb.append(value);
        }
    }
}

