/*
 * Decompiled with CFR 0.152.
 */
package org.byted.security.zti.jwt.shaded.com.bytedance.metrics.remote_writer;

import java.io.IOException;
import java.util.AbstractMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.byted.security.zti.jwt.shaded.com.bytedance.metrics.udpclient.MetricsClient;
import org.byted.security.zti.jwt.shaded.org.slf4j.Logger;
import org.byted.security.zti.jwt.shaded.org.slf4j.LoggerFactory;

public class MetricLooper {
    private static final Logger LOG = LoggerFactory.getLogger(MetricLooper.class);
    private static final String STATIC_PRODUCER_PREFIX = "inf.metrics4j.producer";
    private static final String METRIC_PREFIX_KEY = "metric_name_prefix";
    private final MetricsClient client = MetricsClient.get("inf.metrics4j.producer", false);
    private final String metricPrefix;
    private AtomicBoolean running;
    private ConcurrentHashMap<AbstractMap.SimpleEntry<String, String>, AtomicLong> metricMap;
    private final Thread emitThread;

    public MetricLooper(String metricPrefix) {
        this.metricPrefix = metricPrefix;
        this.metricMap = new ConcurrentHashMap();
        this.running = new AtomicBoolean(false);
        this.emitThread = new Thread(() -> this.emitMetrics());
        this.emitThread.setDaemon(true);
        this.emitThread.setName("emit metric thread");
        this.emitThread.start();
    }

    public AtomicLong defineCounter(String name, String ... tagkvs) {
        if (tagkvs.length == 0) {
            AbstractMap.SimpleEntry<String, String> pair = new AbstractMap.SimpleEntry<String, String>(name, "metric_name_prefix=" + this.metricPrefix);
            AtomicLong prev = this.metricMap.putIfAbsent(pair, new AtomicLong(0L));
            if (prev == null) {
                prev = this.metricMap.get(pair);
            }
            return prev;
        }
        if (tagkvs.length % 2 != 0) {
            return null;
        }
        TreeMap<String, String> kv_map = new TreeMap<String, String>();
        for (int i = 0; i < tagkvs.length; i += 2) {
            kv_map.put(tagkvs[i], tagkvs[i + 1]);
        }
        if (!kv_map.containsKey(METRIC_PREFIX_KEY)) {
            kv_map.put(METRIC_PREFIX_KEY, this.metricPrefix);
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry entry : kv_map.entrySet()) {
            if (sb.length() > 0) {
                sb.append('|');
            }
            sb.append((String)entry.getKey());
            sb.append('=');
            sb.append((String)entry.getValue());
        }
        AbstractMap.SimpleEntry<String, String> pair = new AbstractMap.SimpleEntry<String, String>(name, sb.toString());
        AtomicLong prev = this.metricMap.putIfAbsent(pair, new AtomicLong(0L));
        if (prev == null) {
            prev = this.metricMap.get(pair);
        }
        return prev;
    }

    private void emitMetrics() {
        this.running.set(true);
        while (this.running.get()) {
            block6: {
                try {
                    Thread.sleep(3000L);
                }
                catch (InterruptedException e) {
                    if (!LOG.isDebugEnabled()) break block6;
                    LOG.debug("The thread emit counter interrupt now");
                }
            }
            for (AbstractMap.SimpleEntry metric_tag : this.metricMap.keySet()) {
                AtomicLong res = this.metricMap.get(metric_tag);
                try {
                    this.client.emitStoreWithTag((String)metric_tag.getKey(), res.get(), (String)metric_tag.getValue());
                }
                catch (IOException e) {
                    LOG.warn("emit metric {} failed ", metric_tag.getKey());
                }
            }
        }
    }

    public void join() {
        this.running.set(false);
        this.emitThread.interrupt();
        try {
            this.emitThread.join();
        }
        catch (InterruptedException e) {
            LOG.warn("Running Emit interrupted ");
        }
    }
}

