/*
 * Decompiled with CFR 0.152.
 */
package org.byted.security.zti.jwt.shaded.com.bytedance.metrics.remote_writer;

import java.util.HashMap;
import java.util.Map;

public class Protocol {
    public static final Map<Short, ResponseStatusCode> shortToRespMap = new HashMap<Short, ResponseStatusCode>();
    public static final int RESPONSE_SIZE = 10;
    public static final int RESPONSE_OFFSET_CODE = 0;
    public static final int RESPONSE_OFFSET_COOKIE = 2;
    public static final int HEADER_SIZE_V1 = 20;
    public static final int HEADER_OFFSET_PROTOCOL_VERSION = 0;
    public static final int HEADER_OFFSET_COMPRESSION_CODEC = 2;
    public static final int HEADER_OFFSET_CONTENT_LENGTH = 4;
    public static final int HEADER_OFFSET_DECOMPRESSED_CONTENT_LENGTH = 8;
    public static final int HEADER_OFFSET_COOKIE = 12;
    public static final short PROTOCOL_VERSION = 1;
    public static final short COMPRESSION_CODEC = 0;
    public static final int MAX_CONTENT_LENGTH = 0x400000;
    public static final int MAX_DECOMPRESSED_CONTENT_LENGTH = 0x4000000;

    static {
        for (ResponseStatusCode code : ResponseStatusCode.values()) {
            shortToRespMap.put(code.code, code);
        }
    }

    public static class PacketResponse {
        final ResponseStatusCode code;
        final long cookie;

        public PacketResponse(ResponseStatusCode code, long cookie) {
            this.code = code;
            this.cookie = cookie;
        }
    }

    public static enum ProcessStatusCode {
        OK(0),
        PRODUCER_ERROR(1),
        REMOVE_FROM_QUEUE(2),
        PRODUCER_SOCK_OPEN_FAILED(3),
        PRODUCER_SOCK_CONN_FAILED(4),
        PRODUCER_SOCK_REG_FAILED(5),
        PRODUCER_COMPRESS_FAILED(6),
        PRODUCER_ENDPOINT_NULL(7),
        INPUT_EMPTY(8);

        short code;

        private ProcessStatusCode(int code) {
            this.code = (short)code;
        }
    }

    public static class PacketHeaderV1 {
        short protocolVersion;
        short compressionCodec;
        int contentLength;
        int decompressedContentLength;
        long cookie;
    }

    public static enum ResponseStatusCode {
        OK(1),
        CONTINUE(2),
        OUT_OF_MEMORY(100),
        SHUTTING_DOWN(101),
        RETRIABLE_ERROR(102),
        NON_RETRIABLE_ERROR(103),
        INCOMPATIBLE_PROTOCOL_VERSION(104),
        UNSUPPORT_COMPRESSION_CODEC(105),
        INVALID_CONTENT_LENGTH(106),
        INVALID_DECOMPRESSED_CONTENT_LENGTH(107);

        short code;

        private ResponseStatusCode(int code) {
            this.code = (short)code;
        }
    }
}

