/*
 * Decompiled with CFR 0.152.
 */
package org.byted.security.zti.jwt.shaded.com.bytedance.metrics.simple.sender;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.byted.security.zti.jwt.shaded.com.bytedance.apm.shade.jnr.constants.platform.Sock;
import org.byted.security.zti.jwt.shaded.com.bytedance.metrics.simple.sender.Command;
import org.byted.security.zti.jwt.shaded.com.bytedance.metrics.simple.sender.Sender;
import org.byted.security.zti.jwt.shaded.com.bytedance.metrics.udpclient.MetricsClient;

public class UdpSender
implements Sender {
    private static final int batch = 10;
    private final MetricsClient metricsClient;

    public UdpSender() {
        this(false, Sock.SOCK_DGRAM);
    }

    public UdpSender(boolean useDomainSock, Sock sock) {
        this.metricsClient = MetricsClient.get("", useDomainSock, sock);
    }

    @Override
    public void send(Command ... commands) throws IOException {
        for (int i = 0; i < commands.length; i += 10) {
            ByteBuffer buf = UdpSender.encode(commands, i, Math.min(commands.length - i, 10));
            this.metricsClient.emit(buf);
        }
    }

    private static ByteBuffer encode(Command[] commands, int offset, int length) {
        int estimateSize = 1;
        for (int i = 0; i < length; ++i) {
            Command cmd = commands[offset + i];
            ++estimateSize;
            for (byte[] s2 : cmd.asBytesArray()) {
                estimateSize += 5 + s2.length;
            }
        }
        ByteBuffer out = ByteBuffer.allocate(estimateSize);
        MetricsClient.writeMsgpackArrayHead(out, length);
        for (int i = 0; i < length; ++i) {
            Command cmd = commands[offset + i];
            MetricsClient.writeMsgpackArrayHead(out, 6);
            for (byte[] s3 : cmd.asBytesArray()) {
                MetricsClient.writeMsgpackStringBytes(out, s3);
            }
        }
        out.flip();
        return out;
    }
}

