/*
 * Decompiled with CFR 0.152.
 */
package org.byted.security.zti.jwt.shaded.com.bytedance.metrics.udpclient;

import java.io.File;
import java.io.IOException;
import java.net.SocketAddress;
import java.net.SocketOption;
import java.nio.ByteBuffer;
import org.byted.security.zti.jwt.shaded.com.bytedance.apm.shade.jnr.unixsocket.UnixDatagramChannel;
import org.byted.security.zti.jwt.shaded.com.bytedance.apm.shade.jnr.unixsocket.UnixSocketAddress;
import org.byted.security.zti.jwt.shaded.com.bytedance.apm.shade.jnr.unixsocket.UnixSocketOptions;
import org.byted.security.zti.jwt.shaded.com.bytedance.metrics.udpclient.BaseUnixClient;
import org.byted.security.zti.jwt.shaded.org.slf4j.Logger;
import org.byted.security.zti.jwt.shaded.org.slf4j.LoggerFactory;

public class UnixMetricsClient
extends BaseUnixClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(UnixMetricsClient.class);
    private static final String NODE_SOCK_PATH = "/opt/tmp/sock/metric.sock";
    private static final String SIDECAR_SOCK_PATH = "/sidecar/sock/metric.sock";
    private final SocketAddress address = new UnixSocketAddress(new File(UnixMetricsClient.loadUnixSockPath("/opt/tmp/sock/metric.sock", "/sidecar/sock/metric.sock")));
    private UnixDatagramChannel unixDatagramChannel = UnixDatagramChannel.open();

    public UnixMetricsClient(String prefix) throws IOException {
        super(prefix);
        this.unixDatagramChannel.setOption((SocketOption)UnixSocketOptions.SO_SNDTIMEO, (Object)100);
        this.connect();
        Runtime.getRuntime().addShutdownHook(new BaseUnixClient.ShutdownHook(this));
    }

    @Override
    public void emit(ByteBuffer buffer) {
        for (int attemptNumber = 0; attemptNumber < 3; ++attemptNumber) {
            try {
                if (!this.waitForConnected(100L)) continue;
                this.unixDatagramChannel.send(buffer, this.address);
                break;
            }
            catch (IOException exception) {
                LOGGER.warn("write data to unix domain socket exception, buffer length:{}, attemptNumber:{}", buffer.limit(), attemptNumber, exception);
                if ("Message too long".equals(exception.getMessage())) break;
                this.channelStatus.set(BaseUnixClient.ChannelStatus.Disconnected);
            }
        }
    }

    @Override
    public boolean isConnected() {
        return ((BaseUnixClient.ChannelStatus)((Object)this.channelStatus.get())).equals((Object)BaseUnixClient.ChannelStatus.Connected) && this.unixDatagramChannel.isConnected();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connect() {
        Object object = this.lock;
        synchronized (object) {
            try {
                this.unixDatagramChannel.connect(this.address);
                this.channelStatus.set(BaseUnixClient.ChannelStatus.Connected);
            }
            catch (IOException exception) {
                LOGGER.warn("connect to agent failed:", exception);
                this.channelStatus.compareAndSet(BaseUnixClient.ChannelStatus.Uninitialized, BaseUnixClient.ChannelStatus.Disconnected);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reConnect() throws IOException {
        if (this.isConnected()) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.isConnected()) {
                return;
            }
            this.unixDatagramChannel.close();
            this.unixDatagramChannel = UnixDatagramChannel.open();
            this.unixDatagramChannel.setOption((SocketOption)UnixSocketOptions.SO_SNDTIMEO, (Object)100);
            this.unixDatagramChannel.connect(this.address);
            this.channelStatus.set(BaseUnixClient.ChannelStatus.Connected);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (!((BaseUnixClient.ChannelStatus)((Object)this.channelStatus.get())).equals((Object)BaseUnixClient.ChannelStatus.Closed)) {
            Object object = this.lock;
            synchronized (object) {
                if (!((BaseUnixClient.ChannelStatus)((Object)this.channelStatus.get())).equals((Object)BaseUnixClient.ChannelStatus.Closed)) {
                    if (this.unixDatagramChannel != null) {
                        this.unixDatagramChannel.close();
                    }
                    this.channelStatus.set(BaseUnixClient.ChannelStatus.Closed);
                }
            }
        }
    }
}

