/*
 * Decompiled with CFR 0.152.
 */
package org.byted.security.zti.jwt.shaded.io.grpc.internal;

import org.byted.security.zti.jwt.shaded.com.google.common.annotations.VisibleForTesting;
import org.byted.security.zti.jwt.shaded.com.google.common.base.Preconditions;
import org.byted.security.zti.jwt.shaded.io.grpc.ClientStreamTracer;
import org.byted.security.zti.jwt.shaded.io.grpc.Metadata;
import org.byted.security.zti.jwt.shaded.io.grpc.Status;
import org.byted.security.zti.jwt.shaded.io.grpc.internal.ClientStreamListener;
import org.byted.security.zti.jwt.shaded.io.grpc.internal.InsightBuilder;
import org.byted.security.zti.jwt.shaded.io.grpc.internal.NoopClientStream;

public final class FailingClientStream
extends NoopClientStream {
    private boolean started;
    private final Status error;
    private final ClientStreamListener.RpcProgress rpcProgress;
    private final ClientStreamTracer[] tracers;

    public FailingClientStream(Status error, ClientStreamTracer[] tracers) {
        this(error, ClientStreamListener.RpcProgress.PROCESSED, tracers);
    }

    public FailingClientStream(Status error, ClientStreamListener.RpcProgress rpcProgress, ClientStreamTracer[] tracers) {
        Preconditions.checkArgument(!error.isOk(), "error must not be OK");
        this.error = error;
        this.rpcProgress = rpcProgress;
        this.tracers = tracers;
    }

    @Override
    public void start(ClientStreamListener listener) {
        Preconditions.checkState(!this.started, "already started");
        this.started = true;
        for (ClientStreamTracer tracer : this.tracers) {
            tracer.streamClosed(this.error);
        }
        listener.closed(this.error, this.rpcProgress, new Metadata());
    }

    @VisibleForTesting
    Status getError() {
        return this.error;
    }

    @Override
    public void appendTimeoutInsight(InsightBuilder insight) {
        insight.appendKeyValue("error", this.error).appendKeyValue("progress", (Object)this.rpcProgress);
    }
}

