/*
 * Decompiled with CFR 0.152.
 */
package org.byted.security.zti.jwt.shaded.io.grpc.internal;

import java.util.IdentityHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.byted.security.zti.jwt.shaded.com.google.common.base.Preconditions;
import org.byted.security.zti.jwt.shaded.io.grpc.internal.GrpcUtil;
import org.byted.security.zti.jwt.shaded.io.grpc.internal.LogExceptionRunnable;
import org.byted.security.zti.jwt.shaded.javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class SharedResourceHolder {
    static final long DESTROY_DELAY_SECONDS = 1L;
    private static final SharedResourceHolder holder = new SharedResourceHolder(new ScheduledExecutorFactory(){

        @Override
        public ScheduledExecutorService createScheduledExecutor() {
            return Executors.newSingleThreadScheduledExecutor(GrpcUtil.getThreadFactory("grpc-shared-destroyer-%d", true));
        }
    });
    private final IdentityHashMap<Resource<?>, Instance> instances = new IdentityHashMap();
    private final ScheduledExecutorFactory destroyerFactory;
    private ScheduledExecutorService destroyer;

    SharedResourceHolder(ScheduledExecutorFactory destroyerFactory) {
        this.destroyerFactory = destroyerFactory;
    }

    public static <T> T get(Resource<T> resource) {
        return holder.getInternal(resource);
    }

    public static <T> T release(Resource<T> resource, T instance2) {
        return holder.releaseInternal(resource, instance2);
    }

    synchronized <T> T getInternal(Resource<T> resource) {
        Instance instance2 = this.instances.get(resource);
        if (instance2 == null) {
            instance2 = new Instance(resource.create());
            this.instances.put(resource, instance2);
        }
        if (instance2.destroyTask != null) {
            instance2.destroyTask.cancel(false);
            instance2.destroyTask = null;
        }
        ++instance2.refcount;
        return (T)instance2.payload;
    }

    synchronized <T> T releaseInternal(final Resource<T> resource, final T instance2) {
        final Instance cached = this.instances.get(resource);
        if (cached == null) {
            throw new IllegalArgumentException("No cached instance found for " + resource);
        }
        Preconditions.checkArgument(instance2 == cached.payload, "Releasing the wrong instance");
        Preconditions.checkState(cached.refcount > 0, "Refcount has already reached zero");
        --cached.refcount;
        if (cached.refcount == 0) {
            Preconditions.checkState(cached.destroyTask == null, "Destroy task already scheduled");
            if (this.destroyer == null) {
                this.destroyer = this.destroyerFactory.createScheduledExecutor();
            }
            cached.destroyTask = this.destroyer.schedule(new LogExceptionRunnable(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    SharedResourceHolder sharedResourceHolder = SharedResourceHolder.this;
                    synchronized (sharedResourceHolder) {
                        if (cached.refcount == 0) {
                            try {
                                resource.close(instance2);
                            }
                            finally {
                                SharedResourceHolder.this.instances.remove(resource);
                                if (SharedResourceHolder.this.instances.isEmpty()) {
                                    SharedResourceHolder.this.destroyer.shutdown();
                                    SharedResourceHolder.this.destroyer = null;
                                }
                            }
                        }
                    }
                }
            }), 1L, TimeUnit.SECONDS);
        }
        return null;
    }

    private static class Instance {
        final Object payload;
        int refcount;
        ScheduledFuture<?> destroyTask;

        Instance(Object payload) {
            this.payload = payload;
        }
    }

    static interface ScheduledExecutorFactory {
        public ScheduledExecutorService createScheduledExecutor();
    }

    public static interface Resource<T> {
        public T create();

        public void close(T var1);
    }
}

