/*
 * Decompiled with CFR 0.152.
 */
package org.byted.security.zti.jwt.shaded.io.grpc.netty.shaded.io.netty.handler.address;

import java.net.SocketAddress;
import org.byted.security.zti.jwt.shaded.io.grpc.netty.shaded.io.netty.channel.ChannelHandler;
import org.byted.security.zti.jwt.shaded.io.grpc.netty.shaded.io.netty.channel.ChannelHandlerContext;
import org.byted.security.zti.jwt.shaded.io.grpc.netty.shaded.io.netty.channel.ChannelOutboundHandlerAdapter;
import org.byted.security.zti.jwt.shaded.io.grpc.netty.shaded.io.netty.channel.ChannelPromise;
import org.byted.security.zti.jwt.shaded.io.grpc.netty.shaded.io.netty.resolver.AddressResolver;
import org.byted.security.zti.jwt.shaded.io.grpc.netty.shaded.io.netty.resolver.AddressResolverGroup;
import org.byted.security.zti.jwt.shaded.io.grpc.netty.shaded.io.netty.util.concurrent.Future;
import org.byted.security.zti.jwt.shaded.io.grpc.netty.shaded.io.netty.util.concurrent.FutureListener;
import org.byted.security.zti.jwt.shaded.io.grpc.netty.shaded.io.netty.util.concurrent.GenericFutureListener;
import org.byted.security.zti.jwt.shaded.io.grpc.netty.shaded.io.netty.util.internal.ObjectUtil;

@ChannelHandler.Sharable
public class ResolveAddressHandler
extends ChannelOutboundHandlerAdapter {
    private final AddressResolverGroup<? extends SocketAddress> resolverGroup;

    public ResolveAddressHandler(AddressResolverGroup<? extends SocketAddress> resolverGroup) {
        this.resolverGroup = ObjectUtil.checkNotNull(resolverGroup, "resolverGroup");
    }

    @Override
    public void connect(final ChannelHandlerContext ctx, SocketAddress remoteAddress, final SocketAddress localAddress, final ChannelPromise promise) {
        AddressResolver<? extends SocketAddress> resolver = this.resolverGroup.getResolver(ctx.executor());
        if (resolver.isSupported(remoteAddress) && !resolver.isResolved(remoteAddress)) {
            resolver.resolve(remoteAddress).addListener((GenericFutureListener<Future<? extends SocketAddress>>)new FutureListener<SocketAddress>(){

                @Override
                public void operationComplete(Future<SocketAddress> future) {
                    Throwable cause = future.cause();
                    if (cause != null) {
                        promise.setFailure(cause);
                    } else {
                        ctx.connect(future.getNow(), localAddress, promise);
                    }
                    ctx.pipeline().remove(ResolveAddressHandler.this);
                }
            });
        } else {
            ctx.connect(remoteAddress, localAddress, promise);
            ctx.pipeline().remove(this);
        }
    }
}

