/*
 * Decompiled with CFR 0.152.
 */
package org.byted.security.zti.jwt.shaded.io.spiffe.bundle.jwtbundle;

import java.io.IOException;
import java.nio.file.Path;
import java.security.KeyException;
import java.security.PublicKey;
import java.text.ParseException;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.byted.security.zti.jwt.shaded.com.nimbusds.jose.JOSEException;
import org.byted.security.zti.jwt.shaded.com.nimbusds.jose.jwk.ECKey;
import org.byted.security.zti.jwt.shaded.com.nimbusds.jose.jwk.JWK;
import org.byted.security.zti.jwt.shaded.com.nimbusds.jose.jwk.JWKSet;
import org.byted.security.zti.jwt.shaded.com.nimbusds.jose.jwk.RSAKey;
import org.byted.security.zti.jwt.shaded.io.spiffe.bundle.BundleSource;
import org.byted.security.zti.jwt.shaded.io.spiffe.exception.AuthorityNotFoundException;
import org.byted.security.zti.jwt.shaded.io.spiffe.exception.BundleNotFoundException;
import org.byted.security.zti.jwt.shaded.io.spiffe.exception.JwtBundleException;
import org.byted.security.zti.jwt.shaded.io.spiffe.internal.JwtSignatureAlgorithm;
import org.byted.security.zti.jwt.shaded.io.spiffe.spiffeid.TrustDomain;
import org.byted.security.zti.jwt.shaded.org.apache.commons.lang3.StringUtils;
import shaded.bytehouse.lombok.Generated;
import shaded.bytehouse.lombok.NonNull;

public final class JwtBundle
implements BundleSource<JwtBundle> {
    private final TrustDomain trustDomain;
    private final Map<String, PublicKey> jwtAuthorities;

    public JwtBundle(@NonNull TrustDomain trustDomain) {
        if (trustDomain == null) {
            throw new NullPointerException("trustDomain is marked non-null but is null");
        }
        this.trustDomain = trustDomain;
        this.jwtAuthorities = new ConcurrentHashMap<String, PublicKey>();
    }

    public JwtBundle(@NonNull TrustDomain trustDomain, @NonNull Map<String, PublicKey> jwtAuthorities) {
        if (trustDomain == null) {
            throw new NullPointerException("trustDomain is marked non-null but is null");
        }
        if (jwtAuthorities == null) {
            throw new NullPointerException("jwtAuthorities is marked non-null but is null");
        }
        this.trustDomain = trustDomain;
        this.jwtAuthorities = new ConcurrentHashMap<String, PublicKey>(jwtAuthorities);
    }

    public static JwtBundle load(@NonNull TrustDomain trustDomain, @NonNull Path bundlePath) throws KeyException, JwtBundleException {
        if (trustDomain == null) {
            throw new NullPointerException("trustDomain is marked non-null but is null");
        }
        if (bundlePath == null) {
            throw new NullPointerException("bundlePath is marked non-null but is null");
        }
        try {
            JWKSet jwkSet = JWKSet.load(bundlePath.toFile());
            return JwtBundle.toJwtBundle(trustDomain, jwkSet);
        }
        catch (IOException | IllegalArgumentException | ParseException | JOSEException e) {
            String error = "Could not load bundle from file: %s";
            throw new JwtBundleException(String.format("Could not load bundle from file: %s", bundlePath.toString()), e);
        }
    }

    public static JwtBundle parse(@NonNull TrustDomain trustDomain, @NonNull byte[] bundleBytes) throws JwtBundleException {
        if (trustDomain == null) {
            throw new NullPointerException("trustDomain is marked non-null but is null");
        }
        if (bundleBytes == null) {
            throw new NullPointerException("bundleBytes is marked non-null but is null");
        }
        try {
            JWKSet jwkSet = JWKSet.parse(new String(bundleBytes));
            return JwtBundle.toJwtBundle(trustDomain, jwkSet);
        }
        catch (KeyException | ParseException | JOSEException e) {
            throw new JwtBundleException("Could not parse bundle from bytes", e);
        }
    }

    @Override
    public JwtBundle getBundleForTrustDomain(TrustDomain trustDomain) throws BundleNotFoundException {
        if (this.trustDomain.equals(trustDomain)) {
            return this;
        }
        throw new BundleNotFoundException(String.format("No JWT bundle found for trust domain %s", trustDomain));
    }

    public Map<String, PublicKey> getJwtAuthorities() {
        return Collections.unmodifiableMap(this.jwtAuthorities);
    }

    public PublicKey findJwtAuthority(String keyId) throws AuthorityNotFoundException {
        PublicKey key = this.jwtAuthorities.get(keyId);
        if (key != null) {
            return key;
        }
        throw new AuthorityNotFoundException(String.format("No authority found for the trust domain %s and key id %s", this.trustDomain, keyId));
    }

    public boolean hasJwtAuthority(String keyId) {
        return this.jwtAuthorities.containsKey(keyId);
    }

    public void putJwtAuthority(@NonNull String keyId, @NonNull PublicKey jwtAuthority) {
        if (keyId == null) {
            throw new NullPointerException("keyId is marked non-null but is null");
        }
        if (jwtAuthority == null) {
            throw new NullPointerException("jwtAuthority is marked non-null but is null");
        }
        if (StringUtils.isBlank(keyId)) {
            throw new IllegalArgumentException("KeyId cannot be empty");
        }
        this.jwtAuthorities.put(keyId, jwtAuthority);
    }

    public void removeJwtAuthority(String keyId) {
        this.jwtAuthorities.remove(keyId);
    }

    private static JwtBundle toJwtBundle(TrustDomain trustDomain, JWKSet jwkSet) throws JwtBundleException, JOSEException, ParseException, KeyException {
        ConcurrentHashMap<String, PublicKey> authorities = new ConcurrentHashMap<String, PublicKey>();
        for (JWK jwk : jwkSet.getKeys()) {
            String keyId = JwtBundle.getKeyId(jwk);
            PublicKey publicKey = JwtBundle.getPublicKey(jwk);
            authorities.put(keyId, publicKey);
        }
        return new JwtBundle(trustDomain, authorities);
    }

    private static String getKeyId(JWK jwk) throws JwtBundleException {
        String keyId = jwk.getKeyID();
        if (StringUtils.isBlank(keyId)) {
            throw new JwtBundleException("Error adding authority of JWKS: keyID cannot be empty");
        }
        return keyId;
    }

    private static PublicKey getPublicKey(JWK jwk) throws JOSEException, ParseException, KeyException {
        PublicKey publicKey;
        JwtSignatureAlgorithm.Family family = JwtSignatureAlgorithm.Family.parse(jwk.getKeyType().getValue());
        switch (family) {
            case EC: {
                publicKey = ECKey.parse(jwk.toJSONString()).toPublicKey();
                break;
            }
            case RSA: {
                publicKey = RSAKey.parse(jwk.toJSONString()).toPublicKey();
                break;
            }
            default: {
                throw new KeyException(String.format("Key Type not supported: %s", jwk.getKeyType().getValue()));
            }
        }
        return publicKey;
    }

    @Generated
    public TrustDomain getTrustDomain() {
        return this.trustDomain;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JwtBundle)) {
            return false;
        }
        JwtBundle other = (JwtBundle)o;
        TrustDomain this$trustDomain = this.getTrustDomain();
        TrustDomain other$trustDomain = other.getTrustDomain();
        if (this$trustDomain == null ? other$trustDomain != null : !((Object)this$trustDomain).equals(other$trustDomain)) {
            return false;
        }
        Map<String, PublicKey> this$jwtAuthorities = this.getJwtAuthorities();
        Map<String, PublicKey> other$jwtAuthorities = other.getJwtAuthorities();
        return !(this$jwtAuthorities == null ? other$jwtAuthorities != null : !((Object)this$jwtAuthorities).equals(other$jwtAuthorities));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        TrustDomain $trustDomain = this.getTrustDomain();
        result = result * 59 + ($trustDomain == null ? 43 : ((Object)$trustDomain).hashCode());
        Map<String, PublicKey> $jwtAuthorities = this.getJwtAuthorities();
        result = result * 59 + ($jwtAuthorities == null ? 43 : ((Object)$jwtAuthorities).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "JwtBundle(trustDomain=" + this.getTrustDomain() + ", jwtAuthorities=" + this.getJwtAuthorities() + ")";
    }
}

