/*
 * Decompiled with CFR 0.152.
 */
package org.byted.security.zti.jwt.shaded.io.spiffe.spiffeid;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.byted.security.zti.jwt.shaded.com.google.common.collect.Sets;
import org.byted.security.zti.jwt.shaded.io.spiffe.spiffeid.SpiffeId;
import org.byted.security.zti.jwt.shaded.org.apache.commons.lang3.StringUtils;

public final class SpiffeIdUtils {
    private static final char DEFAULT_CHAR_SEPARATOR = '|';
    private static final Set<Character> SUPPORTED_SEPARATORS = Sets.newHashSet(Character.valueOf('|'), Character.valueOf(' '));

    private SpiffeIdUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static Set<SpiffeId> getSpiffeIdSetFromFile(Path spiffeIdsFile) throws IOException {
        try (Stream<String> lines = Files.lines(spiffeIdsFile);){
            Set<SpiffeId> set = lines.map(SpiffeId::parse).collect(Collectors.toSet());
            return set;
        }
    }

    public static Set<SpiffeId> toSetOfSpiffeIds(String spiffeIds, char separator) {
        if (StringUtils.isBlank(spiffeIds)) {
            return Collections.emptySet();
        }
        if (!SUPPORTED_SEPARATORS.contains(Character.valueOf(separator))) {
            throw new IllegalArgumentException("Separator character is not supported.");
        }
        String[] array = SpiffeIdUtils.parseArray(spiffeIds, separator);
        return Arrays.stream(array).map(SpiffeId::parse).collect(Collectors.toSet());
    }

    public static Set<SpiffeId> toSetOfSpiffeIds(String spiffeIds) {
        return SpiffeIdUtils.toSetOfSpiffeIds(spiffeIds, '|');
    }

    private static String[] parseArray(String spiffeIds, char separator) {
        String regex = Pattern.quote(String.valueOf(separator));
        return spiffeIds.trim().split(regex);
    }
}

