/*
 * Decompiled with CFR 0.152.
 */
package org.byted.security.zti.jwt.shaded.io.spiffe.workloadapi;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.byted.security.zti.jwt.shaded.io.grpc.Context;
import org.byted.security.zti.jwt.shaded.io.grpc.stub.StreamObserver;
import org.byted.security.zti.jwt.shaded.io.spiffe.bundle.jwtbundle.JwtBundleSet;
import org.byted.security.zti.jwt.shaded.io.spiffe.bundle.x509bundle.X509BundleSet;
import org.byted.security.zti.jwt.shaded.io.spiffe.exception.JwtBundleException;
import org.byted.security.zti.jwt.shaded.io.spiffe.exception.JwtSvidException;
import org.byted.security.zti.jwt.shaded.io.spiffe.exception.SocketEndpointAddressException;
import org.byted.security.zti.jwt.shaded.io.spiffe.exception.X509BundleException;
import org.byted.security.zti.jwt.shaded.io.spiffe.exception.X509ContextException;
import org.byted.security.zti.jwt.shaded.io.spiffe.spiffeid.SpiffeId;
import org.byted.security.zti.jwt.shaded.io.spiffe.svid.jwtsvid.JwtSvid;
import org.byted.security.zti.jwt.shaded.io.spiffe.workloadapi.Address;
import org.byted.security.zti.jwt.shaded.io.spiffe.workloadapi.GrpcConversionUtils;
import org.byted.security.zti.jwt.shaded.io.spiffe.workloadapi.StreamObservers;
import org.byted.security.zti.jwt.shaded.io.spiffe.workloadapi.Watcher;
import org.byted.security.zti.jwt.shaded.io.spiffe.workloadapi.WorkloadApiClient;
import org.byted.security.zti.jwt.shaded.io.spiffe.workloadapi.X509Context;
import org.byted.security.zti.jwt.shaded.io.spiffe.workloadapi.grpc.SpiffeWorkloadAPIGrpc;
import org.byted.security.zti.jwt.shaded.io.spiffe.workloadapi.grpc.Workload;
import org.byted.security.zti.jwt.shaded.io.spiffe.workloadapi.internal.GrpcManagedChannelFactory;
import org.byted.security.zti.jwt.shaded.io.spiffe.workloadapi.internal.ManagedChannelWrapper;
import org.byted.security.zti.jwt.shaded.io.spiffe.workloadapi.internal.SecurityHeaderInterceptor;
import org.byted.security.zti.jwt.shaded.io.spiffe.workloadapi.retry.ExponentialBackoffPolicy;
import org.byted.security.zti.jwt.shaded.io.spiffe.workloadapi.retry.RetryHandler;
import org.byted.security.zti.jwt.shaded.org.apache.commons.lang3.StringUtils;
import shaded.bytehouse.lombok.Generated;
import shaded.bytehouse.lombok.NonNull;

public final class DefaultWorkloadApiClient
implements WorkloadApiClient {
    @Generated
    private static final Logger log = Logger.getLogger(DefaultWorkloadApiClient.class.getName());
    private final SpiffeWorkloadAPIGrpc.SpiffeWorkloadAPIStub workloadApiAsyncStub;
    private final SpiffeWorkloadAPIGrpc.SpiffeWorkloadAPIBlockingStub workloadApiBlockingStub;
    private final ManagedChannelWrapper managedChannel;
    private final List<Context.CancellableContext> cancellableContexts;
    private final ExponentialBackoffPolicy exponentialBackoffPolicy;
    private final ScheduledExecutorService retryExecutor;
    private final ExecutorService executorService;
    private static final ThreadFactory daemonThreadFactory = new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            Thread t2 = Executors.defaultThreadFactory().newThread(r);
            t2.setDaemon(true);
            return t2;
        }
    };
    private volatile boolean closed;

    private DefaultWorkloadApiClient(SpiffeWorkloadAPIGrpc.SpiffeWorkloadAPIStub workloadApiAsyncStub, SpiffeWorkloadAPIGrpc.SpiffeWorkloadAPIBlockingStub workloadApiBlockingStub, ManagedChannelWrapper managedChannel, ExponentialBackoffPolicy exponentialBackoffPolicy, ScheduledExecutorService retryExecutor, ExecutorService executorService) {
        this.workloadApiAsyncStub = workloadApiAsyncStub;
        this.workloadApiBlockingStub = workloadApiBlockingStub;
        this.managedChannel = managedChannel;
        this.cancellableContexts = Collections.synchronizedList(new ArrayList());
        this.exponentialBackoffPolicy = exponentialBackoffPolicy;
        this.retryExecutor = retryExecutor;
        this.executorService = executorService;
    }

    DefaultWorkloadApiClient(SpiffeWorkloadAPIGrpc.SpiffeWorkloadAPIStub workloadApiAsyncStub, SpiffeWorkloadAPIGrpc.SpiffeWorkloadAPIBlockingStub workloadApiBlockingStub, ManagedChannelWrapper managedChannel, ExponentialBackoffPolicy backoffPolicy) {
        this.workloadApiAsyncStub = workloadApiAsyncStub;
        this.workloadApiBlockingStub = workloadApiBlockingStub;
        this.exponentialBackoffPolicy = backoffPolicy;
        this.executorService = Executors.newCachedThreadPool(daemonThreadFactory);
        this.retryExecutor = Executors.newSingleThreadScheduledExecutor(daemonThreadFactory);
        this.cancellableContexts = Collections.synchronizedList(new ArrayList());
        this.managedChannel = managedChannel;
    }

    public static WorkloadApiClient newClient() throws SocketEndpointAddressException {
        ClientOptions options = ClientOptions.builder().build();
        return DefaultWorkloadApiClient.newClient(options);
    }

    public static WorkloadApiClient newClient(@NonNull ClientOptions options) throws SocketEndpointAddressException {
        if (options == null) {
            throw new NullPointerException("options is marked non-null but is null");
        }
        String spiffeSocketPath = StringUtils.isNotBlank(options.spiffeSocketPath) ? options.spiffeSocketPath : Address.getDefaultAddress();
        URI socketEndpointAddress = Address.parseAddress(spiffeSocketPath);
        ManagedChannelWrapper managedChannel = GrpcManagedChannelFactory.newChannel(socketEndpointAddress, options.executorService);
        SecurityHeaderInterceptor securityHeaderInterceptor = new SecurityHeaderInterceptor();
        SpiffeWorkloadAPIGrpc.SpiffeWorkloadAPIStub workloadAPIAsyncStub = (SpiffeWorkloadAPIGrpc.SpiffeWorkloadAPIStub)((SpiffeWorkloadAPIGrpc.SpiffeWorkloadAPIStub)SpiffeWorkloadAPIGrpc.newStub(managedChannel.getChannel()).withExecutor(options.executorService)).withInterceptors(securityHeaderInterceptor);
        SpiffeWorkloadAPIGrpc.SpiffeWorkloadAPIBlockingStub workloadAPIBlockingStub = (SpiffeWorkloadAPIGrpc.SpiffeWorkloadAPIBlockingStub)((SpiffeWorkloadAPIGrpc.SpiffeWorkloadAPIBlockingStub)SpiffeWorkloadAPIGrpc.newBlockingStub(managedChannel.getChannel()).withExecutor(options.executorService)).withInterceptors(securityHeaderInterceptor);
        return new DefaultWorkloadApiClient(workloadAPIAsyncStub, workloadAPIBlockingStub, managedChannel, options.exponentialBackoffPolicy, options.retryExecutorService, options.executorService);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public X509Context fetchX509Context() throws X509ContextException {
        try (Context.CancellableContext cancellableContext = Context.current().withCancellation();){
            X509Context x509Context = cancellableContext.call(this::callFetchX509Context);
            return x509Context;
        }
        catch (Exception e) {
            throw new X509ContextException("Error fetching X509Context", e);
        }
    }

    @Override
    public void watchX509Context(@NonNull Watcher<X509Context> watcher) {
        if (watcher == null) {
            throw new NullPointerException("watcher is marked non-null but is null");
        }
        RetryHandler retryHandler = new RetryHandler(this.exponentialBackoffPolicy, this.retryExecutor);
        Context.CancellableContext cancellableContext = Context.current().withCancellation();
        StreamObserver<Workload.X509SVIDResponse> streamObserver = StreamObservers.getX509ContextStreamObserver(watcher, retryHandler, cancellableContext, this.workloadApiAsyncStub);
        cancellableContext.run(() -> this.workloadApiAsyncStub.fetchX509SVID(this.newX509SvidRequest(), streamObserver));
        this.cancellableContexts.add(cancellableContext);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public X509BundleSet fetchX509Bundles() throws X509BundleException {
        try (Context.CancellableContext cancellableContext = Context.current().withCancellation();){
            X509BundleSet x509BundleSet = cancellableContext.call(this::callFetchX509Bundles);
            return x509BundleSet;
        }
        catch (Exception e) {
            throw new X509BundleException("Error fetching X.509 bundles", e);
        }
    }

    @Override
    public void watchX509Bundles(@NonNull Watcher<X509BundleSet> watcher) {
        if (watcher == null) {
            throw new NullPointerException("watcher is marked non-null but is null");
        }
        RetryHandler retryHandler = new RetryHandler(this.exponentialBackoffPolicy, this.retryExecutor);
        Context.CancellableContext cancellableContext = Context.current().withCancellation();
        StreamObserver<Workload.X509BundlesResponse> streamObserver = StreamObservers.getX509BundlesStreamObserver(watcher, retryHandler, cancellableContext, this.workloadApiAsyncStub);
        cancellableContext.run(() -> this.workloadApiAsyncStub.fetchX509Bundles(this.newX509BundlesRequest(), streamObserver));
        this.cancellableContexts.add(cancellableContext);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public JwtSvid fetchJwtSvid(@NonNull String audience, String ... extraAudience) throws JwtSvidException {
        if (audience == null) {
            throw new NullPointerException("audience is marked non-null but is null");
        }
        Set<String> audParam = this.createAudienceSet(audience, extraAudience);
        try (Context.CancellableContext cancellableContext = Context.current().withCancellation();){
            JwtSvid jwtSvid = cancellableContext.call(() -> this.callFetchJwtSvid(audParam));
            return jwtSvid;
        }
        catch (Exception e) {
            throw new JwtSvidException("Error fetching JWT SVID", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public JwtSvid fetchJwtSvid(@NonNull SpiffeId subject, @NonNull String audience, String ... extraAudience) throws JwtSvidException {
        if (subject == null) {
            throw new NullPointerException("subject is marked non-null but is null");
        }
        if (audience == null) {
            throw new NullPointerException("audience is marked non-null but is null");
        }
        Set<String> audParam = this.createAudienceSet(audience, extraAudience);
        try (Context.CancellableContext cancellableContext = Context.current().withCancellation();){
            JwtSvid jwtSvid = cancellableContext.call(() -> this.callFetchJwtSvid(subject, audParam));
            return jwtSvid;
        }
        catch (Exception e) {
            throw new JwtSvidException("Error fetching JWT SVID", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public JwtBundleSet fetchJwtBundles() throws JwtBundleException {
        try (Context.CancellableContext cancellableContext = Context.current().withCancellation();){
            JwtBundleSet jwtBundleSet = cancellableContext.call(this::callFetchBundles);
            return jwtBundleSet;
        }
        catch (Exception e) {
            throw new JwtBundleException("Error fetching JWT Bundles", e);
        }
    }

    @Override
    public JwtSvid validateJwtSvid(@NonNull String token, @NonNull String audience) throws JwtSvidException {
        Workload.ValidateJWTSVIDResponse response;
        if (token == null) {
            throw new NullPointerException("token is marked non-null but is null");
        }
        if (audience == null) {
            throw new NullPointerException("audience is marked non-null but is null");
        }
        Workload.ValidateJWTSVIDRequest request = this.createJwtSvidRequest(token, audience);
        try (Context.CancellableContext cancellableContext = Context.current().withCancellation();){
            response = cancellableContext.call(() -> this.workloadApiBlockingStub.validateJWTSVID(request));
        }
        catch (Exception e) {
            throw new JwtSvidException("Error validating JWT SVID", e);
        }
        if (response == null || StringUtils.isBlank(response.getSpiffeId())) {
            throw new JwtSvidException("Error validating JWT SVID. Empty response from Workload API");
        }
        return JwtSvid.parseInsecure(token, Collections.singleton(audience));
    }

    @Override
    public void watchJwtBundles(@NonNull Watcher<JwtBundleSet> watcher) {
        if (watcher == null) {
            throw new NullPointerException("watcher is marked non-null but is null");
        }
        RetryHandler retryHandler = new RetryHandler(this.exponentialBackoffPolicy, this.retryExecutor);
        Context.CancellableContext cancellableContext = Context.current().withCancellation();
        StreamObserver<Workload.JWTBundlesResponse> streamObserver = StreamObservers.getJwtBundleStreamObserver(watcher, retryHandler, cancellableContext, this.workloadApiAsyncStub);
        cancellableContext.run(() -> this.workloadApiAsyncStub.fetchJWTBundles(this.newJwtBundlesRequest(), streamObserver));
        this.cancellableContexts.add(cancellableContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        log.log(Level.FINE, "Closing WorkloadAPI client");
        DefaultWorkloadApiClient defaultWorkloadApiClient = this;
        synchronized (defaultWorkloadApiClient) {
            if (!this.closed) {
                for (Context.CancellableContext context : this.cancellableContexts) {
                    context.close();
                }
                if (this.managedChannel != null) {
                    this.managedChannel.close();
                }
                this.retryExecutor.shutdown();
                this.executorService.shutdown();
                this.closed = true;
            }
        }
        log.log(Level.INFO, "WorkloadAPI client is closed");
    }

    private X509Context callFetchX509Context() throws X509ContextException {
        Iterator<Workload.X509SVIDResponse> x509SvidResponse = this.workloadApiBlockingStub.fetchX509SVID(this.newX509SvidRequest());
        return GrpcConversionUtils.toX509Context(x509SvidResponse);
    }

    private X509BundleSet callFetchX509Bundles() throws X509BundleException {
        Iterator<Workload.X509BundlesResponse> x509BundlesResponse = this.workloadApiBlockingStub.fetchX509Bundles(this.newX509BundlesRequest());
        return GrpcConversionUtils.toX509BundleSet(x509BundlesResponse);
    }

    private JwtSvid callFetchJwtSvid(SpiffeId subject, Set<String> audience) throws JwtSvidException {
        Workload.JWTSVIDRequest jwtSvidRequest = Workload.JWTSVIDRequest.newBuilder().setSpiffeId(subject.toString()).addAllAudience(audience).build();
        Workload.JWTSVIDResponse response = this.workloadApiBlockingStub.fetchJWTSVID(jwtSvidRequest);
        return this.processJwtSvidResponse(response, audience);
    }

    private JwtSvid callFetchJwtSvid(Set<String> audience) throws JwtSvidException {
        Workload.JWTSVIDRequest jwtSvidRequest = Workload.JWTSVIDRequest.newBuilder().addAllAudience(audience).build();
        Workload.JWTSVIDResponse response = this.workloadApiBlockingStub.fetchJWTSVID(jwtSvidRequest);
        return this.processJwtSvidResponse(response, audience);
    }

    private JwtSvid processJwtSvidResponse(Workload.JWTSVIDResponse response, Set<String> audience) throws JwtSvidException {
        if (response.getSvidsList() == null || response.getSvidsList().isEmpty()) {
            throw new JwtSvidException("JWT SVID response from the Workload API is empty");
        }
        return JwtSvid.parseInsecure(response.getSvids(0).getSvid(), audience);
    }

    private JwtBundleSet callFetchBundles() throws JwtBundleException {
        Workload.JWTBundlesRequest request = Workload.JWTBundlesRequest.newBuilder().build();
        Iterator<Workload.JWTBundlesResponse> bundlesResponse = this.workloadApiBlockingStub.fetchJWTBundles(request);
        return GrpcConversionUtils.toJwtBundleSet(bundlesResponse);
    }

    private Set<String> createAudienceSet(String audience, String[] extraAudience) {
        HashSet<String> audParam = new HashSet<String>();
        audParam.add(audience);
        Collections.addAll(audParam, extraAudience);
        return audParam;
    }

    private Workload.X509SVIDRequest newX509SvidRequest() {
        return Workload.X509SVIDRequest.newBuilder().build();
    }

    private Workload.X509BundlesRequest newX509BundlesRequest() {
        return Workload.X509BundlesRequest.newBuilder().build();
    }

    private Workload.JWTBundlesRequest newJwtBundlesRequest() {
        return Workload.JWTBundlesRequest.newBuilder().build();
    }

    private Workload.ValidateJWTSVIDRequest createJwtSvidRequest(String token, String audience) {
        return Workload.ValidateJWTSVIDRequest.newBuilder().setSvid(token).setAudience(audience).build();
    }

    public static class ClientOptions {
        private String spiffeSocketPath;
        @NonNull
        private ExponentialBackoffPolicy exponentialBackoffPolicy;
        @NonNull
        private ExecutorService executorService;
        @NonNull
        private ScheduledExecutorService retryExecutorService;

        @Generated
        private static ExponentialBackoffPolicy $default$exponentialBackoffPolicy() {
            return ExponentialBackoffPolicy.DEFAULT;
        }

        @Generated
        private static ExecutorService $default$executorService() {
            return Executors.newCachedThreadPool(daemonThreadFactory);
        }

        @Generated
        private static ScheduledExecutorService $default$retryExecutorService() {
            return Executors.newSingleThreadScheduledExecutor(daemonThreadFactory);
        }

        @Generated
        ClientOptions(String spiffeSocketPath, @NonNull ExponentialBackoffPolicy exponentialBackoffPolicy, @NonNull ExecutorService executorService, @NonNull ScheduledExecutorService retryExecutorService) {
            if (exponentialBackoffPolicy == null) {
                throw new NullPointerException("exponentialBackoffPolicy is marked non-null but is null");
            }
            if (executorService == null) {
                throw new NullPointerException("executorService is marked non-null but is null");
            }
            if (retryExecutorService == null) {
                throw new NullPointerException("retryExecutorService is marked non-null but is null");
            }
            this.spiffeSocketPath = spiffeSocketPath;
            this.exponentialBackoffPolicy = exponentialBackoffPolicy;
            this.executorService = executorService;
            this.retryExecutorService = retryExecutorService;
        }

        @Generated
        public static ClientOptionsBuilder builder() {
            return new ClientOptionsBuilder();
        }

        @Generated
        public String getSpiffeSocketPath() {
            return this.spiffeSocketPath;
        }

        @NonNull
        @Generated
        public ExponentialBackoffPolicy getExponentialBackoffPolicy() {
            return this.exponentialBackoffPolicy;
        }

        @NonNull
        @Generated
        public ExecutorService getExecutorService() {
            return this.executorService;
        }

        @NonNull
        @Generated
        public ScheduledExecutorService getRetryExecutorService() {
            return this.retryExecutorService;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ClientOptions)) {
                return false;
            }
            ClientOptions other = (ClientOptions)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$spiffeSocketPath = this.getSpiffeSocketPath();
            String other$spiffeSocketPath = other.getSpiffeSocketPath();
            if (this$spiffeSocketPath == null ? other$spiffeSocketPath != null : !this$spiffeSocketPath.equals(other$spiffeSocketPath)) {
                return false;
            }
            ExponentialBackoffPolicy this$exponentialBackoffPolicy = this.getExponentialBackoffPolicy();
            ExponentialBackoffPolicy other$exponentialBackoffPolicy = other.getExponentialBackoffPolicy();
            if (this$exponentialBackoffPolicy == null ? other$exponentialBackoffPolicy != null : !((Object)this$exponentialBackoffPolicy).equals(other$exponentialBackoffPolicy)) {
                return false;
            }
            ExecutorService this$executorService = this.getExecutorService();
            ExecutorService other$executorService = other.getExecutorService();
            if (this$executorService == null ? other$executorService != null : !this$executorService.equals(other$executorService)) {
                return false;
            }
            ScheduledExecutorService this$retryExecutorService = this.getRetryExecutorService();
            ScheduledExecutorService other$retryExecutorService = other.getRetryExecutorService();
            return !(this$retryExecutorService == null ? other$retryExecutorService != null : !this$retryExecutorService.equals(other$retryExecutorService));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ClientOptions;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $spiffeSocketPath = this.getSpiffeSocketPath();
            result = result * 59 + ($spiffeSocketPath == null ? 43 : $spiffeSocketPath.hashCode());
            ExponentialBackoffPolicy $exponentialBackoffPolicy = this.getExponentialBackoffPolicy();
            result = result * 59 + ($exponentialBackoffPolicy == null ? 43 : ((Object)$exponentialBackoffPolicy).hashCode());
            ExecutorService $executorService = this.getExecutorService();
            result = result * 59 + ($executorService == null ? 43 : $executorService.hashCode());
            ScheduledExecutorService $retryExecutorService = this.getRetryExecutorService();
            result = result * 59 + ($retryExecutorService == null ? 43 : $retryExecutorService.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "DefaultWorkloadApiClient.ClientOptions(spiffeSocketPath=" + this.getSpiffeSocketPath() + ", exponentialBackoffPolicy=" + this.getExponentialBackoffPolicy() + ", executorService=" + this.getExecutorService() + ", retryExecutorService=" + this.getRetryExecutorService() + ")";
        }

        @Generated
        public static class ClientOptionsBuilder {
            @Generated
            private String spiffeSocketPath;
            @Generated
            private boolean exponentialBackoffPolicy$set;
            @Generated
            private ExponentialBackoffPolicy exponentialBackoffPolicy$value;
            @Generated
            private boolean executorService$set;
            @Generated
            private ExecutorService executorService$value;
            @Generated
            private boolean retryExecutorService$set;
            @Generated
            private ScheduledExecutorService retryExecutorService$value;

            @Generated
            ClientOptionsBuilder() {
            }

            @Generated
            public ClientOptionsBuilder spiffeSocketPath(String spiffeSocketPath) {
                this.spiffeSocketPath = spiffeSocketPath;
                return this;
            }

            @Generated
            public ClientOptionsBuilder exponentialBackoffPolicy(@NonNull ExponentialBackoffPolicy exponentialBackoffPolicy) {
                if (exponentialBackoffPolicy == null) {
                    throw new NullPointerException("exponentialBackoffPolicy is marked non-null but is null");
                }
                this.exponentialBackoffPolicy$value = exponentialBackoffPolicy;
                this.exponentialBackoffPolicy$set = true;
                return this;
            }

            @Generated
            public ClientOptionsBuilder executorService(@NonNull ExecutorService executorService) {
                if (executorService == null) {
                    throw new NullPointerException("executorService is marked non-null but is null");
                }
                this.executorService$value = executorService;
                this.executorService$set = true;
                return this;
            }

            @Generated
            public ClientOptionsBuilder retryExecutorService(@NonNull ScheduledExecutorService retryExecutorService) {
                if (retryExecutorService == null) {
                    throw new NullPointerException("retryExecutorService is marked non-null but is null");
                }
                this.retryExecutorService$value = retryExecutorService;
                this.retryExecutorService$set = true;
                return this;
            }

            @Generated
            public ClientOptions build() {
                ExponentialBackoffPolicy exponentialBackoffPolicy$value = this.exponentialBackoffPolicy$value;
                if (!this.exponentialBackoffPolicy$set) {
                    exponentialBackoffPolicy$value = ClientOptions.$default$exponentialBackoffPolicy();
                }
                ExecutorService executorService$value = this.executorService$value;
                if (!this.executorService$set) {
                    executorService$value = ClientOptions.$default$executorService();
                }
                ScheduledExecutorService retryExecutorService$value = this.retryExecutorService$value;
                if (!this.retryExecutorService$set) {
                    retryExecutorService$value = ClientOptions.$default$retryExecutorService();
                }
                return new ClientOptions(this.spiffeSocketPath, exponentialBackoffPolicy$value, executorService$value, retryExecutorService$value);
            }

            @Generated
            public String toString() {
                return "DefaultWorkloadApiClient.ClientOptions.ClientOptionsBuilder(spiffeSocketPath=" + this.spiffeSocketPath + ", exponentialBackoffPolicy$value=" + this.exponentialBackoffPolicy$value + ", executorService$value=" + this.executorService$value + ", retryExecutorService$value=" + this.retryExecutorService$value + ")";
            }
        }
    }
}

