/*
 * Decompiled with CFR 0.152.
 */
package org.byted.security.zti.jwt.shaded.io.spiffe.workloadapi;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.byted.security.zti.jwt.shaded.io.grpc.Context;
import org.byted.security.zti.jwt.shaded.io.grpc.Status;
import org.byted.security.zti.jwt.shaded.io.grpc.stub.StreamObserver;
import org.byted.security.zti.jwt.shaded.io.spiffe.bundle.jwtbundle.JwtBundleSet;
import org.byted.security.zti.jwt.shaded.io.spiffe.bundle.x509bundle.X509BundleSet;
import org.byted.security.zti.jwt.shaded.io.spiffe.exception.JwtBundleException;
import org.byted.security.zti.jwt.shaded.io.spiffe.exception.X509BundleException;
import org.byted.security.zti.jwt.shaded.io.spiffe.exception.X509ContextException;
import org.byted.security.zti.jwt.shaded.io.spiffe.workloadapi.GrpcConversionUtils;
import org.byted.security.zti.jwt.shaded.io.spiffe.workloadapi.Watcher;
import org.byted.security.zti.jwt.shaded.io.spiffe.workloadapi.X509Context;
import org.byted.security.zti.jwt.shaded.io.spiffe.workloadapi.grpc.SpiffeWorkloadAPIGrpc;
import org.byted.security.zti.jwt.shaded.io.spiffe.workloadapi.grpc.Workload;
import org.byted.security.zti.jwt.shaded.io.spiffe.workloadapi.retry.RetryHandler;
import shaded.bytehouse.lombok.Generated;

final class StreamObservers {
    @Generated
    private static final Logger log = Logger.getLogger(StreamObservers.class.getName());
    private static final String INVALID_ARGUMENT = "INVALID_ARGUMENT";
    private static final String STREAM_IS_COMPLETED = "Workload API stream is completed";

    private StreamObservers() {
    }

    static StreamObserver<Workload.X509SVIDResponse> getX509ContextStreamObserver(final Watcher<X509Context> watcher, final RetryHandler retryHandler, final Context.CancellableContext cancellableContext, final SpiffeWorkloadAPIGrpc.SpiffeWorkloadAPIStub workloadApiAsyncStub) {
        return new StreamObserver<Workload.X509SVIDResponse>(){

            @Override
            public void onNext(Workload.X509SVIDResponse value) {
                try {
                    X509Context x509Context = GrpcConversionUtils.toX509Context(value);
                    watcher.onUpdate(x509Context);
                    retryHandler.reset();
                }
                catch (X509ContextException e) {
                    watcher.onError(new X509ContextException("Error processing X.509 Context update", e));
                }
            }

            @Override
            public void onError(Throwable t2) {
                log.log(Level.SEVERE, "X.509 context observer error", t2);
                this.handleWatchX509ContextError(t2);
            }

            private void handleWatchX509ContextError(Throwable t2) {
                if (StreamObservers.isErrorNotRetryable(t2)) {
                    watcher.onError(new X509ContextException("Cancelling X.509 Context watch", t2));
                } else {
                    this.handleX509ContextRetry(t2);
                }
            }

            private void handleX509ContextRetry(Throwable t2) {
                if (retryHandler.shouldRetry()) {
                    log.log(Level.INFO, "Retrying connecting to Workload API to register X.509 context watcher");
                    retryHandler.scheduleRetry(() -> cancellableContext.run(() -> workloadApiAsyncStub.fetchX509SVID(StreamObservers.newX509SvidRequest(), this)));
                } else {
                    watcher.onError(new X509ContextException("Cancelling X.509 Context watch", t2));
                }
            }

            @Override
            public void onCompleted() {
                cancellableContext.close();
                log.info(StreamObservers.STREAM_IS_COMPLETED);
            }
        };
    }

    static StreamObserver<Workload.X509BundlesResponse> getX509BundlesStreamObserver(final Watcher<X509BundleSet> watcher, final RetryHandler retryHandler, final Context.CancellableContext cancellableContext, final SpiffeWorkloadAPIGrpc.SpiffeWorkloadAPIStub workloadApiAsyncStub) {
        return new StreamObserver<Workload.X509BundlesResponse>(){

            @Override
            public void onNext(Workload.X509BundlesResponse value) {
                try {
                    X509BundleSet x509Context = GrpcConversionUtils.toX509BundleSet(value);
                    watcher.onUpdate(x509Context);
                    retryHandler.reset();
                }
                catch (X509BundleException e) {
                    watcher.onError(new X509ContextException("Error processing X.509 bundles update", e));
                }
            }

            @Override
            public void onError(Throwable t2) {
                log.log(Level.SEVERE, "X.509 bundles observer error", t2);
                this.handleWatchX509BundlesError(t2);
            }

            private void handleWatchX509BundlesError(Throwable t2) {
                if (StreamObservers.isErrorNotRetryable(t2)) {
                    watcher.onError(new X509ContextException("Cancelling X.509 bundles watch", t2));
                } else {
                    this.handleX509BundlesRetry(t2);
                }
            }

            private void handleX509BundlesRetry(Throwable t2) {
                if (retryHandler.shouldRetry()) {
                    log.log(Level.INFO, "Retrying connecting to Workload API to register X.509 bundles watcher");
                    retryHandler.scheduleRetry(() -> cancellableContext.run(() -> workloadApiAsyncStub.fetchX509Bundles(StreamObservers.newX509BundlesRequest(), this)));
                } else {
                    watcher.onError(new X509BundleException("Cancelling X.509 bundles watch", t2));
                }
            }

            @Override
            public void onCompleted() {
                cancellableContext.close();
                log.info(StreamObservers.STREAM_IS_COMPLETED);
            }
        };
    }

    static StreamObserver<Workload.JWTBundlesResponse> getJwtBundleStreamObserver(final Watcher<JwtBundleSet> watcher, final RetryHandler retryHandler, final Context.CancellableContext cancellableContext, final SpiffeWorkloadAPIGrpc.SpiffeWorkloadAPIStub workloadApiAsyncStub) {
        return new StreamObserver<Workload.JWTBundlesResponse>(){

            @Override
            public void onNext(Workload.JWTBundlesResponse value) {
                try {
                    JwtBundleSet jwtBundleSet = GrpcConversionUtils.toJwtBundleSet(value);
                    watcher.onUpdate(jwtBundleSet);
                    retryHandler.reset();
                }
                catch (JwtBundleException e) {
                    watcher.onError(new JwtBundleException("Error processing JWT bundles update", e));
                }
            }

            @Override
            public void onError(Throwable t2) {
                log.log(Level.SEVERE, "JWT observer error", t2);
                this.handleWatchJwtBundleError(t2);
            }

            private void handleWatchJwtBundleError(Throwable t2) {
                if (StreamObservers.isErrorNotRetryable(t2)) {
                    watcher.onError(new JwtBundleException("Cancelling JWT Bundles watch", t2));
                } else {
                    this.handleJwtBundleRetry(t2);
                }
            }

            private void handleJwtBundleRetry(Throwable t2) {
                if (retryHandler.shouldRetry()) {
                    log.log(Level.INFO, "Retrying connecting to Workload API to register JWT Bundles watcher");
                    retryHandler.scheduleRetry(() -> cancellableContext.run(() -> workloadApiAsyncStub.fetchJWTBundles(StreamObservers.newJwtBundlesRequest(), this)));
                } else {
                    watcher.onError(new JwtBundleException("Cancelling JWT Bundles watch", t2));
                }
            }

            @Override
            public void onCompleted() {
                cancellableContext.close();
                log.info(StreamObservers.STREAM_IS_COMPLETED);
            }
        };
    }

    private static boolean isErrorNotRetryable(Throwable t2) {
        return INVALID_ARGUMENT.equals(Status.fromThrowable(t2).getCode().name());
    }

    private static Workload.X509SVIDRequest newX509SvidRequest() {
        return Workload.X509SVIDRequest.newBuilder().build();
    }

    private static Workload.X509BundlesRequest newX509BundlesRequest() {
        return Workload.X509BundlesRequest.newBuilder().build();
    }

    private static Workload.JWTBundlesRequest newJwtBundlesRequest() {
        return Workload.JWTBundlesRequest.newBuilder().build();
    }
}

